/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.Pagamento;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class PagamentoDTO {
    private Long entidade;
    private Long exercicioPagamento;
    private Long pagamento;
    private Long exercicioLote;
    private Long lote;
    private Long sequenciaLote;
    private Long pessoaId;
    private String nome;
    private LocalDate dataMovimento;
    private LocalDate dataPagamento;
    private BigDecimal valorPago = BigDecimal.ZERO;
    private Boolean estorno;
    private Boolean usadoEmAcerto = Boolean.FALSE;

    public static PagamentoDTO of(Pagamento pagamento) {
        PagamentoDTO dto = new PagamentoDTO();
        dto.setEntidade(pagamento.getId().getEntidade());
        dto.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        dto.setPagamento(pagamento.getId().getPagamento());
        dto.setExercicioLote(pagamento.getLote().getId().getExercicio());
        dto.setLote(pagamento.getLote().getId().getLote());
        dto.setSequenciaLote(pagamento.getSequenciaLote());
        if (Objects.nonNull(pagamento.getPagamentoBoleto())) {
            dto.setNome(pagamento.getPagamentoBoleto().getBoleto().getPessoa().getNome());
            dto.setPessoaId(pagamento.getPagamentoBoleto().getBoleto().getPessoa().getId());
            if (Objects.nonNull(pagamento.getPagamentoBoleto().getPagamentosDebito())) {
                pagamento.getPagamentoBoleto().getPagamentosDebito().stream().findFirst().ifPresent(debitos -> dto.setEstorno(debitos.getEstorno()));
            }
        }
        dto.setDataPagamento(pagamento.getDataPagamento());
        dto.setDataMovimento(pagamento.getDataMovimento());
        dto.setValorPago(pagamento.getValorPago());
        return dto;
    }

    @Generated
    public PagamentoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public Long getPagamento() {
        return this.pagamento;
    }

    @Generated
    public Long getExercicioLote() {
        return this.exercicioLote;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public Long getSequenciaLote() {
        return this.sequenciaLote;
    }

    @Generated
    public Long getPessoaId() {
        return this.pessoaId;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public Boolean getEstorno() {
        return this.estorno;
    }

    @Generated
    public Boolean getUsadoEmAcerto() {
        return this.usadoEmAcerto;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setPagamento(Long pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setExercicioLote(Long exercicioLote) {
        this.exercicioLote = exercicioLote;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setSequenciaLote(Long sequenciaLote) {
        this.sequenciaLote = sequenciaLote;
    }

    @Generated
    public void setPessoaId(Long pessoaId) {
        this.pessoaId = pessoaId;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setEstorno(Boolean estorno) {
        this.estorno = estorno;
    }

    @Generated
    public void setUsadoEmAcerto(Boolean usadoEmAcerto) {
        this.usadoEmAcerto = usadoEmAcerto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoDTO)) {
            return false;
        }
        PagamentoDTO other = (PagamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicioPagamento = this.getExercicioPagamento();
        Long other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !((Object)this$exercicioPagamento).equals(other$exercicioPagamento)) {
            return false;
        }
        Long this$pagamento = this.getPagamento();
        Long other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        Long this$exercicioLote = this.getExercicioLote();
        Long other$exercicioLote = other.getExercicioLote();
        if (this$exercicioLote == null ? other$exercicioLote != null : !((Object)this$exercicioLote).equals(other$exercicioLote)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$sequenciaLote = this.getSequenciaLote();
        Long other$sequenciaLote = other.getSequenciaLote();
        if (this$sequenciaLote == null ? other$sequenciaLote != null : !((Object)this$sequenciaLote).equals(other$sequenciaLote)) {
            return false;
        }
        Long this$pessoaId = this.getPessoaId();
        Long other$pessoaId = other.getPessoaId();
        if (this$pessoaId == null ? other$pessoaId != null : !((Object)this$pessoaId).equals(other$pessoaId)) {
            return false;
        }
        Boolean this$estorno = this.getEstorno();
        Boolean other$estorno = other.getEstorno();
        if (this$estorno == null ? other$estorno != null : !((Object)this$estorno).equals(other$estorno)) {
            return false;
        }
        Boolean this$usadoEmAcerto = this.getUsadoEmAcerto();
        Boolean other$usadoEmAcerto = other.getUsadoEmAcerto();
        if (this$usadoEmAcerto == null ? other$usadoEmAcerto != null : !((Object)this$usadoEmAcerto).equals(other$usadoEmAcerto)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        BigDecimal this$valorPago = this.getValorPago();
        BigDecimal other$valorPago = other.getValorPago();
        return !(this$valorPago == null ? other$valorPago != null : !((Object)this$valorPago).equals(other$valorPago));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : ((Object)$exercicioPagamento).hashCode());
        Long $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        Long $exercicioLote = this.getExercicioLote();
        result = result * 59 + ($exercicioLote == null ? 43 : ((Object)$exercicioLote).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $sequenciaLote = this.getSequenciaLote();
        result = result * 59 + ($sequenciaLote == null ? 43 : ((Object)$sequenciaLote).hashCode());
        Long $pessoaId = this.getPessoaId();
        result = result * 59 + ($pessoaId == null ? 43 : ((Object)$pessoaId).hashCode());
        Boolean $estorno = this.getEstorno();
        result = result * 59 + ($estorno == null ? 43 : ((Object)$estorno).hashCode());
        Boolean $usadoEmAcerto = this.getUsadoEmAcerto();
        result = result * 59 + ($usadoEmAcerto == null ? 43 : ((Object)$usadoEmAcerto).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        BigDecimal $valorPago = this.getValorPago();
        result = result * 59 + ($valorPago == null ? 43 : ((Object)$valorPago).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoDTO(entidade=" + this.getEntidade() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", pagamento=" + this.getPagamento() + ", exercicioLote=" + this.getExercicioLote() + ", lote=" + this.getLote() + ", sequenciaLote=" + this.getSequenciaLote() + ", pessoaId=" + this.getPessoaId() + ", nome=" + this.getNome() + ", dataMovimento=" + this.getDataMovimento() + ", dataPagamento=" + this.getDataPagamento() + ", valorPago=" + this.getValorPago() + ", estorno=" + this.getEstorno() + ", usadoEmAcerto=" + this.getUsadoEmAcerto() + ")";
    }
}

