/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.TipoTributo;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroArrecadacaoPorTributoDTO {
    @NotNull
    private LocalDate dataLancamento;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String anoDivida;
    private String divida;
    private String subDivida;
    private TipoTributo tipoTributo;
    private ContaBancaria contaBancaria;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String getWhereClausule() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAND(String.format("DEBITOPARCELARECEITA.TIPOCADASTRO = %d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"DEBITOPARCELARECEITA.CADASTROGERAL")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.anoDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoDivida, (String)"DEBITOPARCELARECEITA.EXERCICIO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"DEBITOPARCELARECEITA.GUIARECOLHIMENTO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"DEBITOPARCELARECEITA.SUBDIVIDA")));
        }
        if (Objects.nonNull(this.tipoTributo)) {
            where.append(this.addAND(String.format("RECEITA.TIPORECEITA = %d", this.tipoTributo.getId())));
        }
        if (Objects.nonNull(this.contaBancaria)) {
            where.append(this.addAND(String.format("CONTABANCARIA.CONTABANCARIA = %d", this.contaBancaria.getContaBancaria())));
        }
        return where.toString();
    }

    @Generated
    public FiltroArrecadacaoPorTributoDTO() {
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDivida() {
        return this.anoDivida;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDivida(String anoDivida) {
        this.anoDivida = anoDivida;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroArrecadacaoPorTributoDTO)) {
            return false;
        }
        FiltroArrecadacaoPorTributoDTO other = (FiltroArrecadacaoPorTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDivida = this.getAnoDivida();
        String other$anoDivida = other.getAnoDivida();
        if (this$anoDivida == null ? other$anoDivida != null : !this$anoDivida.equals(other$anoDivida)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        TipoTributo this$tipoTributo = this.getTipoTributo();
        TipoTributo other$tipoTributo = other.getTipoTributo();
        if (this$tipoTributo == null ? other$tipoTributo != null : !this$tipoTributo.equals(other$tipoTributo)) {
            return false;
        }
        ContaBancaria this$contaBancaria = this.getContaBancaria();
        ContaBancaria other$contaBancaria = other.getContaBancaria();
        return !(this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroArrecadacaoPorTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDivida = this.getAnoDivida();
        result = result * 59 + ($anoDivida == null ? 43 : $anoDivida.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        TipoTributo $tipoTributo = this.getTipoTributo();
        result = result * 59 + ($tipoTributo == null ? 43 : $tipoTributo.hashCode());
        ContaBancaria $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroArrecadacaoPorTributoDTO(dataLancamento=" + this.getDataLancamento() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDivida=" + this.getAnoDivida() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", tipoTributo=" + this.getTipoTributo() + ", contaBancaria=" + this.getContaBancaria() + ")";
    }
}

