/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DebitoTributoIsencao;
import br.com.elotech.tributos.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.dto.debito.DebitoTributoDTO;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class DebitoManualTributoDTO {
    private Long ordem;
    private String tributo;
    @NotNull(message="O valor do tributo \u00e9 obrigat\u00f3rio")
    private @NotNull(message="O valor do tributo \u00e9 obrigat\u00f3rio") BigDecimal valorTributo = BigDecimal.ZERO;
    @NotNull(message="O valor da renuncia \u00e9 obrigat\u00f3rio")
    private @NotNull(message="O valor da renuncia \u00e9 obrigat\u00f3rio") BigDecimal valorRenuncia = BigDecimal.ZERO;
    @NotNull(message="O valor da base de c\u00e1lculo \u00e9 obrigat\u00f3rio")
    private @NotNull(message="O valor da base de c\u00e1lculo \u00e9 obrigat\u00f3rio") BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;

    public static final DebitoTributo toEntity(DebitoManualTributoDTO tributoDTO) {
        DebitoTributo tributo = new DebitoTributo();
        DebitoTributoId id = new DebitoTributoId();
        id.setTributo(tributoDTO.getTributo());
        tributo.setId(id);
        tributo.setOrdem(tributoDTO.getOrdem());
        tributo.setValorBaseCalculo(tributoDTO.getValorBaseCalculo());
        tributo.setValorRenuncia(tributoDTO.getValorRenuncia());
        tributo.setValorTributo(tributoDTO.getValorTributo());
        if (Objects.nonNull(tributoDTO.getValorDesconto()) && BigDecimal.ZERO.compareTo(tributoDTO.getValorDesconto()) < 0) {
            tributo.setValorDescontoPrincipal(tributoDTO.getValorDesconto());
            tributo.getIsencoes().add(DebitoTributoIsencao.from((DebitoTributo)tributo, (BigDecimal)tributoDTO.getValorDesconto()));
        }
        return tributo;
    }

    public static DebitoManualTributoDTO from(DebitoTributoDTO tributo, GerarDebitoRequestDTO debito) {
        DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
        debitoManualTributoDTO.setTributo(tributo.getTributo());
        debitoManualTributoDTO.setValorTributo(tributo.getValorPrincipal());
        debitoManualTributoDTO.setValorDesconto(debito.getValorIsencao());
        debitoManualTributoDTO.setValorBaseCalculo(tributo.getValorBaseCalculo());
        return debitoManualTributoDTO;
    }

    @Generated
    public DebitoManualTributoDTO() {
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public BigDecimal getValorTributo() {
        return this.valorTributo;
    }

    @Generated
    public BigDecimal getValorRenuncia() {
        return this.valorRenuncia;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setValorTributo(BigDecimal valorTributo) {
        this.valorTributo = valorTributo;
    }

    @Generated
    public void setValorRenuncia(BigDecimal valorRenuncia) {
        this.valorRenuncia = valorRenuncia;
    }

    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoManualTributoDTO)) {
            return false;
        }
        DebitoManualTributoDTO other = (DebitoManualTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$ordem = this.getOrdem();
        Long other$ordem = other.getOrdem();
        if (this$ordem == null ? other$ordem != null : !((Object)this$ordem).equals(other$ordem)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        BigDecimal this$valorTributo = this.getValorTributo();
        BigDecimal other$valorTributo = other.getValorTributo();
        if (this$valorTributo == null ? other$valorTributo != null : !((Object)this$valorTributo).equals(other$valorTributo)) {
            return false;
        }
        BigDecimal this$valorRenuncia = this.getValorRenuncia();
        BigDecimal other$valorRenuncia = other.getValorRenuncia();
        if (this$valorRenuncia == null ? other$valorRenuncia != null : !((Object)this$valorRenuncia).equals(other$valorRenuncia)) {
            return false;
        }
        BigDecimal this$valorBaseCalculo = this.getValorBaseCalculo();
        BigDecimal other$valorBaseCalculo = other.getValorBaseCalculo();
        if (this$valorBaseCalculo == null ? other$valorBaseCalculo != null : !((Object)this$valorBaseCalculo).equals(other$valorBaseCalculo)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        return !(this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoManualTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ordem = this.getOrdem();
        result = result * 59 + ($ordem == null ? 43 : ((Object)$ordem).hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        BigDecimal $valorTributo = this.getValorTributo();
        result = result * 59 + ($valorTributo == null ? 43 : ((Object)$valorTributo).hashCode());
        BigDecimal $valorRenuncia = this.getValorRenuncia();
        result = result * 59 + ($valorRenuncia == null ? 43 : ((Object)$valorRenuncia).hashCode());
        BigDecimal $valorBaseCalculo = this.getValorBaseCalculo();
        result = result * 59 + ($valorBaseCalculo == null ? 43 : ((Object)$valorBaseCalculo).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoManualTributoDTO(ordem=" + this.getOrdem() + ", tributo=" + this.getTributo() + ", valorTributo=" + this.getValorTributo() + ", valorRenuncia=" + this.getValorRenuncia() + ", valorBaseCalculo=" + this.getValorBaseCalculo() + ", valorDesconto=" + this.getValorDesconto() + ")";
    }
}

