/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.ws.rest.dto.DebitoGenericDTO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

public class DebitoDTO
extends DebitoGenericDTO {
    private String descricaoSituacao;
    private Boolean emiteBloqueto;
    private Long parcela;
    private String situacao;
    private Long idParcelamento;
    private Long numeroContrato;
    private Integer anoContrato;
    private String tipoContrato;
    private Boolean proprio;
    private Long idDebito;
    private Integer numeroParcelas;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private List<DebitoDTO> debitos;
    private LocalDate vencimento;
    private LocalDate dataLancamento;
    private Integer situacaoLegal;

    public Long getIdDebito() {
        return this.idDebito;
    }

    public String getDescricaoSituacao() {
        return this.descricaoSituacao;
    }

    public String getDescricaoVisualizacao() {
        if (this.contemNumeroContrato().booleanValue()) {
            return "Contrato (" + this.getNumeroContrato() + ") de parcelamento" + " - " + this.getAnoContrato();
        }
        return this.getFormatedDescricaoGuiaExercicio();
    }

    public String getDescricaoExercicio() {
        return this.getFormatedDescricaoGuiaExercicio();
    }

    private String getFormatedDescricaoGuiaExercicio() {
        if (this.contemDescricaoGuia().booleanValue()) {
            return String.format("%d %d-%s Sub-%d", this.getExercicio(), this.getGuiaRecolhimento(), this.getDescricaoGuia(), this.getSubDivida());
        }
        return null;
    }

    public void setDescricaoSituacao(String descricaoSituacao) {
        this.descricaoSituacao = descricaoSituacao;
    }

    public Boolean getEmiteBloqueto() {
        return this.emiteBloqueto;
    }

    public void setEmiteBloqueto(Boolean emiteBloqueto) {
        this.emiteBloqueto = emiteBloqueto;
    }

    public Long getParcela() {
        return this.parcela;
    }

    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public LocalDate getVencimento() {
        return this.vencimento;
    }

    public void setVencimento(LocalDate vencimento) {
        this.vencimento = vencimento;
    }

    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    public Boolean contemIdParcelamento() {
        return this.idParcelamento != null && this.idParcelamento != 0L;
    }

    public Boolean naoContemIdParcelamento() {
        return this.contemIdParcelamento() == false;
    }

    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    public Boolean contemNumeroContrato() {
        return this.numeroContrato != null && this.numeroContrato != 0L;
    }

    public Boolean naoContemNumeroContrato() {
        return this.contemNumeroContrato() == false;
    }

    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = anoContrato;
    }

    public String getTipoContrato() {
        return this.tipoContrato;
    }

    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    public List<DebitoDTO> getDebitos() {
        return this.debitos;
    }

    public void setDebitos(List<DebitoDTO> debitos) {
        this.debitos = debitos;
    }

    public void addDebito(DebitoDTO debito) {
        if (this.debitos == null) {
            this.debitos = Lists.newArrayList();
        }
        this.debitos.add(debito);
    }

    public void somaValor(DebitoDTO debito) {
        this.setValor(this.getValor().add(debito.getValor()));
    }

    public Boolean getProprio() {
        return this.proprio;
    }

    public void setProprio(Boolean proprio) {
        this.proprio = proprio;
    }

    public Boolean getVencido() {
        return DateUtils.isVencido((LocalDate)this.vencimento);
    }

    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    public void setNumeroParcelas(Integer numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public Integer getSituacaoLegal() {
        return this.situacaoLegal;
    }

    public void setSituacaoLegal(Integer situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoDTO)) {
            return false;
        }
        DebitoDTO other = (DebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$emiteBloqueto = this.getEmiteBloqueto();
        Boolean other$emiteBloqueto = other.getEmiteBloqueto();
        if (this$emiteBloqueto == null ? other$emiteBloqueto != null : !((Object)this$emiteBloqueto).equals(other$emiteBloqueto)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Boolean this$proprio = this.getProprio();
        Boolean other$proprio = other.getProprio();
        if (this$proprio == null ? other$proprio != null : !((Object)this$proprio).equals(other$proprio)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Integer this$numeroParcelas = this.getNumeroParcelas();
        Integer other$numeroParcelas = other.getNumeroParcelas();
        if (this$numeroParcelas == null ? other$numeroParcelas != null : !((Object)this$numeroParcelas).equals(other$numeroParcelas)) {
            return false;
        }
        Integer this$situacaoLegal = this.getSituacaoLegal();
        Integer other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        String this$descricaoSituacao = this.getDescricaoSituacao();
        String other$descricaoSituacao = other.getDescricaoSituacao();
        if (this$descricaoSituacao == null ? other$descricaoSituacao != null : !this$descricaoSituacao.equals(other$descricaoSituacao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        LocalDate this$vencimento = this.getVencimento();
        LocalDate other$vencimento = other.getVencimento();
        if (this$vencimento == null ? other$vencimento != null : !((Object)this$vencimento).equals(other$vencimento)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        return !(this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $emiteBloqueto = this.getEmiteBloqueto();
        result = result * 59 + ($emiteBloqueto == null ? 43 : ((Object)$emiteBloqueto).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Boolean $proprio = this.getProprio();
        result = result * 59 + ($proprio == null ? 43 : ((Object)$proprio).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Integer $numeroParcelas = this.getNumeroParcelas();
        result = result * 59 + ($numeroParcelas == null ? 43 : ((Object)$numeroParcelas).hashCode());
        Integer $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        String $descricaoSituacao = this.getDescricaoSituacao();
        result = result * 59 + ($descricaoSituacao == null ? 43 : $descricaoSituacao.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        LocalDate $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : ((Object)$vencimento).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoDTO(super=" + super.toString() + ", descricaoSituacao=" + this.getDescricaoSituacao() + ", emiteBloqueto=" + this.getEmiteBloqueto() + ", parcela=" + this.getParcela() + ", situacao=" + this.getSituacao() + ", idParcelamento=" + this.getIdParcelamento() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ", tipoContrato=" + this.getTipoContrato() + ", proprio=" + this.getProprio() + ", idDebito=" + this.getIdDebito() + ", numeroParcelas=" + this.getNumeroParcelas() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", debitos=" + this.getDebitos() + ", vencimento=" + this.getVencimento() + ", dataLancamento=" + this.getDataLancamento() + ", situacaoLegal=" + this.getSituacaoLegal() + ")";
    }
}

