/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.enums.OrigemComunicado;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.springframework.batch.core.JobParameters;

public class ComunicadoDTO {
    private Long entidade;
    private Long exercicio;
    private Long idComunicado;
    private Long comunicado;
    private String descricao;
    private OrigemComunicado origem;
    private JobParameters jobParameters;
    private byte[] texto;
    private LocalDate dataGeracao;
    private LocalDate dataValidade;
    private TipoNotificacaoComunicado tipoNotificacao;
    private String usuario;
    @JsonIgnoreProperties(value={"sequencias"})
    private Relatorio relatorio;
    private Boolean enderecoValidado;
    private SituacaoComunicado situacao;
    private String idArquivoImpressao;

    public static ComunicadoDTO from(Comunicado comunicado) {
        ComunicadoDTO dto = new ComunicadoDTO();
        dto.setEntidade(comunicado.getId().getEntidade());
        dto.setExercicio(comunicado.getId().getExercicio());
        dto.setIdComunicado(comunicado.getId().getIdComunicado());
        dto.setTipoNotificacao(comunicado.getTipoNotificacao());
        dto.setComunicado(comunicado.getComunicado());
        dto.setTexto(comunicado.getTexto());
        dto.setDescricao(comunicado.getDescricao());
        dto.setOrigem(comunicado.getOrigem());
        dto.setSituacao(comunicado.getSituacao());
        dto.setDataValidade(comunicado.getDataValidade());
        dto.setDataGeracao(comunicado.getDataGeracao());
        dto.setRelatorio(comunicado.getRelatorio());
        dto.setUsuario(comunicado.getUsuario());
        dto.setEnderecoValidado(comunicado.getEnderecoValidado());
        Optional.ofNullable(comunicado.getIdArquivoImpressao()).ifPresent(idArquivoImpressao -> dto.setIdArquivoImpressao(comunicado.getIdArquivoImpressao().toString()));
        return dto;
    }

    @Generated
    public ComunicadoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getIdComunicado() {
        return this.idComunicado;
    }

    @Generated
    public Long getComunicado() {
        return this.comunicado;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public OrigemComunicado getOrigem() {
        return this.origem;
    }

    @Generated
    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    @Generated
    public byte[] getTexto() {
        return this.texto;
    }

    @Generated
    public LocalDate getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public TipoNotificacaoComunicado getTipoNotificacao() {
        return this.tipoNotificacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public Boolean getEnderecoValidado() {
        return this.enderecoValidado;
    }

    @Generated
    public SituacaoComunicado getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getIdArquivoImpressao() {
        return this.idArquivoImpressao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setIdComunicado(Long idComunicado) {
        this.idComunicado = idComunicado;
    }

    @Generated
    public void setComunicado(Long comunicado) {
        this.comunicado = comunicado;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setOrigem(OrigemComunicado origem) {
        this.origem = origem;
    }

    @Generated
    public void setJobParameters(JobParameters jobParameters) {
        this.jobParameters = jobParameters;
    }

    @Generated
    public void setTexto(byte[] texto) {
        this.texto = texto;
    }

    @Generated
    public void setDataGeracao(LocalDate dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setTipoNotificacao(TipoNotificacaoComunicado tipoNotificacao) {
        this.tipoNotificacao = tipoNotificacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @JsonIgnoreProperties(value={"sequencias"})
    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setEnderecoValidado(Boolean enderecoValidado) {
        this.enderecoValidado = enderecoValidado;
    }

    @Generated
    public void setSituacao(SituacaoComunicado situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setIdArquivoImpressao(String idArquivoImpressao) {
        this.idArquivoImpressao = idArquivoImpressao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComunicadoDTO)) {
            return false;
        }
        ComunicadoDTO other = (ComunicadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$idComunicado = this.getIdComunicado();
        Long other$idComunicado = other.getIdComunicado();
        return !(this$idComunicado == null ? other$idComunicado != null : !((Object)this$idComunicado).equals(other$idComunicado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComunicadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $idComunicado = this.getIdComunicado();
        result = result * 59 + ($idComunicado == null ? 43 : ((Object)$idComunicado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComunicadoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", idComunicado=" + this.getIdComunicado() + ")";
    }
}

