/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ArrecadacaoPorTipoFiltroDTO {
    @NotNull
    @Caption(value="Data de Movimenta\u00e7\u00e3o")
    private LocalDate dataMovimentacao;
    private ArrecadacaoPorTipo tipo;
    private Long contaBancaria;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subDivida;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    public String buildFiltro() {
        StringBuilder filtro = new StringBuilder();
        LocalDate dataTemporaria = Optional.ofNullable(this.dataMovimentacao).orElseThrow(() -> new EloValidationException("\u00c9 obrigat\u00f3rio o preenchimento da Data de Movimenta\u00e7\u00e3o."));
        filtro.append(String.format("WHERE x.dataMovimentacao = '%s'", DateUtils.localDateToString((LocalDate)dataTemporaria)));
        if (Objects.nonNull(this.contaBancaria)) {
            filtro.append(this.addAND(String.format("x.contaBancaria = %d", this.contaBancaria)));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("x.tipoCadastro = %d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"x.cadastroGeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"x.exercicioDebito")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"x.divida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"x.subDivida")));
        }
        return filtro.toString();
    }

    @Generated
    public ArrecadacaoPorTipoFiltroDTO() {
    }

    @Generated
    public LocalDate getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    @Generated
    public ArrecadacaoPorTipo getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public void setDataMovimentacao(LocalDate dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Generated
    public void setTipo(ArrecadacaoPorTipo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoPorTipoFiltroDTO)) {
            return false;
        }
        ArrecadacaoPorTipoFiltroDTO other = (ArrecadacaoPorTipoFiltroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$contaBancaria = this.getContaBancaria();
        Long other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !((Object)this$contaBancaria).equals(other$contaBancaria)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataMovimentacao = this.getDataMovimentacao();
        LocalDate other$dataMovimentacao = other.getDataMovimentacao();
        if (this$dataMovimentacao == null ? other$dataMovimentacao != null : !((Object)this$dataMovimentacao).equals(other$dataMovimentacao)) {
            return false;
        }
        ArrecadacaoPorTipo this$tipo = this.getTipo();
        ArrecadacaoPorTipo other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        return !(this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoPorTipoFiltroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : ((Object)$contaBancaria).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        LocalDate $dataMovimentacao = this.getDataMovimentacao();
        result = result * 59 + ($dataMovimentacao == null ? 43 : ((Object)$dataMovimentacao).hashCode());
        ArrecadacaoPorTipo $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrecadacaoPorTipoFiltroDTO(dataMovimentacao=" + this.getDataMovimentacao() + ", tipo=" + this.getTipo() + ", contaBancaria=" + this.getContaBancaria() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ")";
    }
}

