/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmentoDemolicao;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBIMOBILIARIOSEGMENTO")
@Audited
public class CadastroImobiliarioSegmento
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOSEGMENTO_ID")
    private Long id;
    @NotNull
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @DynamicValidation(label="Tipo de Segmento")
    @Column(name="tiposegmento")
    @DiffRevisionIgnore
    private Long idTipoSegmento;
    @ManyToOne
    @JoinColumn(name="TIPOSEGMENTO", referencedColumnName="TIPOSEGMENTO", updatable=false, insertable=false)
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Tipo de Segmento")
    @DiffRevisionIgnoreProperties(value={"utilizacao", "classificacaoEdificacao", "classificacaoUso"})
    private TipoSegmento tipoSegmento;
    @Min(value=0L)
    @Column(scale=15, precision=4)
    private @Min(value=0L) BigDecimal areaConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @ManyToOne
    @JoinColumn(name="idsituacaosegmento", referencedColumnName="idsituacaosegmento")
    @DiffRevisionIgnoreProperties(value={"lancaImposto", "situacaoRegular", "permiteDemolicao", "desativada"})
    @Caption(value="Situa\u00e7\u00e3o")
    private SituacaoSegmentoImob situacaoSegmento;
    @Caption(value="\u00c1rea Coberta")
    private BigDecimal areaCoberta = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Descoberta")
    private BigDecimal areaDescoberta = BigDecimal.ZERO;
    @EloSequence(sequenceName="S05IDSEGMENTOIMOBILIARIO")
    @DiffRevisionIgnore
    private Long idSegmentoImobiliario;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="segmento")
    @Caption(value="Boletim Segmento")
    private final List<RespostaSegmento> respostasSegmento = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBIMOBILIARIOSEGMENTO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Segmento Demoli\u00e7\u00e3o")
    @DiffRevisionIgnore
    private final List<CadastroImobiliarioSegmentoDemolicao> cadastroImobiliarioSegmentoDml = new ArrayList();
    @NotNull
    @NotAudited
    private TipoCadastro tipoCadastro;
    @NotNull
    @NotAudited
    private Long cadastroGeral;

    public boolean isNew() {
        return this.id == null || this.getSequencia() == null;
    }

    public void merge(CadastroImobiliarioSegmento segmento) {
        this.idTipoSegmento = segmento.getIdTipoSegmento();
        this.tipoSegmento = segmento.getTipoSegmento();
        this.areaConstruida = segmento.getAreaConstruida();
        this.situacaoSegmento = segmento.getSituacaoSegmento();
        this.mergeRespostasSegmento(segmento.getRespostasSegmento());
    }

    public void mergeRespostasSegmento(List<RespostaSegmento> respostas) {
        List merged = ListUtils.merge((List)this.getRespostasSegmento(), respostas, Resposta::getId, RespostaSegmento::merge);
        this.getRespostasSegmento().clear();
        this.getRespostasSegmento().addAll(merged);
    }

    public CadastroImobiliarioSegmento copy() {
        CadastroImobiliarioSegmento segmento = new CadastroImobiliarioSegmento();
        BeanUtils.copyProperties((Object)this, (Object)segmento, (String[])new String[]{"id", "cadastroGeral", "respostasSegmento", "cadastroImobiliarioSegmentoDml"});
        this.respostasSegmento.stream().map(RespostaSegmento::copy).forEach(arg_0 -> segmento.addRespostaSegmento(arg_0));
        return segmento;
    }

    private void addRespostaSegmento(RespostaSegmento respostaSegmento) {
        respostaSegmento.setSegmento(this);
        this.respostasSegmento.add(respostaSegmento);
    }

    @JsonIgnore
    public Boolean lancaImposto() {
        return Optional.ofNullable(this.getSituacaoSegmento()).map(SituacaoSegmentoImob::getLancaImposto).orElse(Boolean.FALSE);
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioSegmento(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioSegmento)) {
            return false;
        }
        CadastroImobiliarioSegmento other = (CadastroImobiliarioSegmento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioSegmento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroImobiliarioSegmento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getIdTipoSegmento() {
        return this.idTipoSegmento;
    }

    @Generated
    public TipoSegmento getTipoSegmento() {
        return this.tipoSegmento;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public SituacaoSegmentoImob getSituacaoSegmento() {
        return this.situacaoSegmento;
    }

    @Generated
    public BigDecimal getAreaCoberta() {
        return this.areaCoberta;
    }

    @Generated
    public BigDecimal getAreaDescoberta() {
        return this.areaDescoberta;
    }

    @Generated
    public Long getIdSegmentoImobiliario() {
        return this.idSegmentoImobiliario;
    }

    @Generated
    public List<RespostaSegmento> getRespostasSegmento() {
        return this.respostasSegmento;
    }

    @Generated
    public List<CadastroImobiliarioSegmentoDemolicao> getCadastroImobiliarioSegmentoDml() {
        return this.cadastroImobiliarioSegmentoDml;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setIdTipoSegmento(Long idTipoSegmento) {
        this.idTipoSegmento = idTipoSegmento;
    }

    @Generated
    public void setTipoSegmento(TipoSegmento tipoSegmento) {
        this.tipoSegmento = tipoSegmento;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setSituacaoSegmento(SituacaoSegmentoImob situacaoSegmento) {
        this.situacaoSegmento = situacaoSegmento;
    }

    @Generated
    public void setAreaCoberta(BigDecimal areaCoberta) {
        this.areaCoberta = areaCoberta;
    }

    @Generated
    public void setAreaDescoberta(BigDecimal areaDescoberta) {
        this.areaDescoberta = areaDescoberta;
    }

    @Generated
    public void setIdSegmentoImobiliario(Long idSegmentoImobiliario) {
        this.idSegmentoImobiliario = idSegmentoImobiliario;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }
}

