/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.contencioso;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.PareceristaDTO;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="TRIBPARECERISTA")
public class Parecerista
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idParecerista")
    @EloSequence(applyOnMerge=true, sequenceName="S05IDPARECERISTA")
    private Long id;
    @ManyToOne
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    @NotNull
    private Pessoa pessoa;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;

    public static Parecerista of(PareceristaDTO pareceristaDTO) {
        Parecerista parecerista = new Parecerista();
        parecerista.setId(pareceristaDTO.getId());
        parecerista.setPessoa(pareceristaDTO.getPessoa());
        parecerista.setAtivo(pareceristaDTO.getAtivo());
        return parecerista;
    }

    @Generated
    public Parecerista() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public String toString() {
        return "Parecerista(id=" + this.getId() + ", pessoa=" + this.getPessoa() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parecerista)) {
            return false;
        }
        Parecerista other = (Parecerista)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Parecerista;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

