/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributoId;
import br.com.elotech.tributos.domain.DividaGrupoVencimento;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="TRIBGUIARECOLHIMENTO")
public class Divida
implements EloEntity<Long>,
Serializable {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    @Id
    @EloSequence(sequenceName="S_TRIBGUIARECOLHIMENTO_ID")
    @Column(name="idkey")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @Column(name="guiarecolhimento")
    private Long divida;
    @Column(length=100)
    private String descricao;
    @Column(length=20)
    private String apelido;
    @Column(name="tipoguiarecolhimento")
    private TipoDivida tipoDivida;
    private TipoCadastro tipoCadastro;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="fundamentolegal", referencedColumnName="idato"))})
    private Ato fundamentoLegal;
    @Column(name="constituinopagamento")
    private Boolean constituiNoPagamento;
    @ManyToOne
    @JoinColumn(name="tipodocumento")
    private DocumentoTipo tipoDocumento;
    @Column(name="alteramodelobloqueto")
    private Boolean alteraModeloBloqueto;
    @ManyToOne
    @JoinColumn(name="paramreparcelamento")
    private ParamParcelamento paramReparcelamento;
    @ManyToOne
    @JoinColumn(name="formacorrecao")
    private FormaCorrecao formaCorrecao;
    @Column(name="valorminimoparcela")
    private BigDecimal valorMinimoParcela;
    @Column(name="valortotaldebito")
    private BigDecimal valorTotalDebito;
    @Column(name="cdaindividual")
    private Boolean cdaIndividual;
    @Column(name="numerominimoparcela")
    private Long numeroMinimoParcela;
    @Column(name="emitebloqueto")
    private Boolean emiteBloqueto;
    @Column(name="supersimples")
    private Boolean superSimples = Boolean.FALSE;
    @Column(name="emitebloquetoweb")
    private Boolean emiteBloquetoWeb;
    @Column(name="correcaovencimentobloqueto")
    private Boolean correcaoVencimentoBloqueto;
    @Column(name="guiaalvaraonline")
    private Boolean guiaAlvaraOnline;
    @Column(name="permitelancarvalorzero")
    private Boolean permiteLancarValorZero;
    @Column(name="fixardatacorrecaocalculoanual")
    private Boolean fixaDataCorrecaoCalculoAnual;
    private Boolean inativa;
    @Column(length=1000)
    private String observacao;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelBloquetoCarne", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relbloquetocarne", referencedColumnName="relatorio"))})
    private Relatorio relBoletoCarne;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tiporelbloquetocarneanual", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relbloquetocarneanual", referencedColumnName="relatorio"))})
    private Relatorio relBoletoCarneAnual;
    @Column(name="guiatributaria")
    private Boolean guiaTributaria;
    @Column(name="verificaformapagtodiferenciada")
    private Boolean verificaFormaPagamentoDiferenciada;
    @Column(name="imprimeobservacao")
    private Boolean imprimeObservacao;
    @Column(name="debitoautomatico")
    private Boolean debitoAutomatico;
    @OneToMany(mappedBy="divida", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"divida"}, allowSetters=true)
    private List<DividaTributo> tributos = new ArrayList();
    @OneToMany(mappedBy="divida", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="formaPagamento.id")
    @JsonIgnoreProperties(value={"divida"})
    private List<DividaFormaPagamento> formasPagamento = new ArrayList();
    @OneToMany(mappedBy="divida", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id.exercicio, id.grupoVencimento")
    @JsonIgnoreProperties(value={"divida"})
    private List<DividaGrupoVencimento> gruposVencimento = new ArrayList();

    public Long getNumeroMinimoParcela() {
        if (Objects.isNull(this.numeroMinimoParcela)) {
            return 0L;
        }
        return this.numeroMinimoParcela;
    }

    public BigDecimal getValorMinimoDebito() {
        if (Objects.isNull(this.valorTotalDebito)) {
            return BigDecimal.ZERO;
        }
        return this.valorTotalDebito;
    }

    public BigDecimal getValorMinimoParcela() {
        if (Objects.isNull(this.valorMinimoParcela)) {
            return BigDecimal.ZERO;
        }
        return this.valorMinimoParcela;
    }

    public DividaFormaPagamento getDividaFormaPagamentoByFormaPagamentoId(Long id) {
        return this.formasPagamento.stream().filter(formaPagamento -> formaPagamento.getFormaPagamento().getId().equals(id)).findFirst().orElse(null);
    }

    public void setRelationsKeys() {
        if (Objects.nonNull(this.tributos)) {
            this.tributos.forEach(dividaTributo -> {
                if (Objects.isNull(dividaTributo.getId())) {
                    dividaTributo.setId(DividaTributoPK.builder().entidade(this.entidade).exercicio(this.exercicio).divida(this.divida).tributo(dividaTributo.getTributo().getTributo()).build());
                }
                dividaTributo.setDivida(this);
                dividaTributo.setDividaTributoEspelhoId();
            });
        }
        if (Objects.nonNull(this.formasPagamento)) {
            this.formasPagamento.forEach(dividaFormaPagamento -> {
                dividaFormaPagamento.setEntidade(this.entidade);
                dividaFormaPagamento.setExercicio(this.exercicio);
                dividaFormaPagamento.setGuiaRecolhimento(this.divida);
                dividaFormaPagamento.setDivida(this);
                dividaFormaPagamento.setRelationsKeys();
            });
        }
    }

    public void setFormaPagamentoId() {
        this.formasPagamento.forEach(formaPagamento -> formaPagamento.setDivida(this));
    }

    public Boolean isConstituido() {
        if (Objects.isNull(this.constituiNoPagamento)) {
            return Boolean.TRUE;
        }
        return this.constituiNoPagamento == false;
    }

    public Boolean hasTributo(String tributo) {
        return this.tributos.stream().anyMatch(tributoEntity -> tributo.equals(tributoEntity.getId().getTributo()));
    }

    @JsonIgnore
    public List<DividaFormaPagamentoTributo> adicionaDividaFormaPagamentoTributoByDividaTributo() {
        ArrayList<DividaFormaPagamentoTributo> tributosInseridos = new ArrayList<DividaFormaPagamentoTributo>();
        if (Objects.nonNull(this.getTributos()) && !this.getTributos().isEmpty() && Objects.nonNull(this.getFormasPagamento()) && !this.getFormasPagamento().isEmpty()) {
            this.getTributos().forEach(tributo -> this.getFormasPagamento().forEach(formaPagamento -> {
                if (!formaPagamento.existeTributoDividaFormaPagamentoTributo(tributo.getTributo().getTributo()).booleanValue()) {
                    this.adicionarDividaFormaPagamentoTributo(tributosInseridos, formaPagamento, tributo);
                }
            }));
        }
        return tributosInseridos;
    }

    private void adicionarDividaFormaPagamentoTributo(List<DividaFormaPagamentoTributo> dividasFormaPagamentoTributo, DividaFormaPagamento formaPagamento, DividaTributo dividaTributo) {
        DividaFormaPagamentoTributo dividaFormaPagamentoTributo = new DividaFormaPagamentoTributo();
        dividaFormaPagamentoTributo.setTributo(dividaTributo.getTributo());
        dividaFormaPagamentoTributo.setId(DividaFormaPagamentoTributoId.of((DividaFormaPagamento)formaPagamento, (String)dividaTributo.getTributo().getTributo()));
        dividasFormaPagamentoTributo.add(dividaFormaPagamentoTributo);
    }

    @JsonIgnore
    public List<DividaFormaPagamentoTributo> getAllDividaFormaPagamentoTributoRemovido() {
        ArrayList<DividaFormaPagamentoTributo> tributosRemovidos = new ArrayList<DividaFormaPagamentoTributo>();
        this.getFormasPagamento().forEach(dividaFormaPagamento -> dividaFormaPagamento.getFormasPagamentoTributo().forEach(dividaFormaPagamentoTributo -> {
            if (!dividaFormaPagamento.existeDividaFormaPagamentoTributoDividaTributo(dividaFormaPagamentoTributo).booleanValue()) {
                tributosRemovidos.add((DividaFormaPagamentoTributo)dividaFormaPagamentoTributo);
            }
        }));
        return tributosRemovidos;
    }

    @JsonIgnore
    public List<DividaFormaPagamentoTributo> getAllDividaFormaPagamentoTributo(List<DividaFormaPagamentoTributo> removidos) {
        List<DividaFormaPagamentoTributo> dividaTributos = this.getFormasPagamento().stream().map(DividaFormaPagamento::getFormasPagamentoTributo).flatMap(Collection::stream).collect(Collectors.toList());
        if (Objects.nonNull(removidos) && !removidos.isEmpty()) {
            return dividaTributos.stream().filter(dividaTributo -> removidos.stream().noneMatch(removido -> removido.getTributo().equals((Object)dividaTributo.getTributo()))).collect(Collectors.toList());
        }
        return dividaTributos;
    }

    @JsonIgnore
    public void clearDividaFormaPagamentoTributos() {
        this.getFormasPagamento().stream().forEach(formaPagamento -> formaPagamento.getFormasPagamentoTributo().clear());
    }

    @Generated
    public Divida() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getApelido() {
        return this.apelido;
    }

    @Generated
    public TipoDivida getTipoDivida() {
        return this.tipoDivida;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Ato getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    @Generated
    public Boolean getConstituiNoPagamento() {
        return this.constituiNoPagamento;
    }

    @Generated
    public DocumentoTipo getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Boolean getAlteraModeloBloqueto() {
        return this.alteraModeloBloqueto;
    }

    @Generated
    public ParamParcelamento getParamReparcelamento() {
        return this.paramReparcelamento;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public BigDecimal getValorTotalDebito() {
        return this.valorTotalDebito;
    }

    @Generated
    public Boolean getCdaIndividual() {
        return this.cdaIndividual;
    }

    @Generated
    public Boolean getEmiteBloqueto() {
        return this.emiteBloqueto;
    }

    @Generated
    public Boolean getSuperSimples() {
        return this.superSimples;
    }

    @Generated
    public Boolean getEmiteBloquetoWeb() {
        return this.emiteBloquetoWeb;
    }

    @Generated
    public Boolean getCorrecaoVencimentoBloqueto() {
        return this.correcaoVencimentoBloqueto;
    }

    @Generated
    public Boolean getGuiaAlvaraOnline() {
        return this.guiaAlvaraOnline;
    }

    @Generated
    public Boolean getPermiteLancarValorZero() {
        return this.permiteLancarValorZero;
    }

    @Generated
    public Boolean getFixaDataCorrecaoCalculoAnual() {
        return this.fixaDataCorrecaoCalculoAnual;
    }

    @Generated
    public Boolean getInativa() {
        return this.inativa;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Relatorio getRelBoletoCarne() {
        return this.relBoletoCarne;
    }

    @Generated
    public Relatorio getRelBoletoCarneAnual() {
        return this.relBoletoCarneAnual;
    }

    @Generated
    public Boolean getGuiaTributaria() {
        return this.guiaTributaria;
    }

    @Generated
    public Boolean getVerificaFormaPagamentoDiferenciada() {
        return this.verificaFormaPagamentoDiferenciada;
    }

    @Generated
    public Boolean getImprimeObservacao() {
        return this.imprimeObservacao;
    }

    @Generated
    public Boolean getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    @Generated
    public List<DividaTributo> getTributos() {
        return this.tributos;
    }

    @Generated
    public List<DividaFormaPagamento> getFormasPagamento() {
        return this.formasPagamento;
    }

    @Generated
    public List<DividaGrupoVencimento> getGruposVencimento() {
        return this.gruposVencimento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    @Generated
    public void setTipoDivida(TipoDivida tipoDivida) {
        this.tipoDivida = tipoDivida;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setFundamentoLegal(Ato fundamentoLegal) {
        this.fundamentoLegal = fundamentoLegal;
    }

    @Generated
    public void setConstituiNoPagamento(Boolean constituiNoPagamento) {
        this.constituiNoPagamento = constituiNoPagamento;
    }

    @Generated
    public void setTipoDocumento(DocumentoTipo tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setAlteraModeloBloqueto(Boolean alteraModeloBloqueto) {
        this.alteraModeloBloqueto = alteraModeloBloqueto;
    }

    @Generated
    public void setParamReparcelamento(ParamParcelamento paramReparcelamento) {
        this.paramReparcelamento = paramReparcelamento;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setValorMinimoParcela(BigDecimal valorMinimoParcela) {
        this.valorMinimoParcela = valorMinimoParcela;
    }

    @Generated
    public void setValorTotalDebito(BigDecimal valorTotalDebito) {
        this.valorTotalDebito = valorTotalDebito;
    }

    @Generated
    public void setCdaIndividual(Boolean cdaIndividual) {
        this.cdaIndividual = cdaIndividual;
    }

    @Generated
    public void setNumeroMinimoParcela(Long numeroMinimoParcela) {
        this.numeroMinimoParcela = numeroMinimoParcela;
    }

    @Generated
    public void setEmiteBloqueto(Boolean emiteBloqueto) {
        this.emiteBloqueto = emiteBloqueto;
    }

    @Generated
    public void setSuperSimples(Boolean superSimples) {
        this.superSimples = superSimples;
    }

    @Generated
    public void setEmiteBloquetoWeb(Boolean emiteBloquetoWeb) {
        this.emiteBloquetoWeb = emiteBloquetoWeb;
    }

    @Generated
    public void setCorrecaoVencimentoBloqueto(Boolean correcaoVencimentoBloqueto) {
        this.correcaoVencimentoBloqueto = correcaoVencimentoBloqueto;
    }

    @Generated
    public void setGuiaAlvaraOnline(Boolean guiaAlvaraOnline) {
        this.guiaAlvaraOnline = guiaAlvaraOnline;
    }

    @Generated
    public void setPermiteLancarValorZero(Boolean permiteLancarValorZero) {
        this.permiteLancarValorZero = permiteLancarValorZero;
    }

    @Generated
    public void setFixaDataCorrecaoCalculoAnual(Boolean fixaDataCorrecaoCalculoAnual) {
        this.fixaDataCorrecaoCalculoAnual = fixaDataCorrecaoCalculoAnual;
    }

    @Generated
    public void setInativa(Boolean inativa) {
        this.inativa = inativa;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setRelBoletoCarne(Relatorio relBoletoCarne) {
        this.relBoletoCarne = relBoletoCarne;
    }

    @Generated
    public void setRelBoletoCarneAnual(Relatorio relBoletoCarneAnual) {
        this.relBoletoCarneAnual = relBoletoCarneAnual;
    }

    @Generated
    public void setGuiaTributaria(Boolean guiaTributaria) {
        this.guiaTributaria = guiaTributaria;
    }

    @Generated
    public void setVerificaFormaPagamentoDiferenciada(Boolean verificaFormaPagamentoDiferenciada) {
        this.verificaFormaPagamentoDiferenciada = verificaFormaPagamentoDiferenciada;
    }

    @Generated
    public void setImprimeObservacao(Boolean imprimeObservacao) {
        this.imprimeObservacao = imprimeObservacao;
    }

    @Generated
    public void setDebitoAutomatico(Boolean debitoAutomatico) {
        this.debitoAutomatico = debitoAutomatico;
    }

    @JsonIgnoreProperties(value={"divida"}, allowSetters=true)
    @Generated
    public void setTributos(List<DividaTributo> tributos) {
        this.tributos = tributos;
    }

    @JsonIgnoreProperties(value={"divida"})
    @Generated
    public void setFormasPagamento(List<DividaFormaPagamento> formasPagamento) {
        this.formasPagamento = formasPagamento;
    }

    @JsonIgnoreProperties(value={"divida"})
    @Generated
    public void setGruposVencimento(List<DividaGrupoVencimento> gruposVencimento) {
        this.gruposVencimento = gruposVencimento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Divida)) {
            return false;
        }
        Divida other = (Divida)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Divida;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Divida(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ")";
    }
}

