/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.CadastroGeralObservacao;
import br.com.elotech.tributos.domain.CadastroGeralObservacaoId;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.MotivoExclusaoLogica;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.domain.TipoLogradouro;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaAvulso;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscalPeriodo;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCADASTROGERAL")
@Indexed
@Inheritance(strategy=InheritanceType.JOINED)
@DynamicInsert
@DynamicUpdate
@Audited
public class CadastroGeral
implements EloEntity<Long>,
Serializable {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroGeral")
    @Caption(value="Isen\u00e7\u00f5es")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroGeralIsencao> cadastroGeralIsencoes = new ArrayList();
    @IndexedEmbedded
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @AuditJoinTable(name="TRIBPROPRIETARIO_CAD_AUD")
    @Caption(value="Propriet\u00e1rios")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<Proprietario> proprietarios = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroGeral")
    @Caption(value="Campos Din\u00e2micos Avulso")
    private final List<RespostaAvulso> respostasAvulso = new ArrayList();
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBCADASTROGERAL_ID")
    @DiffRevisionIgnore
    private Long id;
    @NotNull
    @Caption(value="Tipo de Cadastro")
    @Field(name="tipoCadastro_sort", analyze=Analyze.NO, store=Store.NO, index=Index.NO)
    @SortableField(forField="tipoCadastro_sort")
    private TipoCadastro tipoCadastro;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Motivo Exclusao Logica")
    private MotivoExclusaoLogica motivoExclusaoLogica;
    @Caption(value="Data Restauracao Logica")
    private LocalDate dataRestauracaoLogica;
    @Caption(value="Data Exclusao Logica")
    private LocalDate dataExclusaoLogica;
    @Fields(value={@Field(analyze=Analyze.NO, bridge=@FieldBridge(impl=LongBridge.class)), @Field(name="cadastroGeral_sort", analyze=Analyze.NO, store=Store.NO, index=Index.NO)})
    @SortableField(forField="cadastroGeral_sort")
    @EloSequence(sequenceNameFactory="#{sequenceCadastroGeralService.getExpression(#entity)}")
    @Min(value=1L)
    @Caption(value="C\u00f3digo do Cadastro")
    private @Min(value=1L) Long cadastroGeral;
    @Field(analyze=Analyze.NO, bridge=@FieldBridge(impl=LongBridge.class))
    private Long cadastroGeralAnterior;
    @IndexedEmbedded
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @ManyToOne
    @Caption(value="Pessoa")
    @DiffRevisionIgnoreProperties(value={"id", "enderecos", "bancos", "contatos", "rg", "orgaoEmissor", "dataEmissao", "inscricaoEstadual", "sequenciaEndereco", "sequenciaContato", "sequenciaBanco", "contribuinte", "fornecedor", "pessoal", "dataInclusao", "observacao", "usuarioInclusao", "estadoEmissor", "microEmpresa", "dataAlteracao", "estrangeiro", "autonomo", "atividadePrincipal", "inscricaoMunicipal", "dataIssqn", "fornecedorSiscop", "codigoSistemaAnterior", "inativo", "sequenciaImagem", "activeFormOrigem", "dataNascimento", "nit", "nire", "pis", "dataAberturaCnpj", "idTcePR", "idUnico", "enderecoPrincipal", "contatoPrincipal", "contaBancariaPrincipal"})
    private Pessoa pessoa;
    @Field(analyze=Analyze.NO)
    @Length(max=10)
    @Caption(value="N\u00famero")
    private @Length(max=10) String numero;
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @Length(max=100)
    @Caption(value="Complemento")
    @SortableField(forField="complemento")
    private @Length(max=100) String complemento;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn
    @Caption(value="Cidade")
    @DiffRevisionIgnoreProperties(value={"id", "pais", "descricaoAbreviada", "codigoNacional", "ativa", "dataCriacao", "programa", "usuario", "idUnico"})
    private Cidade cidade;
    @IndexedEmbedded
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn(name="LOGRADOURO_IDKEY")
    @Caption(value="Logradouro")
    @DiffRevisionIgnoreProperties(value={"id", "descLogradouroInicio", "inativo", "descricaoAnterior", "logradouroInicio", "dataCriacao", "programa", "usuario", "idunico"})
    private Logradouro logradouro;
    @IndexedEmbedded
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @ManyToOne
    @JoinColumn(name="BAIRRO_IDKEY")
    @Caption(value="Bairro")
    @DiffRevisionIgnoreProperties(value={"id", "inativo", "exclusaoLogica", "idunico"})
    private Bairro bairro;
    @Field(analyzer=@Analyzer(definition="removeCaracteresEspeciais"))
    @FieldBridge(impl=LongBridge.class)
    @Caption(value="CEP")
    private Long cep;
    @Column(name="IDCADASTROGERALISS")
    @EloSequence(sequenceName="s26tribcadastrogeral", applyOnMerge=true)
    @DiffRevisionIgnore
    private Long cadastroGeralISS;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exclus\u00e3o L\u00f3gica")
    private Boolean exclusaoLogica = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Englobado")
    private Boolean englobado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Suspenso Emiss\u00e3o")
    private Boolean suspensoEmissao = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Correspond\u00eancia Local")
    private Boolean correspondenciaLocal = Boolean.FALSE;
    @Caption(value="Data da Inclus\u00e3o")
    private LocalDate dataInclusao = LocalDate.now();
    @Caption(value="Data de Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao = LocalDate.now();
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="D\u00e9bito Autom\u00e1tico")
    private Boolean debitoAutomatico;
    @Length(max=25)
    @Caption(value="Identifica\u00e7\u00e3o")
    private @Length(max=25) String identificacao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Endere\u00e7o Entrega Carne Anual")
    private Boolean enderecoEntregaCarneAnual;
    @Length(max=100)
    @Caption(value="Endere\u00e7o Correspond\u00eancia")
    private @Length(max=100) String enderecoCorrespondencia;
    @Length(max=20)
    @Caption(value="N\u00famero Correspond\u00eancia")
    private @Length(max=20) String numeroCorrespondencia;
    @Length(max=100)
    @Caption(value="Complemento Correspond\u00eancia")
    private @Length(max=100) String complementoCorrespondencia;
    @Length(max=100)
    @Caption(value="Cidade/UF Correspond\u00eancia")
    private @Length(max=100) String cidadeUfCorrespondencia;
    @Length(max=20)
    @Caption(value="CEP Correspond\u00eancia")
    private @Length(max=20) String cepCorrespondencia;
    @Length(max=100)
    @Caption(value="Bairro Correspondencia")
    private @Length(max=100) String bairroCorrespondencia;
    @Length(max=2)
    @Caption(value="UF Correspond\u00eancia")
    private @Length(max=2) String ufCorrespondencia;
    @Length(max=250)
    @Caption(value="Usu\u00e1rio da \u00daltima altera\u00e7\u00e3o")
    private @Length(max=250) String usuario;
    @Caption(value="Vis\u00edvel NFSe")
    private Boolean visivelNfse = Boolean.FALSE;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroGeral")
    @AuditJoinTable(name="REGIMEFISCALPER_CADASTRO_AUD")
    @Caption(value="Regimes Fiscais por Per\u00edodo")
    @DiffRevisionIgnoreProperties(value={"id"})
    private List<RegimeFiscalPeriodo> regimeFiscalPeriodo = new ArrayList();
    @OneToMany(mappedBy="cadastroGeral", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Caption(value="Observa\u00e7\u00f5es")
    @OrderBy(value="data desc")
    private List<CadastroGeralObservacao> observacoes = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY, mappedBy="cadastroGeral")
    @Caption(value="Conv\u00eanio Sanepar")
    private final List<SaneparMatricula> saneparMatriculas = new ArrayList();
    @Enumerated(value=EnumType.STRING)
    private TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia;

    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao")), @Field(name="enderecoCompleto_sort", analyze=Analyze.NO)})
    @DiffRevisionIgnore
    @SortableField(forField="enderecoCompleto_sort")
    public String getEnderecoFormatado() {
        StringBuilder result = new StringBuilder();
        if (this.logradouro != null) {
            result.append(this.logradouro.getTipoLogradouroDescricao()).append(" ").append(this.logradouro.getDescricao()).append(", ").append(StringUtils.defaultString((String)this.numero));
        }
        if (this.bairro != null) {
            result.append(" - ").append(this.bairro.getDescricao());
        }
        if (this.complemento != null) {
            result.append(" - ").append(this.complemento);
        }
        return result.toString();
    }

    @DiffRevisionIgnore
    public String getCidadeFormatada() {
        StringBuilder result = new StringBuilder();
        if (this.cidade != null) {
            result.append(this.cidade.getDescricao()).append('/').append(this.cidade.getUnidadeFederacao());
        }
        return result.toString();
    }

    @DiffRevisionIgnore
    public Optional<Proprietario> getProprietarioPrincipal() {
        return this.proprietarios.stream().filter(Proprietario::getPrincipal).findFirst();
    }

    public Boolean possuiIsencaoCadastrada() {
        Long idIsencaoPadrao = 0L;
        return this.getCadastroGeralIsencoes().stream().anyMatch(isencao -> isencao.getIsencao().getId() > idIsencaoPadrao);
    }

    @Field(analyze=Analyze.NO)
    @Facet
    @DiffRevisionIgnore
    public String getTipoCadastroDescricao() {
        return this.getTipoCadastro().getDescricao();
    }

    @Field(analyze=Analyze.NO)
    @Facet
    @DiffRevisionIgnore
    public String getExclusaoLogicaDescricao() {
        return this.exclusaoLogica.toString();
    }

    @JsonIgnore
    @DiffRevisionIgnore
    public Pessoa getPessoaResponsavel() {
        if (TipoCadastro.IMOBILIARIO.equals((Object)this.getTipoCadastro())) {
            return this.getProprietarios().stream().filter(Proprietario::getCoResponsavelPrincipal).map(Proprietario::getPessoa).findAny().orElse(this.getPessoa());
        }
        return this.getPessoa();
    }

    public void addObservacoes(List<CadastroGeralObservacao> observacoes) {
        List<CadastroGeralObservacao> novasObservacoes = observacoes.stream().filter(novoRegistro -> !this.getObservacoes().contains(novoRegistro)).collect(Collectors.toList());
        List removerObservacoes = this.getObservacoes().stream().filter(registroDeletar -> !observacoes.contains(registroDeletar)).collect(Collectors.toList());
        novasObservacoes.forEach(observacao -> {
            observacao.getId().setCadastroGeral(this.getCadastroGeral());
            observacao.getId().setTipoCadastro(this.getTipoCadastro().getValue());
            observacao.setCadastroGeral(this);
        });
        this.observacoes.forEach(observacao -> observacoes.forEach(observacaoNova -> {
            if (observacao.getId().equals((Object)observacaoNova.getId()) && !observacao.getDescricao().equals(observacaoNova.getDescricao())) {
                observacao.setDescricao(observacaoNova.getDescricao());
            }
        }));
        this.getObservacoes().addAll(novasObservacoes);
        this.getObservacoes().removeAll(removerObservacoes);
    }

    public void mergeProprietarios(List<Proprietario> novosProprietarios) {
        List merged = ListUtils.merge((List)this.getProprietarios(), novosProprietarios, Proprietario::getIdPessoa, Proprietario::merge);
        this.getProprietarios().clear();
        this.getProprietarios().addAll(merged);
    }

    public void mergeRespostaAvulso(List<RespostaAvulso> respostas) {
        List merged = ListUtils.merge((List)this.getRespostasAvulso(), respostas, Resposta::getId, RespostaAvulso::merge);
        this.getRespostasAvulso().clear();
        this.getRespostasAvulso().addAll(merged);
    }

    public void mergeRegimeFiscalPeriodo(List<RegimeFiscalPeriodo> regimes) {
        List merged = ListUtils.merge((List)this.getRegimeFiscalPeriodo(), regimes, regime -> regime.getRegimeFiscal().getId(), RegimeFiscalPeriodo::merge);
        merged.forEach(regime -> regime.setCadastroGeral(this));
        this.getRegimeFiscalPeriodo().clear();
        this.getRegimeFiscalPeriodo().addAll(merged);
    }

    public void mergeSaneparMatriculas(List<SaneparMatricula> saneparMatriculas) {
        List merged = ListUtils.merge((List)this.getSaneparMatriculas(), saneparMatriculas, SaneparMatricula::getId, SaneparMatricula::merge);
        this.getSaneparMatriculas().clear();
        this.getSaneparMatriculas().addAll(merged);
    }

    public void addRespostaAvulso(RespostaAvulso respostaAvulso) {
        this.getRespostasAvulso().add(respostaAvulso);
        respostaAvulso.setCadastroGeral(this);
    }

    protected void addProprietarios(Proprietario proprietario) {
        proprietario.setCadastroGeral(this);
        this.proprietarios.add(proprietario);
    }

    protected void addObservacoes(CadastroGeralObservacao observacao) {
        observacao.setId(CadastroGeralObservacaoId.builder().cadastroGeral(this.getCadastroGeral()).tipoCadastro(this.getTipoCadastro().getValue()).sequencia(observacao.getId().getSequencia()).build());
        observacao.setCadastroGeral(this);
        this.observacoes.add(observacao);
    }

    public void atualizaReferenciaObservacoes() {
        this.getObservacoes().stream().map(CadastroGeralObservacao::getId).forEach(cadastroGeralObservacaoId -> {
            cadastroGeralObservacaoId.setTipoCadastro(this.getTipoCadastro().getValue());
            cadastroGeralObservacaoId.setCadastroGeral(this.getCadastroGeral());
        });
    }

    public EnderecoCadastroGeralDTO toEnderecoCadastroGeralDTO() {
        EnderecoCadastroGeralDTO dto = new EnderecoCadastroGeralDTO();
        Optional.ofNullable(this.getId()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setIdCadastro(arg_0));
        Optional.ofNullable(this.getTipoCadastro()).map(TipoCadastro::getValue).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoCadastro(arg_0));
        Optional.ofNullable(this.getCadastroGeral()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCadastroGeral(arg_0));
        Optional.ofNullable(this.getCep()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCep(arg_0));
        Optional.ofNullable(this.getNumero()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setNumero(arg_0));
        Optional.ofNullable(this.getCidade()).map(Cidade::getDescricao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCidade(arg_0));
        Optional.ofNullable(this.getCidade()).map(Cidade::getUnidadeFederacao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setUnidadeFederacao(arg_0));
        Optional.ofNullable(this.getBairro()).map(Bairro::getDescricao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setBairro(arg_0));
        Optional.ofNullable(this.getEnderecoFormatado()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setEnderecoCompleto(arg_0));
        Optional.ofNullable(this.getLogradouro()).map(Logradouro::getTipoLogradouro).map(TipoLogradouro::getDescricao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoLogradouro(arg_0));
        Optional.ofNullable(this.getLogradouro()).map(Logradouro::getDescricao).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setLogradouro(arg_0));
        Optional.ofNullable(this.getPessoa()).map(Pessoa::getNome).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setPessoaNome(arg_0));
        Optional.ofNullable(this.getPessoa()).map(Pessoa::getCnpjCpf).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCnpjCpf(arg_0));
        Optional.ofNullable(this.getPessoa()).map(Pessoa::getId).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCodigoPessoa(arg_0));
        Optional.ofNullable(this.getPessoa()).map(Pessoa::getTipoPessoa).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoPessoa(arg_0));
        Optional.ofNullable(this.getPessoa()).map(Pessoa::getRg).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setRg(arg_0));
        Optional.ofNullable(this.getComplemento()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setComplemento(arg_0));
        Optional<Pessoa> responsavel = Optional.ofNullable(this.getPessoaResponsavel());
        if (responsavel.isPresent()) {
            responsavel.map(Pessoa::getNome).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setPessoaNomeResponsavel(arg_0));
            responsavel.map(Pessoa::getCnpjCpf).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCnpjCpfResponsavel(arg_0));
            responsavel.map(Pessoa::getId).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setCodigoPessoaResponsavel(arg_0));
            responsavel.map(Pessoa::getTipoPessoa).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoPessoaResponsavel(arg_0));
        }
        return dto;
    }

    @JsonIgnore
    public CadastroGeralDTO toCadastroGeralDTO() {
        CadastroGeralDTO dto = new CadastroGeralDTO();
        Optional.ofNullable(this.getTipoCadastro()).map(TipoCadastro::getValue).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setTipoCadastro(arg_0));
        Optional.ofNullable(this.getCadastroGeral()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setCadastroGeral(arg_0));
        Optional.ofNullable(this.getCidade()).ifPresent(cidade -> dto.setCidadeCadastro(cidade.getDescricao()));
        Optional.ofNullable(this.getCidade()).ifPresent(cidade -> dto.setUfCadastro(cidade.getUnidadeFederacao()));
        Optional.ofNullable(this.getBairro()).ifPresent(bairro -> dto.setBairroCadastro(bairro.getDescricao()));
        Optional.ofNullable(this.getLogradouro()).map(Logradouro::getTipoLogradouro).ifPresentOrElse(tipoLogradouro -> {
            dto.setTipoLogradouroCadastro(tipoLogradouro.getSigla());
            dto.setTipoLogradouroDescricaoCadastro(tipoLogradouro.getDescricao());
        }, () -> {
            dto.setTipoLogradouroCadastro("");
            dto.setTipoLogradouroDescricaoCadastro("");
        });
        Optional.ofNullable(this.getLogradouro()).ifPresent(logradouro -> dto.setLogradouroCadastro(logradouro.getDescricao()));
        Optional.ofNullable(this.getNumero()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setNumeroCadastro(arg_0));
        Optional.ofNullable(this.getCep()).ifPresent(cep -> dto.setCepCadastro(cep.toString()));
        dto.setComplementoCadastro((String)ObjectUtils.firstNonNull((Object[])new String[]{this.getComplemento(), ""}));
        Optional.ofNullable(this.getDataInclusao()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setDataInclusao(arg_0));
        Optional.ofNullable(this.getDataAlteracao()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setDataAlteracao(arg_0));
        return dto;
    }

    @JsonIgnore
    public CadastroGeralDTO toCadastroGeralDTOWithPessoa() {
        CadastroGeralDTO dto = this.toCadastroGeralDTO();
        if (Objects.nonNull(this.getPessoa())) {
            PessoaDTO pessoaDTO = new PessoaDTO();
            pessoaDTO.setPessoa(this.getPessoa().getId());
            Optional.ofNullable(this.getPessoa().getTipoPessoa()).map(TipoPessoa::getValue).ifPresent(arg_0 -> ((PessoaDTO)pessoaDTO).setTipoPessoa(arg_0));
            pessoaDTO.setCnpjCpf(this.getPessoa().getCnpjCpf());
            pessoaDTO.setNome(this.getPessoa().getNome());
            dto.setPessoaDTO(pessoaDTO);
            dto.setPessoa(this.getPessoa().getId());
            dto.setNome(this.getPessoa().getNome());
            dto.setNomeFantasia(this.getPessoa().getNomeFantasia());
            dto.setCnpjCpf(this.getPessoa().getCnpjCpf());
        }
        if (this instanceof CadastroImobiliario) {
            CadastroImobiliario imobiliario = (CadastroImobiliario)this;
            imobiliario.setEnderecoCadastroGeralDTO(dto);
        }
        return dto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeral)) {
            return false;
        }
        CadastroGeral other = (CadastroGeral)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeral(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ")";
    }

    @Generated
    public CadastroGeral() {
    }

    @Generated
    public List<CadastroGeralIsencao> getCadastroGeralIsencoes() {
        return this.cadastroGeralIsencoes;
    }

    @Generated
    public List<Proprietario> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public List<RespostaAvulso> getRespostasAvulso() {
        return this.respostasAvulso;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public MotivoExclusaoLogica getMotivoExclusaoLogica() {
        return this.motivoExclusaoLogica;
    }

    @Generated
    public LocalDate getDataRestauracaoLogica() {
        return this.dataRestauracaoLogica;
    }

    @Generated
    public LocalDate getDataExclusaoLogica() {
        return this.dataExclusaoLogica;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getCadastroGeralAnterior() {
        return this.cadastroGeralAnterior;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public Bairro getBairro() {
        return this.bairro;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public Long getCadastroGeralISS() {
        return this.cadastroGeralISS;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public Boolean getEnglobado() {
        return this.englobado;
    }

    @Generated
    public Boolean getSuspensoEmissao() {
        return this.suspensoEmissao;
    }

    @Generated
    public Boolean getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Boolean getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public Boolean getEnderecoEntregaCarneAnual() {
        return this.enderecoEntregaCarneAnual;
    }

    @Generated
    public String getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    @Generated
    public String getNumeroCorrespondencia() {
        return this.numeroCorrespondencia;
    }

    @Generated
    public String getComplementoCorrespondencia() {
        return this.complementoCorrespondencia;
    }

    @Generated
    public String getCidadeUfCorrespondencia() {
        return this.cidadeUfCorrespondencia;
    }

    @Generated
    public String getCepCorrespondencia() {
        return this.cepCorrespondencia;
    }

    @Generated
    public String getBairroCorrespondencia() {
        return this.bairroCorrespondencia;
    }

    @Generated
    public String getUfCorrespondencia() {
        return this.ufCorrespondencia;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getVisivelNfse() {
        return this.visivelNfse;
    }

    @Generated
    public List<RegimeFiscalPeriodo> getRegimeFiscalPeriodo() {
        return this.regimeFiscalPeriodo;
    }

    @Generated
    public List<CadastroGeralObservacao> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<SaneparMatricula> getSaneparMatriculas() {
        return this.saneparMatriculas;
    }

    @Generated
    public TipoEnderecoCorrespondencia getTipoEnderecoCorrespondencia() {
        return this.tipoEnderecoCorrespondencia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setMotivoExclusaoLogica(MotivoExclusaoLogica motivoExclusaoLogica) {
        this.motivoExclusaoLogica = motivoExclusaoLogica;
    }

    @Generated
    public void setDataRestauracaoLogica(LocalDate dataRestauracaoLogica) {
        this.dataRestauracaoLogica = dataRestauracaoLogica;
    }

    @Generated
    public void setDataExclusaoLogica(LocalDate dataExclusaoLogica) {
        this.dataExclusaoLogica = dataExclusaoLogica;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCadastroGeralAnterior(Long cadastroGeralAnterior) {
        this.cadastroGeralAnterior = cadastroGeralAnterior;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setCadastroGeralISS(Long cadastroGeralISS) {
        this.cadastroGeralISS = cadastroGeralISS;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setEnglobado(Boolean englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setSuspensoEmissao(Boolean suspensoEmissao) {
        this.suspensoEmissao = suspensoEmissao;
    }

    @Generated
    public void setCorrespondenciaLocal(Boolean correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setDebitoAutomatico(Boolean debitoAutomatico) {
        this.debitoAutomatico = debitoAutomatico;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setEnderecoEntregaCarneAnual(Boolean enderecoEntregaCarneAnual) {
        this.enderecoEntregaCarneAnual = enderecoEntregaCarneAnual;
    }

    @Generated
    public void setEnderecoCorrespondencia(String enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    @Generated
    public void setNumeroCorrespondencia(String numeroCorrespondencia) {
        this.numeroCorrespondencia = numeroCorrespondencia;
    }

    @Generated
    public void setComplementoCorrespondencia(String complementoCorrespondencia) {
        this.complementoCorrespondencia = complementoCorrespondencia;
    }

    @Generated
    public void setCidadeUfCorrespondencia(String cidadeUfCorrespondencia) {
        this.cidadeUfCorrespondencia = cidadeUfCorrespondencia;
    }

    @Generated
    public void setCepCorrespondencia(String cepCorrespondencia) {
        this.cepCorrespondencia = cepCorrespondencia;
    }

    @Generated
    public void setBairroCorrespondencia(String bairroCorrespondencia) {
        this.bairroCorrespondencia = bairroCorrespondencia;
    }

    @Generated
    public void setUfCorrespondencia(String ufCorrespondencia) {
        this.ufCorrespondencia = ufCorrespondencia;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setVisivelNfse(Boolean visivelNfse) {
        this.visivelNfse = visivelNfse;
    }

    @Generated
    public void setRegimeFiscalPeriodo(List<RegimeFiscalPeriodo> regimeFiscalPeriodo) {
        this.regimeFiscalPeriodo = regimeFiscalPeriodo;
    }

    @Generated
    public void setObservacoes(List<CadastroGeralObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setTipoEnderecoCorrespondencia(TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia) {
        this.tipoEnderecoCorrespondencia = tipoEnderecoCorrespondencia;
    }
}

