/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.request.ArquivoRemocaoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaBoletoDTO;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.repository.ArquivoGraficaRepository;
import br.com.elotech.tributos.calculo.repository.CalculoLoteImpressaoRepository;
import br.com.elotech.tributos.calculo.service.ArquivoGrafica;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AisePdfService;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CalculoLoteImpressaoService
extends ReadOnlyService<CalculoLoteImpressao, Long> {
    private final CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;
    private final CalculoLoteImpressaoRepository calculoLoteImpressaoRepository;
    private final ResolversHandler resolversHandler;
    private final EntidadeService entidadeService;
    private final ArquivoGraficaRepository arquivoGraficaRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final AisePdfService aisePdfService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoLoteImpressaoService.class);

    public Page<CalculoLoteImpressaoDTO> findbyCalculoId(Long idCalculo, String search, Pageable pageable) {
        String idClause = String.format("calculoGeracaoLote.calculo.id==%d", idCalculo);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, pageable).map(CalculoLoteImpressaoDTO::of);
    }

    public List<CalculoLoteImpressao> createLoteImpressao(CalculoGeracaoLote calculoGeracaoLote, Map<String, List<LoteItemDTO>> lotes) {
        ArrayList<CalculoLoteImpressao> loteImpressaoList = new ArrayList<CalculoLoteImpressao>();
        AtomicLong ordem = new AtomicLong();
        lotes.forEach((lote, loteItens) -> {
            int quantidadeMaximaPorLote = Objects.nonNull(calculoGeracaoLote.getQuantidadePorLote()) && calculoGeracaoLote.getQuantidadePorLote() > 0L ? calculoGeracaoLote.getQuantidadePorLote().intValue() : loteItens.size();
            List partitions = Lists.partition(loteItens.stream().filter(Objects::nonNull).collect(Collectors.toList()), (int)quantidadeMaximaPorLote);
            AtomicLong parte = new AtomicLong();
            partitions.forEach(lotesPartition -> {
                CalculoLoteImpressao loteImpressao = new CalculoLoteImpressao();
                ordem.incrementAndGet();
                loteImpressao.setCalculoGeracaoLote(calculoGeracaoLote);
                loteImpressao.setDescricao(lote);
                loteImpressao.setOrdem(Long.valueOf(ordem.get()));
                loteImpressao.setQuantidadeItens(Long.valueOf(lotesPartition.size()));
                if (partitions.size() > 1) {
                    loteImpressao.setDescricao(String.format("%s - Parte %d", loteImpressao.getDescricao(), parte.incrementAndGet()));
                }
                CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.save((Object)loteImpressao);
                loteImpressaoList.add(loteImpressao);
                this.calculoLoteImpressaoItemService.createLoteImpressaoItem(calculoLoteImpressao, lotesPartition);
            });
        });
        return loteImpressaoList;
    }

    public ArquivoGraficaDTO gerarArquivoGrafica(Long id) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado lote de impress\u00e3o com id %d.", id)));
        Calculo calculo = calculoLoteImpressao.getCalculoGeracaoLote().getCalculo();
        if (Arrays.asList(SituacaoCalculo.CARNE_GERADO, SituacaoCalculo.ARQUIVO_GERADO).contains(calculo.getSituacao())) {
            if (Objects.isNull(calculoLoteImpressao.getIdArquivoGrafica())) {
                Arquivo arquivo = this.uploadArquivoGrafica(calculoLoteImpressao);
                calculoLoteImpressao.setIdArquivoGrafica(arquivo.getId());
                calculoLoteImpressao.setDataGeracaoArquivo(arquivo.getDataCriacao().toLocalDate());
                if (this.calculoLoteImpressaoRepository.todosLotesDoCalculoPossuemArquivoGerado(calculo.getId())) {
                    calculo.setSituacao(SituacaoCalculo.ARQUIVO_GERADO);
                }
                this.calculoLoteImpressaoRepository.save((Object)calculoLoteImpressao);
            }
            return new ArquivoGraficaDTO(calculoLoteImpressao.getDataGeracaoArquivo(), this.getUrlArquivoGrafica(calculoLoteImpressao.getIdArquivoGrafica()), calculo.getSituacao());
        }
        throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar arquivo da gr\u00e1fica para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
    }

    @Async
    @Transactional
    public void createImpressaoCarneLotePdf(Long id, UserSecurityDTO userId) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado lote de impress\u00e3o com id %d.", id)));
        this.verifyIfExistsTarefa(calculoLoteImpressao);
        LOGGER.debug("Cria\u00e7\u00e3o da tarefa IMPRESSAO_CARNE_LOTE_PDF para o lote: {}, calculo gera\u00e7\u00e3o: {}, calculo: {}]", new Object[]{calculoLoteImpressao.getId(), calculoLoteImpressao.getCalculoGeracaoLote().getId(), calculoLoteImpressao.getCalculoGeracaoLote().getCalculo().getId()});
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoCarneLotePdf(String.format("%s/%s/%s", calculoLoteImpressao.getId(), calculoLoteImpressao.getCalculoGeracaoLote().getId(), calculoLoteImpressao.getCalculoGeracaoLote().getCalculo().getId()));
        Long tarefa = execucao.getTarefaAssincrona().getId();
        Optional notificacaoId = this.notificacaoService.send("Impress\u00e3o dos carn\u00eas a partir do lote em PDF", String.format("Iniciada a gera\u00e7\u00e3o do PDF dos carn\u00eas da tarefa %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userId, NotificationStatus.STARTED);
        this.generateCarneLotePdf(calculoLoteImpressao, userId, execucao, tarefa, notificacaoId);
    }

    public String printUrlCarnePdf(Long id) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado lote de impress\u00e3o com id %d.", id)));
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + calculoLoteImpressao.getIdCarnePdf()));
        return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    private Arquivo uploadArquivoGrafica(CalculoLoteImpressao calculoLoteImpressao) {
        String nomeArquivo = String.format("ElotechOxyArquivoGrafica%s", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        EntidadeInfo entidadePrincipal = this.entidadeService.findEntidadePrincipal();
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        List debitos = this.arquivoGraficaRepository.loadItens(calculoLoteImpressao);
        Map<Long, List<ArquivoGraficaBoletoDTO>> boletos = this.arquivoGraficaRepository.loadBoletos(calculoLoteImpressao.getId()).stream().collect(Collectors.groupingBy(ArquivoGraficaBoletoDTO::getIdItemLoteImpressao));
        ArquivoGrafica arquivoGrafica = new ArquivoGrafica(nomeArquivo);
        arquivoGrafica.gerarSegmentoA(calculoLoteImpressao, entidadePrincipal.getDescricao());
        debitos.forEach(item -> {
            arquivoGrafica.gerarSegmentoC(item, configuracao);
            arquivoGrafica.gerarSegmentoD(item);
            if (TipoCadastro.IMOBILIARIO.getValue().equals(item.getTipoCadastro())) {
                arquivoGrafica.gerarSegmentoE(item);
                arquivoGrafica.gerarSegmentoF(item);
                if (Objects.nonNull(item.getCodigoPessoaCompromissario())) {
                    arquivoGrafica.gerarSegmentoJ(item);
                }
            }
            arquivoGrafica.gerarSegmentoN(item);
            arquivoGrafica.gerarSegmentoO((List)boletos.get(item.getIdItemLoteImpressao()));
            if (!item.getCamposVariaveis().isEmpty()) {
                arquivoGrafica.gerarSegmentoQ(item.getCamposVariaveis());
            }
        });
        arquivoGrafica.gerarSegmentoZ(debitos.size());
        arquivoGrafica.finalizaGeracaoArquivo();
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content((InputStream)new ByteArrayInputStream(arquivoGrafica.getOutStream().toByteArray())).contentType(ContentType.APPLICATION_ZIP).build();
        return this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
    }

    private String getUrlArquivoGrafica(UUID idArquivo) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + idArquivo.toString()));
        return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public void deletarArquivoGrafica(Long id) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado lote de impress\u00e3o com id %d.", id)));
        Calculo calculo = calculoLoteImpressao.getCalculoGeracaoLote().getCalculo();
        if (SituacaoCalculo.ARQUIVO_GERADO.equals((Object)calculo.getSituacao())) {
            if (Objects.nonNull(calculoLoteImpressao.getIdArquivoGrafica())) {
                ArquivoRemocaoRequest arquivoRemocaoRequest = ArquivoRemocaoRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + calculoLoteImpressao.getIdArquivoGrafica().toString()));
                this.resolveArquivoClient().removerArquivo(arquivoRemocaoRequest);
                calculoLoteImpressao.setIdArquivoGrafica(null);
                calculoLoteImpressao.setDataGeracaoArquivo(null);
                calculo.setSituacao(SituacaoCalculo.CARNE_GERADO);
                this.calculoLoteImpressaoRepository.save((Object)calculoLoteImpressao);
            }
        } else {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel deletar o arquivo da gr\u00e1fica para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
        }
    }

    private void verifyIfExistsTarefa(CalculoLoteImpressao calculoLoteImpressao) {
        Boolean existsProcessoEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.IMPRESSAO_CARNE_LOTE_PDF, "CHAVE_ID_IMPRESSAO_CARNE_LOTE_PDF", String.format("%s/%s/%s", calculoLoteImpressao.getId(), calculoLoteImpressao.getCalculoGeracaoLote().getId(), calculoLoteImpressao.getCalculoGeracaoLote().getCalculo().getId()));
        if (Boolean.TRUE.equals(existsProcessoEmExecucao)) {
            throw new EloValidationException("J\u00e1 existe uma tarefa com o par\u00e2metro informado em execu\u00e7\u00e3o.");
        }
    }

    private void generateCarneLotePdf(CalculoLoteImpressao calculoLoteImpressao, UserSecurityDTO userId, TarefaAssincronaExecucao execucao, Long tarefa, Optional<UUID> notificacaoId) {
        try {
            LOGGER.debug("Iniciando Impress\u00e3o carn\u00ea a partir do lote em PDF [tipo cadastro:{}, cadastro geral:{}, data Contrato: {}]", new Object[]{calculoLoteImpressao.getId(), calculoLoteImpressao.getCalculoGeracaoLote().getId(), calculoLoteImpressao.getCalculoGeracaoLote().getCalculo().getId()});
            this.validateSituacaoCalculo(calculoLoteImpressao.getCalculoGeracaoLote().getCalculo());
            this.fetchCarneAndMerge(calculoLoteImpressao);
            LOGGER.debug("Finalizada com sucesso a impress\u00e3o carn\u00ea a partir do lote em PDF da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Impress\u00e3o carn\u00ea a partir do lote em PDF", String.format("Finalizada com sucesso a Impress\u00e3o carn\u00ea a partir do lote em PDF da tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userId, NotificationStatus.COMPLETED);
        }
        catch (Exception exception) {
            LOGGER.debug("Ocorreu um erro na Impress\u00e3o carn\u00ea a partir do lote em PDF da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
            this.notificacaoService.send("Impress\u00e3o carn\u00ea a partir do lote em PDF", String.format("Ocorreu um erro na Impress\u00e3o carn\u00ea a partir do lote em PDF da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userId, NotificationStatus.FAILED);
        }
    }

    private void fetchCarneAndMerge(CalculoLoteImpressao calculoLoteImpressao) throws IOException {
        try (PDDocument document = new PDDocument();){
            Calculo calculo = calculoLoteImpressao.getCalculoGeracaoLote().getCalculo();
            for (CalculoCadastro cadastro : calculo.getCadastros()) {
                LOGGER.debug("Fetch Tipo Cadastro {}, Cadastro {}, Carne {}", new Object[]{cadastro.getCadastro().getTipoCadastro(), cadastro.getCadastro().getTipoCadastro(), cadastro.getNumeroCarne()});
                byte[] infoCarne = this.fetchInfoCarne(cadastro.getNumeroCarne());
                this.mergeInfoToDocument(document, infoCarne);
            }
            try (InputStream fileStream = this.saveDocumentAndZip(document);){
                Arquivo arquivo = this.createNewArquivo(calculoLoteImpressao, fileStream);
                calculoLoteImpressao.setIdCarnePdf(arquivo.getId());
                calculoLoteImpressao.setDataGeracaoCarnePdf(arquivo.getDataCriacao().toLocalDate());
                this.calculoLoteImpressaoRepository.save((Object)calculoLoteImpressao);
            }
        }
    }

    private void validateSituacaoCalculo(Calculo calculo) {
        if (!Arrays.asList(SituacaoCalculo.CARNE_GERADO, SituacaoCalculo.ARQUIVO_GERADO).contains(calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel imprimir carn\u00ea a partir do lote em PDF para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
        }
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        PDFMergerUtility pdfMerge = new PDFMergerUtility();
        PDDocument pdfDocument = PDDocument.load((byte[])infoToAppendDocumento);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private InputStream saveDocumentAndZip(PDDocument document) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            document.save((OutputStream)byteArrayOutputStream);
            ZipOutputStream zipOutput = new ZipOutputStream((OutputStream)byteArrayOutputStream);
            ZipEntry pdfZipEntry = new ZipEntry("Carn\u00eas.pdf");
            zipOutput.putNextEntry(pdfZipEntry);
            document.save((OutputStream)zipOutput);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private Arquivo createNewArquivo(CalculoLoteImpressao calculoLoteImpressao, InputStream fileStream) {
        String nomeArquivo = String.format("Carn\u00eas_%s", calculoLoteImpressao.getId());
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(fileStream).contentType(ContentType.APPLICATION_ZIP).build();
        return this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
    }

    private byte[] fetchInfoCarne(Long numeroCarne) throws IOException {
        ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(numeroCarne));
        try (InputStream inputBoletoDoTermo = new URL(impressaoDTO.getUrl()).openStream();){
            byte[] byArray = inputBoletoDoTermo.readAllBytes();
            return byArray;
        }
    }

    @Generated
    public CalculoLoteImpressaoService(CalculoLoteImpressaoItemService calculoLoteImpressaoItemService, CalculoLoteImpressaoRepository calculoLoteImpressaoRepository, ResolversHandler resolversHandler, EntidadeService entidadeService, ArquivoGraficaRepository arquivoGraficaRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, AisePdfService aisePdfService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
        this.calculoLoteImpressaoRepository = calculoLoteImpressaoRepository;
        this.resolversHandler = resolversHandler;
        this.entidadeService = entidadeService;
        this.arquivoGraficaRepository = arquivoGraficaRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.aisePdfService = aisePdfService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

