/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.domain.TipoCalculo;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class SimulacaoCalculoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoCalculoJobListener.class);
    private static final String ID_CALCULO = "idCalculo";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final CalculoService calculoService;
    private final CalculoTributoService calculoTributoService;
    private final CalculoTributoExecucaoService calculoTributoExecucaoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Calculo calculo = (Calculo)this.calculoService.findOne((Serializable)idCalculo);
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada a simula\u00e7\u00e3o do c\u00e1lculo %d.", idCalculo), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
        List<SituacaoCalculo> situacoesPassiveisSimulacao = Arrays.asList(SituacaoCalculo.GERANDO_SIMULACAO, SituacaoCalculo.ERRO_SIMULACAO, SituacaoCalculo.SIMULACAO_GERADA);
        if (!situacoesPassiveisSimulacao.contains(calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel processar a simula\u00e7\u00e3o de c\u00e1lculo com a situa\u00e7\u00e3o \"%s\".", calculo.getSituacao().getDescricao()));
        }
        calculo.setSituacao(SituacaoCalculo.GERANDO_SIMULACAO);
        calculo.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        this.calculoService.save((EloEntity)calculo, null);
        List tributos = this.getFormulasCompiladas(calculo);
        jobExecution.getExecutionContext().put("tributos", (Object)tributos);
        jobExecution.getExecutionContext().put("parametroIsencaoValorMinimo", (Object)this.findParametroIsencaoValorMinimo(calculo.getExercicio()));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoSimulacaoGeradaSeTodosCadastrosCalculados(idCalculo);
            this.notificacaoService.send(String.format("Finalizada a simula\u00e7\u00e3o do c\u00e1lculo %d com sucesso.", idCalculo), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoCalculo(idCalculo, SituacaoCalculo.ERRO_SIMULACAO);
            this.notificacaoService.send(String.format("Ocorreu um erro na simula\u00e7\u00e3o do c\u00e1lculo %d.", idCalculo), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private List<CalculoTributo> getFormulasCompiladas(Calculo calculo) {
        Boolean traceAtivo = TipoCalculo.SIMPLES.equals((Object)calculo.getTipo());
        List tributos = this.findFormulas(calculo);
        for (CalculoTributo tributo : tributos) {
            CalculoBuildDTO calculoBuildDTO = this.calculoTributoExecucaoService.getFormulaCompilada((CalculoConfigBase)tributo, traceAtivo);
            tributo.setCalculoBuildDTO(calculoBuildDTO);
        }
        return tributos;
    }

    private List<CalculoTributo> findFormulas(Calculo calculo) {
        List dividas = calculo.getDividas();
        List tributos = this.calculoTributoService.findByDividasAndExercicioJoinFetchScript(dividas, calculo.getExercicio());
        if (tributos.isEmpty()) {
            String ids = dividas.stream().map(divida -> divida.getDivida().toString()).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("N\u0101o foram encontradas f\u00f3rmulas para calcular os tributos da(s) d\u00edvida(s) %s no exerc\u00edcio de %d.", ids, calculo.getExercicio()));
        }
        return tributos;
    }

    private String findParametroIsencaoValorMinimo(Long exercicio) {
        ParametroEntidadeExercicio parametroIsencaoValorMinimo = this.parametroEntidadeExercicioService.findByExercicioAndModuloAndParametro(exercicio, ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue());
        if (Objects.isNull(parametroIsencaoValorMinimo)) {
            return null;
        }
        return parametroIsencaoValorMinimo.getValor();
    }

    @Generated
    public SimulacaoCalculoJobListener(NotificacaoService notificacaoService, CalculoService calculoService, CalculoTributoService calculoTributoService, CalculoTributoExecucaoService calculoTributoExecucaoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService) {
        this.notificacaoService = notificacaoService;
        this.calculoService = calculoService;
        this.calculoTributoService = calculoTributoService;
        this.calculoTributoExecucaoService = calculoTributoExecucaoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
    }
}

