/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.movimentacaomensal;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.time.Month;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MovimentacaoMensalAtualizaSaldo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MovimentacaoMensalAtualizaSaldo.class);
    private static final String ATUALIZA_VALORES_FINAIS_PATH = "sql/simam/atualizaValoresFinais.sql";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Transactional
    public void atualizarValoresEmArquivos(LocalDate dataInicial, LocalDate dataFinal) {
        log.info("SIM-AM - Atualizando valores dos arquivos");
        String sql = this.getSqlAtualizaValoresFinais();
        if (dataFinal.getMonth().equals(Month.JANUARY)) {
            sql = sql.concat(this.getSqlAtualizaLancamentoCreditoImplantacaoSaldo());
        }
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)this.buildParametros(dataInicial, dataFinal));
        log.info("SIM-AM - Finalizado atualiza\u00e7\u00e3o dos valores dos arquivos");
    }

    private String getSqlAtualizaValoresFinais() {
        try {
            return FileUtils.readResourceAsString((String)ATUALIZA_VALORES_FINAIS_PATH);
        }
        catch (Exception e) {
            throw new EloValidationException("N\u00e3o encontrado arquivo para atualizar valores finais");
        }
    }

    private String getSqlAtualizaLancamentoCreditoImplantacaoSaldo() {
        return " UPDATE tcelanccredito  tlc \n SET vllancamento = ( \n        SELECT COALESCE(SUM(COALESCE(tdlc.valor,0)),0) \n        FROM  tcedebitolanccredito tdlc \n        WHERE tdlc.idtcelanccredito = tlc.idtcelanccredito \n     )::NUMERIC(15,2) \n WHERE tlc.idtipooperacaocredito = 2 \n    AND tlc.nranocredito = EXTRACT(YEAR FROM (:dataInicial)::date) \n    AND EXTRACT(MONTH FROM (:dataInicial)::DATE) = 1;   UPDATE tceinsccreditoda  tlc \n                 SET vlinscricao = ( \n                        SELECT COALESCE(SUM(COALESCE(tdlc.valor,0)),0) \n                        FROM  tcedebitoinsccreditoda tdlc \n                        WHERE tdlc.idtceinsccreditoda = tlc.idtceinsccreditoda \n                     ) \n                 WHERE tlc.idtipooperacaocredito = 2 \n                    AND tlc.nranodivida = EXTRACT(YEAR FROM (:dataInicial)::date)\n                    AND EXTRACT(MONTH FROM (:dataInicial)::DATE) = 1; ";
    }

    private MapSqlParameterSource buildParametros(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return parameters;
    }

    @Generated
    public MovimentacaoMensalAtualizaSaldo(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

