/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito.dividaativa;

import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCreditoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoParcelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoParcelamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.EstornoTipoDeducaoDividaAtiva;
import br.com.elotech.tributos.dto.simam.EstornoDeducaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoDeducaoCreditoDividaAtivaBatchProcessor
implements ItemProcessor<EstornoDeducaoCreditoDividaAtivaConsultaDTO, EstornoTipoDeducaoDividaAtiva> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoDeducaoCreditoDividaAtivaBatchProcessor.class);
    private static final String ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA = "SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ";
    private final AtomicLong ultimoNrDeducao = new AtomicLong(0L);
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EstornoDeducaoCreditoDividaAtivaRepository estornoDeducaoCreditoDividaAtivaRepository;
    private Long nrAnoDeducao;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        log.info("{}Iniciando gera\u00e7\u00e3o de dados", (Object)ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        log.info("{}load da carga existente", (Object)ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA);
        this.estornoDeducaoCreditoDividaAtivaRepository.getCargaExistenteDeducaoCreditoDividaAtiva(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.buildChave(), item.getId()));
        this.nrAnoDeducao = dataInicial.getYear();
        this.ultimoNrDeducao.set(this.estornoDeducaoCreditoDividaAtivaRepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public EstornoTipoDeducaoDividaAtiva process(EstornoDeducaoCreditoDividaAtivaConsultaDTO dto) {
        Long finalId = this.cargaExistente.compute(dto.buildChave(this.nrAnoDeducao), (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("s05idtceestdeducaocreditoda");
            EstornoDeducaoCreditoDividaAtiva estornoDeducaoCreditoDividaAtiva = new EstornoDeducaoCreditoDividaAtiva();
            estornoDeducaoCreditoDividaAtiva.setId(nextVal);
            estornoDeducaoCreditoDividaAtiva.setNrEstorno(Long.valueOf(this.ultimoNrDeducao.getAndIncrement()));
            estornoDeducaoCreditoDividaAtiva.setNrAnoEstorno(this.nrAnoDeducao);
            estornoDeducaoCreditoDividaAtiva.setNrDeducao(dto.getNrDeducao());
            estornoDeducaoCreditoDividaAtiva.setNrAnoDeducao(dto.getNrAnoDeducao());
            estornoDeducaoCreditoDividaAtiva.setCdControleLeiAto(dto.getIdAto());
            estornoDeducaoCreditoDividaAtiva.setDtEstorno(dto.getDtEstorno());
            estornoDeducaoCreditoDividaAtiva.setVlEstorno(dto.getVlEstorno());
            estornoDeducaoCreditoDividaAtiva.setDsMotivo(dto.getDsMotivo());
            estornoDeducaoCreditoDividaAtiva.setIdTipoCredito(dto.getIdTipoCredito());
            this.estornoDeducaoCreditoDividaAtivaRepository.saveAndFlush((Object)estornoDeducaoCreditoDividaAtiva);
            return nextVal;
        });
        if (Objects.nonNull(dto.getIdCancelamento())) {
            EstornoDeducaoCancelamentoDividaAtivaId cancelamentoId = new EstornoDeducaoCancelamentoDividaAtivaId();
            cancelamentoId.setIdTceDeducaoCreditoDAEst(finalId);
            cancelamentoId.setIdDebitoParcelaTributo(dto.getIdDebitoParcelaReceita());
            cancelamentoId.setIdCancelamento(dto.getIdCancelamento());
            cancelamentoId.setEntidade(dto.getEntidade());
            cancelamentoId.setExercicio(dto.getExercicio());
            EstornoDeducaoCancelamentoDividaAtiva cancelamento = new EstornoDeducaoCancelamentoDividaAtiva();
            cancelamento.setId(cancelamentoId);
            cancelamento.setValor(dto.getVlEstorno());
            return cancelamento;
        }
        if (Objects.nonNull(dto.getIdPagamentoBloqueto())) {
            EstornoDeducaoPagamentoDividaAtivaId pagamentoId = new EstornoDeducaoPagamentoDividaAtivaId();
            pagamentoId.setIdTceDeducaoCreditoDAEst(finalId);
            pagamentoId.setIdPagamentoBoleto(dto.getIdPagamentoBloqueto());
            pagamentoId.setIdDebitoParcelaTributo(dto.getIdDebitoParcelaReceita());
            EstornoDeducaoPagamentoDividaAtiva pagamento = new EstornoDeducaoPagamentoDividaAtiva();
            pagamento.setId(pagamentoId);
            pagamento.setValor(dto.getVlEstorno());
            return pagamento;
        }
        if (Objects.nonNull(dto.getIdParcelamento())) {
            EstornoDeducaoParcelamentoDividaAtivaId id = new EstornoDeducaoParcelamentoDividaAtivaId();
            id.setIdParcelamento(dto.getIdParcelamento());
            id.setIdDebitoParcelaTributo(dto.getIdDebitoParcelaReceita());
            id.setIdTceDeducaoCreditoDaEst(finalId);
            EstornoDeducaoParcelamentoDividaAtiva estornoDeducaoParcelamentoDividaAtiva = new EstornoDeducaoParcelamentoDividaAtiva();
            estornoDeducaoParcelamentoDividaAtiva.setId(id);
            estornoDeducaoParcelamentoDividaAtiva.setValor(dto.getVlEstorno());
            return estornoDeducaoParcelamentoDividaAtiva;
        }
        EstornoDeducaoCreditoCreditoDividaAtivaId creditoId = new EstornoDeducaoCreditoCreditoDividaAtivaId();
        creditoId.setIdTceDeducaoCreditoDAEst(finalId);
        creditoId.setIdCreditoContribuinteItem(dto.getIdCreditoContribuinteItem());
        creditoId.setIdDebitoParcelaTributo(dto.getIdDebitoParcelaReceita());
        EstornoDeducaoCreditoCreditoDividaAtiva credito = new EstornoDeducaoCreditoCreditoDividaAtiva();
        credito.setId(creditoId);
        credito.setValor(dto.getVlEstorno());
        return credito;
    }

    @OnProcessError
    public void onProcessError(EstornoDeducaoCreditoDividaAtivaConsultaDTO item, Exception e) throws Exception {
        log.error("{}erro: {}\n{})", new Object[]{ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA, e.getMessage(), ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item)});
    }

    @Generated
    public EstornoDeducaoCreditoDividaAtivaBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, EstornoDeducaoCreditoDividaAtivaRepository estornoDeducaoCreditoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.estornoDeducaoCreditoDividaAtivaRepository = estornoDeducaoCreditoDividaAtivaRepository;
    }
}

