/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamentoId;
import br.com.elotech.tributos.domain.simam.DeducaoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCreditoId;
import br.com.elotech.tributos.domain.simam.DeducaoIsencao;
import br.com.elotech.tributos.domain.simam.DeducaoIsencaoId;
import br.com.elotech.tributos.domain.simam.DeducaoPagamento;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoId;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamento;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamentoId;
import br.com.elotech.tributos.domain.simam.TipoDeducaoCredito;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoConsultaDTO;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class DeducaoCreditoBatchProcessor
implements ItemProcessor<DeducaoCreditoConsultaDTO, TipoDeducaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeducaoCreditoBatchProcessor.class);
    private static final String DEDUCAO_CREDITO = "SIM-AM - Dedu\u00e7\u00f5es de Cr\u00e9ditos - ";
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong ultimoNrDeducao = new AtomicLong(0L);
    private Long nrAnoDeducao;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final DeducaoCreditoRepository deducaoCreditoRepository;
    private final EntidadeRepository entidadeRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        log.info("{}Iniciando gera\u00e7\u00e3o de dados", (Object)DEDUCAO_CREDITO);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        log.info("{}Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{DEDUCAO_CREDITO, dataInicial, dataFinal, entidade});
        this.nrAnoDeducao = dataInicial.getYear();
        log.info("{}load da carga existente", (Object)DEDUCAO_CREDITO);
        this.deducaoCreditoRepository.getCargaExistenteDeducaoCredito(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.buildChave(), item.getId()));
        log.info("{}atualizando \u00faltimo NrDeducao", (Object)DEDUCAO_CREDITO);
        this.ultimoNrDeducao.set(this.deducaoCreditoRepository.findNextNrDeducaoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public TipoDeducaoCredito process(DeducaoCreditoConsultaDTO item) {
        Long finalId = this.cargaExistente.compute(item.buildChave(this.nrAnoDeducao), (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCEDEDUCAOCREDITO");
            DeducaoCredito deducaoCredito = new DeducaoCredito();
            deducaoCredito.setId(nextVal);
            deducaoCredito.setDtDeducao(item.getDtDeducao());
            deducaoCredito.setVlDeducao(item.getValor());
            deducaoCredito.setIdTipoDeducaoCredito(TipoDeducaoEnum.fromValue((Long)item.getIdTipoDeducaoCredito()));
            deducaoCredito.setMotivo(item.getDsMotivo());
            deducaoCredito.setNrAnoDeducao(this.nrAnoDeducao);
            deducaoCredito.setNrDeducao(Long.valueOf(this.ultimoNrDeducao.getAndIncrement()));
            deducaoCredito.setNrCredito(item.getNrCredito());
            deducaoCredito.setNrAnoCredito(item.getNrAnoCredito());
            deducaoCredito.setCdControleLeiAto(item.getCdControleLeiAto());
            deducaoCredito.setIdTipoCredito(item.getIdTipoCredito());
            log.info("{}gerando novo registro -> {} ({}/{})", new Object[]{DEDUCAO_CREDITO, nextVal, deducaoCredito.getNrDeducao(), deducaoCredito.getNrAnoDeducao()});
            this.deducaoCreditoRepository.save((Object)deducaoCredito);
            this.entityManager.flush();
            return nextVal;
        });
        if (Objects.isNull(item.getIdCancelamento()) && Objects.isNull(item.getIdPagamentoBloqueto()) && Objects.isNull(item.getIdDebitoReceita()) && Objects.isNull(item.getIdCreditoContribuinteItem()) && Objects.isNull(item.getIdParcelamento())) {
            return null;
        }
        if (Objects.nonNull(item.getIdCancelamento())) {
            DeducaoCancelamentoId id = new DeducaoCancelamentoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            id.setEntidade((Entidade)this.entidadeRepository.getOne((Object)item.getEntidade()));
            id.setExercicio(item.getExercicio());
            id.setIdCancelamento(item.getIdCancelamento());
            DeducaoCancelamento deducaoCancelamento = new DeducaoCancelamento();
            deducaoCancelamento.setId(id);
            deducaoCancelamento.setValor(item.getValor());
            return deducaoCancelamento;
        }
        if (Objects.nonNull(item.getIdPagamentoBloqueto())) {
            DeducaoPagamentoId id = new DeducaoPagamentoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setIdPagamentoBoleto(item.getIdPagamentoBloqueto());
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            DeducaoPagamento deducaoPagamento = new DeducaoPagamento();
            deducaoPagamento.setId(id);
            deducaoPagamento.setValor(item.getValor());
            return deducaoPagamento;
        }
        if (Objects.nonNull(item.getIdDebitoReceita())) {
            DeducaoIsencaoId id = new DeducaoIsencaoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setIdDebitoReceita(item.getIdDebitoReceita());
            DeducaoIsencao deducaoIsencao = new DeducaoIsencao();
            deducaoIsencao.setId(id);
            deducaoIsencao.setValor(item.getValor());
            return deducaoIsencao;
        }
        if (Objects.nonNull(item.getIdCreditoContribuinteItem())) {
            DeducaoCreditoCreditoId id = new DeducaoCreditoCreditoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem(item.getIdCreditoContribuinteItem());
            id.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
            DeducaoCreditoCredito deducaoCreditoCredito = new DeducaoCreditoCredito();
            deducaoCreditoCredito.setId(id);
            deducaoCreditoCredito.setValor(item.getValor());
            return deducaoCreditoCredito;
        }
        if (Objects.nonNull(item.getIdParcelamento())) {
            DeducaoParcelamentoId id = new DeducaoParcelamentoId();
            id.setDeducaoCredito((DeducaoCredito)this.entityManager.getReference(DeducaoCredito.class, (Object)finalId));
            id.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
            id.setIdParcelamento(item.getIdParcelamento());
            DeducaoParcelamento deducaoParcelamento = new DeducaoParcelamento();
            deducaoParcelamento.setId(id);
            deducaoParcelamento.setValor(item.getValor());
            return deducaoParcelamento;
        }
        return null;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        log.error("{}erro: {}\n{})", new Object[]{DEDUCAO_CREDITO, e.getMessage(), ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item)});
    }

    @Generated
    public DeducaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, DeducaoCreditoRepository deducaoCreditoRepository, EntidadeRepository entidadeRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.deducaoCreditoRepository = deducaoCreditoRepository;
        this.entidadeRepository = entidadeRepository;
    }
}

