/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaRetornoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRelatorioRetornoDTO;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.integracaoprotestocra.IntegracaoProtestoCraService;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EnvioProtestoRemessaBatchWriter
implements ItemWriter<ProtestoRemessaItem> {
    private static final String ID_PROTESTO_REMESSA = "idProtestoRemessa";
    private final ProtestoRemessaItemService protestoRemessaItemService;
    private final ProtestoRemessaService protestoRemessaService;
    private final IntegracaoProtestoCraService integracaoProtestoCraService;

    public void write(List<? extends ProtestoRemessaItem> items) throws Exception {
        items.forEach(item -> this.protestoRemessaItemService.save((EloEntity)item, null));
    }

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            boolean hasRegistrosComErro;
            Long idProtestoRemessa = stepExecution.getJobParameters().getLong(ID_PROTESTO_REMESSA);
            ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaService.findOne((Serializable)idProtestoRemessa);
            CraRelatorioRetornoDTO craRelatorioRetornoDTO = this.integracaoProtestoCraService.enviarRemessa(protestoRemessa);
            if (craRelatorioRetornoDTO.isEnvioComErro()) {
                stepExecution.setStatus(BatchStatus.FAILED);
                stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription("Falha ao enviar remessa para o CRA: \nNome do Arquivo: " + craRelatorioRetornoDTO.getNomeArquivo() + "\nC\u00f3digo da Ocorr\u00eancia: " + craRelatorioRetornoDTO.getCodigo() + "\nOcorr\u00eancia: " + craRelatorioRetornoDTO.getOcorrencia() + "\n"));
                return stepExecution.getExitStatus();
            }
            boolean bl = hasRegistrosComErro = !craRelatorioRetornoDTO.getComarcas().stream().allMatch(CraComarcaRetornoDTO::isRegistrosOk);
            if (hasRegistrosComErro) {
                ExitStatus exitStatus = ExitStatus.FAILED.addExitDescription("Falha ao enviar remessa para o CRA: \n");
                craRelatorioRetornoDTO.getComarcas().stream().filter(comarca -> !comarca.isRegistrosOk()).forEach(comarca -> exitStatus.addExitDescription(exitStatus.getExitDescription() + "C\u00f3digo da Ocorr\u00eancia: " + comarca.getCodigo() + "\nOcorr\u00eancia: " + comarca.getOcorrencia() + "\n"));
                stepExecution.setStatus(BatchStatus.FAILED);
                stepExecution.setExitStatus(exitStatus);
                return exitStatus;
            }
            return ExitStatus.COMPLETED;
        }
        catch (Exception e) {
            stepExecution.setStatus(BatchStatus.FAILED);
            stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription((Throwable)e));
            return stepExecution.getExitStatus();
        }
    }

    @Generated
    public EnvioProtestoRemessaBatchWriter(ProtestoRemessaItemService protestoRemessaItemService, ProtestoRemessaService protestoRemessaService, IntegracaoProtestoCraService integracaoProtestoCraService) {
        this.protestoRemessaItemService = protestoRemessaItemService;
        this.protestoRemessaService = protestoRemessaService;
        this.integracaoProtestoCraService = integracaoProtestoCraService;
    }
}

