/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.correcaocarnecalculo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class CorrecaoCarneCalculoBatchProcessor
implements ItemProcessor<Long, Bloqueto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CorrecaoCarneCalculoBatchProcessor.class);
    private final CalculoCadastroService calculoCadastroService;
    private final CarneService carneService;
    private final FormaPagamentoService formaPagamentoService;
    private final GeraBoletoService geraBoletoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos;

    @BeforeStep
    public void beforeStep() {
        this.parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
    }

    public Bloqueto process(Long idCalculoCadastro) throws Exception {
        CalculoCadastro calculoCadastro = (CalculoCadastro)this.calculoCadastroService.findOne((Serializable)idCalculoCadastro);
        CarneId idCarne = new CarneId(calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne());
        Carne carne = (Carne)this.carneService.findOne((Serializable)idCarne);
        List boletosDeCotaUnica = carne.getBoletos().stream().filter(cb -> TipoBloqueto.COTA_UNICA.equals((Object)cb.getBoleto().getTipoBloqueto())).collect(Collectors.toList());
        if (boletosDeCotaUnica.isEmpty()) {
            throw new EloValidationException("Carne sem cota unica");
        }
        if (boletosDeCotaUnica.size() > 1) {
            throw new EloValidationException("Carne com mais de uma cota unica");
        }
        CarneBoleto cotaAntiga = (CarneBoleto)boletosDeCotaUnica.get(0);
        FormaPagamento formaPagamento = this.formaPagamentoService.findOne(cotaAntiga.getBoleto().getFormaPagamento());
        Optional boletoGerado = this.geraNovaCota(calculoCadastro, formaPagamento, carne.getId().getExercicio());
        boletoGerado.ifPresent(novaCota -> {
            carne.addBoleto(novaCota);
            carne.getBoletos().remove(cotaAntiga);
            this.carneService.save(carne);
            log.debug("Substituindo boletos de cota do carne {}/{}. Boleto antigo: {}, Boleto novo: {}", new Object[]{idCarne.getCarne(), idCarne.getExercicio(), novaCota.getId(), cotaAntiga.getBoleto().getId()});
        });
        return boletoGerado.orElse(null);
    }

    private Optional<Bloqueto> geraNovaCota(CalculoCadastro calculoCadastro, FormaPagamento formaPagamento, Long exercicio) {
        Debito debito = calculoCadastro.getDebito();
        List debitosBoleto = debito.getParcelas().stream().map(parcela -> {
            if (!parcela.getSituacaoDebito().isAberto().booleanValue()) {
                log.warn("Parcela {} do debito {} n\u00e3o est\u00e1 aberta, por isso n\u00e3o vai gerar nova cota unica.", (Object)parcela.getId().getParcela(), (Object)debito.getId());
                return null;
            }
            return DebitoParcelaDTO.convertBoleto((DebitoParcela)parcela, (Long)debito.getId());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (debitosBoleto.isEmpty()) {
            log.warn("N\u00e3o vai ser gerado cota unica para o debito {} pois ele n\u00e3o possui nenhuma parcela aberta.", (Object)debito.getId());
            return Optional.empty();
        }
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)formaPagamento.getTipoFormaPagamento().getValue()));
        geraBoletoDTO.setDebitos(debitosBoleto);
        geraBoletoDTO.setExercicio(exercicio);
        geraBoletoDTO.setImpressaoCarne(Boolean.TRUE);
        return this.geraBoletoService.geraBoleto(geraBoletoDTO, formaPagamento.getId(), Boolean.FALSE, this.parametrosAcrescimos).stream().findFirst();
    }

    @Generated
    public CorrecaoCarneCalculoBatchProcessor(CalculoCadastroService calculoCadastroService, CarneService carneService, FormaPagamentoService formaPagamentoService, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService) {
        this.calculoCadastroService = calculoCadastroService;
        this.carneService = carneService;
        this.formaPagamentoService = formaPagamentoService;
        this.geraBoletoService = geraBoletoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
    }
}

