/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicadolivroda;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoLivroDABatchReader
extends JdbcCursorItemReader<ComunicadoDebitoConsultaDTO> {
    public ComunicadoLivroDABatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long livro = (Long)jobParameters.get("livro");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long entidade = (Long)jobParameters.get("entidade");
        this.setFetchSize(1000);
        this.setName("comunicadoDebitoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoDebitoConsultaDTO.class));
        this.setSql(String.format("select tlr.entidade,       tlr.exercicio,       tlr.livro as id,       tcg.idkey as idCadastro,      td.iddebito as idDebito,   tlr.pessoacontribuinte as codigoPessoa,       tlr.nomecontribuinte as nomePessoa,       tlr.tipocadastro as tipocadastro,       tlr.cadastrogeral as cadastrogeral      from triblivroregistro tlr      left join triblivroparcelareceita tlpr on       tlr.entidade = tlpr.entidade and        tlr.exercicio = tlpr.exercicio and        tlr.livro = tlpr.livro and        tlr.sequencia = tlpr.sequencia      left join tribcadastrogeral tcg on       tlr.tipocadastro = tcg.tipocadastro and        tlr.cadastrogeral = tcg.cadastrogeral and        tlr.pessoacontribuinte = tcg.pessoa      left join tribdebitoparcelareceita tdpr on    tlpr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita   left join tribdebito td on    tdpr.entidade = td.entidade and     tdpr.exercicio = td.exercicio and     tdpr.tipocadastro = td.tipocadastro and     tdpr.cadastrogeral = td.cadastrogeral and     tdpr.guiarecolhimento = td.guiarecolhimento and     tdpr.subdivida = td.subdivida  where tlr.entidade = %s     and tlr.exercicio = %s      and tlr.livro = %s group by tlr.entidade,       tlr.exercicio,       tlr.livro,       tlr.pessoacontribuinte,       tlr.nomecontribuinte,       tlr.tipocadastro,       tlr.cadastrogeral,   tcg.idkey,    td.iddebito order by tlr.tipocadastro,       tlr.cadastrogeral;", entidade, exercicio, livro));
    }
}

