/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoByConsultaDebitoBatchReader
extends JdbcCursorItemReader<ComunicadoDebitoConsultaDTO> {
    public ComunicadoByConsultaDebitoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long idConsultaDebito = (Long)jobParameters.get("idConsultaDebito");
        this.setFetchSize(1000);
        this.setName("comunicadoDebitoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoDebitoConsultaDTO.class));
        this.setSql("select       consultadebito.id as id,       td.iddebito as idDebito,  consultadebitoitem.tipocadastro,       tcg.idkey as idCadastro,      consultadebitoitem.cadastrogeral,       consultadebitoitem.pessoa as codigoPessoa,       pessoa.nome as nomePessoa       from consultadebito       join consultadebitoitem on       consultadebito.id = consultadebitoitem.idconsultadebito     join tribdebitoparcelareceita tdpr on     consultadebitoitem.iddebitotributo  = tdpr.iddebitoparcelareceita   join tribdebito td on     td.entidade = tdpr.entidade and      td.exercicio = tdpr.exercicio and     td.tipocadastro = tdpr.tipocadastro and     td.cadastrogeral = tdpr.cadastrogeral and      td.guiarecolhimento = tdpr.guiarecolhimento and      td.subdivida = tdpr.subdivida   left join pessoa on       consultadebitoitem.pessoa = pessoa.pessoa       left join tribguiarecolhimento divida on       consultadebitoitem.entidade = divida.entidade       and           consultadebitoitem.exercicio = divida.exercicio       and           consultadebitoitem.divida = divida.guiarecolhimento       left join tribcadastrogeral tcg on      tcg.tipocadastro = consultadebitoitem.tipocadastro and      tcg.cadastrogeral = consultadebitoitem.cadastrogeral       left join tribreceitatipo tipotributo on       consultadebitoitem.tipotributo = tipotributo.tiporeceita       where       consultadebito.id = " + idConsultaDebito + " group by       consultadebito.id,       consultadebitoitem.tipocadastro,       consultadebitoitem.cadastrogeral,       consultadebitoitem.pessoa,       tcg.idkey,  td.iddebito,  pessoa.nome; ");
    }
}

