select distinct
    3                                                  as idTipoOperacaoCredito,
    null                                                as idTipoNaturezaCredito,
    null                                                as idTipoCredito,
    tdpd.datadividaativa                                as dtInscricao,
    tdprd.valororiginal                                 as vlInscricao,
    tdpr.iddebitoparcelareceita                         as idDebitoParcelaTributoOrigem,
    tdprd.iddebitoparcelareceita                        as idDebitoParcelaTributoDestino,
    td.formacorrecao                                    as formaCorrecao,
    tgr.idkey                                           as idDivida,
    td.entidade                                         as entidade,
    td.exercicio                                        as exercicio,
    null                                                as nrAnoBase,
    tgr.fundamentolegal                                 as cdControleLeiAto,
    tlc.nrCredito,
    tlc.nrAnoCredito
from triblivro tl
left outer join triblivroregistro tlr
 on tlr.entidade = tl.entidade
and tlr.exercicio = tl.exercicio
and tlr.livro = tl.livro
left outer join triblivroparcelareceita tlpr
 on tlpr.entidade = tlr.entidade
and tlpr.exercicio = tlr.exercicio
and tlpr.livro = tlr.livro
and tlpr.sequencia = tlr.sequencia
left outer join tribdebitoparcelareceita tdpr -- origem
 on tdpr.iddebitoparcelareceita = tlpr.iddebitoparcelareceita
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribdebito td
 on tdpr.entidade = td.entidade
and tdpr.exercicio = td.exercicio
and tdpr.tipocadastro = td.tipocadastro
and tdpr.cadastrogeral = td.cadastrogeral
and tdpr.guiarecolhimento = td.guiarecolhimento
and tdpr.subdivida = td.subdivida
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and :exercicio = tr.exercicio
and tdr.receita   = tr.receita
join tribguiarecolhimento tgr
  on td.entidade = tgr.entidade
      and td.exercicio = tgr.exercicio
      and td.guiarecolhimento = tgr.guiarecolhimento
left join cgato ca on ca.entidade = tgr.entidade and ca.idato = tgr.fundamentolegal
join tribdebitoparcelareceita tdprd
  on tdprd.entidade = tdpr.entidade
      and tdprd.exercicio = tdpr.exercicio
      and tdprd.tipocadastro = tdpr.tipocadastro -- destino
      and tdprd.cadastrogeral = tdpr.cadastrogeral
      and tdprd.guiarecolhimento = tdpr.guiarecolhimento
      and tdprd.receita = tdpr.receita
      and (
      	(tl.englobaparcelas = 'S'
      		and (tgr.tipoguiarecolhimento <> 'H' or tgr.subdividapelovencimento = 'S')
      		and tdprd.subdivida = tlpr.novasubdivida
      	)
      	or (
      		(tl.englobaparcelas = 'N' or tgr.tipoguiarecolhimento = 'H')
      		and tdprd.parcela = tdpr.parcela
      		and tdprd.subdivida = tdpr.subdivida)
      	)
join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
join tribdebitoparcela tdpd
  on tdpd.entidade = tdprd.entidade
      and tdpd.exercicio = tdprd.exercicio
      and tdpd.tipocadastro = tdprd.tipocadastro /*DebitoParcela Destino*/
      and tdpd.cadastrogeral = tdprd.cadastrogeral
      and tdpd.guiarecolhimento = tdprd.guiarecolhimento
      and tdpd.subdivida = tdprd.subdivida
      and tdpd.parcela = tdprd.parcela
left join tcedebitolanccredito tdl on tdl.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
left join tcelanccredito tlc on tlc.idtcelanccredito = tdl.idtcelanccredito
where tl.datainclusao between :dataInicial and :dataFinal
  AND tdprd.valororiginal > 0
  and trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
  and td.entidade = :entidade
  and not exists(
        select 1
        from tceDebitoInscCreditoDA tdicDA
        where tdicDA.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
    )
order by tdpd.datadividaativa,
         tlc.nrcredito,
         tlc.nrAnoCredito,
         td.exercicio,
         tgr.fundamentolegal