select filtro.nrArrecadacao,
                   filtro.nrAnoArrecadacao,
                   filtro.vlEstorno,
                   filtro.dtEstorno,
                   filtro.idpagamentobloqueto,
                   filtro.idcreditocontribuinteitem,
                   filtro.iddebitoparcelareceita
            from
            (
               SELECT atc.nrArrecadacao,
                      atc.nrAnoArrecadacao,
                      tpd.valorpago as vlEstorno,
                      tep.data as dtEstorno,
                   	 tpd.idpagamentobloqueto,
                      0 as idcreditocontribuinteitem,
                      tpd.iddebitoparcelareceita
               from tribestornopagamento             tep
                    join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                    join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               	   join tceArrTipoCreditoPagamento  atcp on atcp.idpagamentobloqueto = tepi.idpagamentobloqueto and atcp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               		 join tceArrecadacaoTipoCredito   atc  on atc.idtcearrtipocredito = atcp.idtcearrtipocredito
               where tep.entidade = :entidade
                 and tep.data BETWEEN :dataInicial AND :dataFinal
                 and tpd.valorpago > 0
                 and tep.geracreditocontribuinte = 'N'
                 and not exists (
                     select 1
                     from tceArrTipoCreditoPagamentoEst atcp
                     where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                       and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto
                 )
               union all
               SELECT atc.nrArrecadacao,
                      atc.nrAnoArrecadacao,
                      tcci.valorestornado as vlEstorno,
                      tcc.dataestorno as dtEstorno,
                   	  0 as idpagamentobloqueto,
                      atcc.idcreditocontribuinteitem,
                      atcc.iddebitoparcelareceita
               from tribcreditocontribuinte           tcc
                    join tribCreditoContribuinteItem  tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
               	   join tcearrtipocreditocredito     atcc on atcc.idcreditoContribuinteItem = tcci.idCreditoContribuinteItem and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               		 join tceArrecadacaoTipoCredito    atc  on atc.idtcearrtipocredito = atcc.idtcearrtipocredito
               where tcc.entidade = :entidade
                 and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
                 and tcc.valorestornado > 0
                 and not exists (
                     select 1
                     from tceArrTipoCreditoCreditoEst atcc
                     where atcc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                       and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 )
            ) filtro
            order by filtro.dtEstorno,
                     filtro.nrArrecadacao,
                     filtro.nrAnoArrecadacao
