SELECT
    filtro.nrCredito,
    filtro.nrAnoCredito,
    filtro.idTipoDeducaoCredito,
    filtro.dtDeducao,
    filtro.cdControleLeiAto,
    filtro.dsMotivo,
    filtro.valor,
    filtro.entidade,
    filtro.exercicio,
    filtro.idCancelamento,
    filtro.idpagamentobloqueto,
    filtro.iddebitoreceita,
    filtro.iddebitoparcelareceita,
    filtro.idcreditocontribuinteitem,
    filtro.idParcelamento,
    filtro.idTipoCredito
FROM (
         /*Cancelamento*/
         SELECT DISTINCT td.tipotce                                                      AS idTipoDeducaoCredito,
                         cd.datacancelamento                                             AS dtDeducao,
                         COALESCE(tcdi.valorAtualizado, tcdi.valor)                      AS valor,
                         tlc.nrCredito                                                   AS nrCredito,
                         tlc.nrAnoCredito                                                AS nrAnoCredito,
                         md.idato                                                        AS cdControleLeiAto,
                         substr(md.descricao || '. ' || COALESCE(cd.motivo, ''), 0, 250) AS dsMotivo,
                         tcdi.entidade                                                   AS entidade,
                         tcdi.exercicio                                                  AS exercicio,
                         tcdi.idcancelamento                                             AS idCancelamento,
                         cast(NULL AS integer)                                           AS idpagamentobloqueto,
                         cast(NULL AS integer)                                           AS iddebitoreceita,
                         tcdi.iddebitoparcelareceita                                     AS idDebitoParcelaReceita,
                         cast(NULL AS integer)                                           AS idcreditocontribuinteitem,
                         cast(NULL AS integer)                                           AS idParcelamento,
                         trt.classificacaoreceitatipo                                    AS idTipoCredito
         FROM tribcancelamentodebito cd
                  JOIN tribcancelamentodebitoitem tcdi
                       ON tcdi.entidade = cd.entidade AND tcdi.exercicio = cd.exercicio AND
                          tcdi.idcancelamento = cd.idcancelamento
                  LEFT JOIN tribmotivodesconto md ON md.motivodesconto = cd.motivocancelamento
                  LEFT JOIN tribtipodeducao td ON td.tipodeducao = COALESCE(md.tipodeducao, cd.tipodeducao)
                  JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                  JOIN tribdebito tdeb ON tdeb.exercicio = tdpr.exercicio AND tdeb.entidade = tdpr.entidade AND
                                          tdeb.cadastrogeral = tdpr.cadastrogeral AND tdeb.tipocadastro = tdpr.tipocadastro AND
                                          tdeb.guiarecolhimento = tdpr.guiarecolhimento AND tdeb.subdivida = tdpr.subdivida
                  LEFT JOIN tribreceita tr ON tr.entidade = tdpr.entidade AND tr.exercicio = :exercicio AND
                                              tr.receita = tdpr.receita
                  JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                  JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                  LEFT JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
                  LEFT JOIN cgato ca ON ca.entidade = md.entidade AND ca.idato = md.idato
         WHERE (cd.datacancelamento BETWEEN :dataInicial AND :dataFinal)
           AND cd.entidade = :entidade
           AND cd.tipodeducao <> 8
           AND tcrt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
           AND td.tipotce IN (1, 2, 3, 4, 5, 6)
           AND tcdi.situacaolegal = 0
           AND COALESCE(tcdi.valorAtualizado, tcdi.valor) > 0
           AND tdeb.constituido = 'S'
           AND NOT EXISTS (SELECT 1 FROM tribestornoparcelamentodebito tepd
                                             LEFT OUTER JOIN tribestornoparcelamento tep
                                                             ON tepd.idestornoparcelamento = tep.idestornoparcelamento
                           WHERE (tepd.iddebitoorigem = tdeb.iddebito AND cd.datacancelamento = tep.dataestorno)
                              or (tepd.iddebitodestino = tdeb.iddebito AND tep.estornado = 'S' AND cd.datacancelamento = tep.datareabilitacao))
           AND NOT EXISTS (SELECT 1
                           FROM tceDeducaoCancelamento tdc
                           WHERE tdc.entidade = tcdi.entidade
                             AND tdc.exercicio = tcdi.exercicio
                             AND tdc.idcancelamento = tcdi.idcancelamento
                             AND tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita)
         UNION ALL
         /*pagamento*/
         SELECT DISTINCT ttd.tipotce                                                            AS idTipoDeducaoCredito,
                         tp.datalancamento                                                      AS dtDeducao,
                         COALESCE(tpd.valordesconto, 0)                                         AS valor,
                         tlc.nrCredito                                                          AS nrCredito,
                         tlc.nrAnoCredito                                                       AS nrAnoCredito,
                         tmd.idato                                                              AS cdControleLeiAto,
                         substr(tmd.descricao || '. ' || COALESCE(tbad.observacao, ''), 0, 250) AS dsMotivo,
                         tp.entidade                                                            AS entidade,
                         tp.exerciciopagamento                                                  AS exercicio,
                         cast(NULL AS integer)                                                  AS idCancelamento,
                         tpd.idpagamentobloqueto                                                AS idpagamentobloqueto,
                         cast(NULL AS integer)                                                  AS iddebitoreceita,
                         tpd.iddebitoparcelareceita                                             AS idDebitoParcelaReceita,
                         cast(NULL AS integer)                                                  AS idcreditocontribuinteitem,
                         cast(NULL AS integer)                                                  AS idParcelamento,
                         trt.classificacaoreceitatipo                                           AS idTipoCredito
         FROM tribpagamentodebito tpd
                  JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                  JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade AND tdp.exercicio = tdpr.exercicio AND
                                                tdp.tipocadastro = tdpr.tipocadastro
             AND tdp.cadastrogeral = tdpr.cadastrogeral AND tdp.guiarecolhimento = tdpr.guiarecolhimento
             AND tdp.subdivida = tdpr.subdivida AND tdp.parcela = tdpr.parcela
                  JOIN tribpagamentobloqueto tpb ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
                  JOIN tribpagamento tp
                       ON tp.entidade = tpb.entidade AND tp.exerciciopagamento = tpb.exerciciopagamento AND
                          tp.pagamento = tpb.pagamento
                  LEFT JOIN tribbaixaautomaticadetalhe tbad
                            ON tbad.entidade = tp.entidade AND tbad.exerciciopagamento = tp.exerciciopagamento AND
                               tbad.pagamento = tp.pagamento
                  LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tpb.motivodesconto
                  LEFT JOIN tribtipodeducao ttd ON ttd.tipodeducao = tmd.tipodeducao
                  LEFT JOIN tribreceita tr ON tr.entidade = tdpr.entidade AND tr.exercicio = :exercicio AND
                                              tr.receita = tdpr.receita
                  JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                  JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                  LEFT JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
                  LEFT JOIN cgato ca ON ca.entidade = tmd.entidade AND ca.idato = tmd.idato
                  LEFT JOIN contabancaria cb ON cb.entidade = tp.entidade AND cb.contabancaria = tp.contabancaria
         WHERE (tp.datalancamento BETWEEN :dataInicial AND :dataFinal)
           AND tp.entidade = :entidade
           AND tpd.valordesconto > 0
           AND tdp.situacaolegal = 0
           AND ttd.tipotce IN (1, 2, 3, 4, 5, 6)
           AND COALESCE(cb.integraarrecadacao, 'S') = 'S'
           AND tcrt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
           AND NOT EXISTS (SELECT 1
                           FROM tceDeducaoPagamento tdp
                           WHERE tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                             AND tdp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
         UNION ALL
         /*isencao*/
         SELECT DISTINCT ttd.tipotce                                      AS idTipoDeducaoCredito,
                         COALESCE(td.datacontabilizacao, td.datainclusao) AS dtDeducao,
                         COALESCE(tdri.valorisencao, 0)                   AS valor,
                         tlc.nrCredito                                    AS nrCredito,
                         tlc.nrAnoCredito                                 AS nrAnoCredito,
                         tmd.idato                                        AS cdControleLeiAto,
                         tmd.descricao                                    AS dsMotivo,
                         td.entidade                                      AS entidade,
                         td.exercicio                                     AS exercicio,
                         cast(NULL AS integer)                            AS idcancelamento,
                         cast(NULL AS integer)                            AS idpagamentobloqueto,
                         tdr.iddebitoreceita                              AS idDebitoReceita,
                         cast(NULL AS integer)                            AS idDebitoParcelaReceita,
                         cast(NULL AS integer)                            AS idcreditocontribuinteitem,
                         cast(NULL AS integer)                            AS idParcelamento,
                         trt.classificacaoreceitatipo                     AS idTipoCredito
         FROM tribdebitoreceitaisencao tdri
                  JOIN tribdebitoreceita tdr ON tdr.entidade = tdri.entidade AND tdr.exercicio = tdri.exercicio AND
                                                tdr.tipocadastro = tdri.tipocadastro
             AND tdr.cadastrogeral = tdri.cadastrogeral AND tdr.guiarecolhimento = tdri.guiarecolhimento
             AND tdr.subdivida = tdri.subdivida AND tdr.receita = tdri.receita
                  JOIN tribdebito td ON td.entidade = tdri.entidade AND td.exercicio = tdri.exercicio AND
                                        td.tipocadastro = tdri.tipocadastro
             AND td.cadastrogeral = tdri.cadastrogeral AND td.guiarecolhimento = tdri.guiarecolhimento AND
                                        td.subdivida = tdri.subdivida
                  JOIN tribisencao i ON i.isencao = tdri.isencao
                  LEFT JOIN tribreceita tr
                            ON  tr.receita = tdr.receita
                                and tr.exercicio = :exercicio AND tr.entidade = tdr.entidade
                  JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                  JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = i.motivodesconto
                  LEFT JOIN tribtipodeducao ttd ON ttd.tipodeducao = i.tipodeducao
                  JOIN tribdebitoparcelareceita tdpr
                       ON tdpr.entidade = tdri.entidade AND tdpr.exercicio = tdri.exercicio AND
                          tdpr.tipocadastro = tdri.tipocadastro
                           AND tdpr.cadastrogeral = tdri.cadastrogeral AND tdpr.guiarecolhimento = tdri.guiarecolhimento
                           AND tdpr.subdivida = tdri.subdivida AND tdpr.receita = tdri.receita
                  LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                  LEFT JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
                  LEFT JOIN cgato ca ON ca.entidade = tmd.entidade AND ca.idato = tmd.idato
         WHERE (((td.DataInclusao BETWEEN :dataInicial AND :dataFinal) AND td.DataContabilizacao IS NULL) or
                (td.DataContabilizacao BETWEEN :dataInicial AND :dataFinal))
           AND td.entidade = :entidade
           AND tdri.valorisencao > 0
           AND ttd.tipotce IN (1, 2, 3, 4, 5, 6)
           AND tcrt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
           AND td.constituido = 'S'
           AND NOT EXISTS (SELECT 1 FROM tceDeducaoIsencao tdi WHERE tdi.iddebitoreceita = tdr.iddebitoreceita)
           AND NOT EXISTS(SELECT 1
                          FROM TRIBDEBITORECEITAISENCAO x
                                   LEFT OUTER JOIN tribisencao ti ON ti.isencao = x.isencao
                          WHERE tdri.entidade = x.entidade
                            AND tdri.EXERCICIO = x.exercicio
                            AND tdri.TIPOCADASTRO = x.tipocadastro
                            AND tdri.CADASTROGERAL = x.cadastrogeral
                            AND tdri.GUIARECOLHIMENTO = x.guiarecolhimento
                            AND tdri.SUBDIVIDA = x.subdivida
                            AND tdri.receita = x.receita
                            AND tdri.ISENCAO = x.ISENCAO
                            AND COALESCE(ti.CONTABILIZA, 'N') = ' N'
                            AND COALESCE(ti.CONTABILIZATAXA, ' N') = ' N'
                            AND COALESCE(ti.CONTABILIZACONTRIBUICAO, ' N') = ' N')
         UNION ALL
         /*Credito*/
         SELECT DISTINCT ttd.tipotce                     AS idTipoDeducaoCredito,
                         tcc.datacredito                 AS dtDeducao,
                         COALESCE(tcci.valordesconto, 0) AS valor,
                         tlc.nrCredito                   AS nrCredito,
                         tlc.nrAnoCredito                AS nrAnoCredito,
                         tmd.idato                       AS cdControleLeiAto,
                         substr(tmd.descricao, 0, 250)   AS dsMotivo,
                         tcc.entidade                    AS entidade,
                         tcc.exercicio                   AS exercicio,
                         cast(NULL AS integer)           AS idcancelamento,
                         cast(NULL AS integer)           AS idpagamentobloqueto,
                         cast(NULL AS integer)           AS iddebitoreceita,
                         tcci.iddebitoparcelareceita     AS idDebitoParcelaReceita,
                         tcci.idcreditocontribuinteitem  AS idcreditocontribuinteitem,
                         cast(NULL AS integer)           AS idParcelamento,
                         trt.classificacaoreceitatipo    AS idTipoCredito
         FROM tribbaixaautomaticadetalhe tbad
                  JOIN tribcreditocontribuinte tcc
                       ON tcc.entidade = tbad.entidade AND tcc.exercicio = tbad.exerciciocredito AND
                          tcc.creditocontribuinte = tbad.creditocontribuinte
                  JOIN tribCreditoContribuinteItem tcci
                       ON tcci.entidade = tcc.entidade AND tcci.exercicio = tcc.exercicio AND
                          tcci.creditocontribuinte = tcc.creditocontribuinte
                  JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                  JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade AND tdp.exercicio = tdpr.exercicio AND
                                                tdp.tipocadastro = tdpr.tipocadastro
             AND tdp.cadastrogeral = tdpr.cadastrogeral AND tdp.guiarecolhimento = tdpr.guiarecolhimento
             AND tdp.subdivida = tdpr.subdivida AND tdp.parcela = tdpr.parcela
                  JOIN tribbloqueto tb
                       ON tb.entidade = tbad.entidade AND tb.exerciciobloqueto = tbad.exerciciobloqueto AND
                          tb.bloqueto = tbad.bloqueto
                  LEFT JOIN tribGuiaRecolhimentoFormaPag tgrfp
                            ON tgrfp.entidade = tdpr.entidade AND tgrfp.exercicio = tdpr.exercicio AND
                               tgrfp.guiarecolhimento = tdpr.guiarecolhimento AND
                               tgrfp.formapagamento = tb.formapagamento
                  LEFT JOIN tribreceita tr ON tr.exercicio = :exercicio AND tr.receita = tdpr.receita AND
                                              tr.entidade = tdpr.entidade
                  JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                  JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  LEFT JOIN tribMotivoDesconto tmd
                            ON tmd.motivodesconto = COALESCE(tgrfp.motivodesconto, tb.motivodesconto)
                  LEFT JOIN tribTipoDeducao ttd ON ttd.tipodeducao = tmd.tipodeducao
                  LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                  LEFT JOIN tcelanccredito tlc ON tlc.idtcelanccredito = tdlc.idtcelanccredito
                  LEFT JOIN cgato ca ON ca.entidade = tcci.entidade AND ca.idato = tmd.idato
                  LEFT JOIN contabancaria cb ON cb.entidade = tcc.entidade AND cb.contabancaria = tcc.contabancaria
         WHERE tcc.entidade = :entidade
           AND tcc.datacredito BETWEEN :dataInicial AND :dataFinal
           AND tcci.valordesconto > 0
           AND tdp.situacaolegal = 0
           AND ttd.tipotce IN (1, 2, 3, 4, 5, 6)
           AND tcrt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
           AND COALESCE(cb.integraarrecadacao, 'S') = 'S'
           AND NOT EXISTS (SELECT 1
                           FROM tceDeducaoCreditoCredito tdcc
                           WHERE tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
                             AND tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita)
         UNION ALL
         /*Deducao de Parcelamento */
         SELECT DISTINCT
             ttd.tipotce                                                                      AS idTipoDeducaoCredito,
             tp.dataparcelamento                                                              AS dtDeducao,
             CASE WHEN valores.parcela = valores.max_parcela THEN
                              valores.valordescontoprincipal + valores.valordescontojuros +
                              valores.valordescontomulta + valores.valordescontocorrecao -
                              COALESCE((SELECT SUM(v.rateio_desconto_principal + v.rateio_desconto_juros +
                                                   v.rateio_desconto_multa + v.rateio_desconto_correcao)
                                        FROM vw_desconto_parcelamento v
                                        WHERE v.idparcelamento = tp.idparcelamento
                                          AND v.iddebito = valores.iddebito
                                          AND v.receitaorigem = valores.receitaorigem
                                          AND v.parcela <> valores.parcela), 0)
                  ELSE valores.rateio_desconto_principal + valores.rateio_desconto_juros +
                       valores.rateio_desconto_multa + valores.rateio_desconto_correcao
                 END                                                                              AS valor,
             tlc.nrcredito                                                                    AS nrCredito,
             tlc.nranocredito                                                                 AS nrAnoCredito,
             tmd.idato                                                                        AS cdControleLeiAto,
             substr(tmd.descricao, 0, 250)                                                    AS dsMotivo,
             td.entidade                                                                      AS entidade,
             td.exercicio                                                                     AS exercicio,
             CAST(NULL AS INTEGER)                                                            AS idCancelamento,
             CAST(NULL AS INTEGER)                                                            AS idPagamentoBloqueto,
             CAST(NULL AS INTEGER)                                                            AS idDebitoReceita,
             valores.iddebitoparcelareceita                                                   AS idDebitoParcelaReceita,
             CAST(NULL AS INTEGER)                                                            AS idcreditocontribuinteitem,
             tp.idparcelamento                                                                AS idParcelamento,
             trt.classificacaoreceitatipo                                                     AS idTipoCredito
         FROM tribparcelamento tp
                  LEFT JOIN vw_desconto_parcelamento valores ON tp.idparcelamento = valores.idparcelamento
                  LEFT JOIN tribdebito td ON valores.iddebito = td.iddebito
                  LEFT JOIN tcedebitolanccredito tdlc ON tdlc.iddebitoparcelareceita = valores.iddebitoparcelareceita
                  LEFT JOIN tcelanccredito tlc ON tdlc.idtcelanccredito = tlc.idtcelanccredito
                  LEFT JOIN tribreceita tr ON tr.entidade = :entidade AND tr.exercicio = :exercicio AND tr.receita = valores.receita
                  LEFT JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                  LEFT JOIN tribclassificacaoreceitatipo tcrt ON trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
                  JOIN tribParamParcelamento tpp ON tpp.idparametroparcelamento = tp.idparametroparcelamento
                  LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tpp.motivodesconto
                  LEFT JOIN tribtipodeducao ttd ON ttd.tipodeducao = tmd.tipodeducao
         WHERE tp.dataparcelamento BETWEEN :dataInicial AND :dataFinal
           AND tcrt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
           AND NOT EXISTS( SELECT 1 FROM tcededucaoparc tdp WHERE tdp.idparcelamento = tp.idparcelamento AND tdp.iddebitoparcelareceita = valores.iddebitoparcelareceita )
           AND valores.situacaolegal = 0
     ) filtro
ORDER BY filtro.nrcredito,
         filtro.nranocredito,
         filtro.idTipoDeducaoCredito,
         filtro.cdControleLeiAto,
         filtro.dtDeducao;