select 09                                                  as codigoArquivo,
       'Atualização Monetária de Créditos em Dívida Ativa' as arquivo,
       'CREDITO'                                           as tipoArquivo,
       arquivo.valor                                       as valorArquivo,
       integracao.valor                                    as valorIntegracao,
       0                                                   as valorRetencao
from (
         select sum(filtro.valor) as valor
         from(    select sum(coalesce(tam.vlatualizacao, 0)) as valor
                  from tceAtualizaMoneCredDA tam
                  where tam.dtatualizacao BETWEEN :dataInicial and :dataFinal
             )  as filtro
     ) as arquivo
         cross join (
    select sum(filtro.valor) as valor
    from (
             select sum(coalesce(liic.valortributo ,0)) as valor
             from loteintegracaocontabil lic
                      join loteitemintegracaocontabil liic on lic.id = liic.idlote
                      join tribreceita tr on liic.idtributo = tr.id
                      join tribreceitatipo trt on tr.tiporeceita = trt.tiporeceita
             where (lic.datalote between :dataInicial and :dataFinal)
               and lic.entidade = :entidade
               and liic.situacaolegal in (1,2)
               and liic.valortributo > 0
               and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
               and liic.classificacaotributo in ('J','M','C','F')
               and liic.tributoprincipal = 'N'
               and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
             union all
             select iip.valor as valor
             from integracaopatrimonial ip
                 left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                 left join tribreceita r
                 on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                 r.entidade = ip.entidade
                 JOIN tribreceitatipo trt
                 ON trt.tiporeceita = r.tiporeceita
             where ip.entidade = :entidade
               and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
               and ip.datamovimento between :dataInicial and :dataFinal
               and iip.tipomovimento in ('ACRESCIMOS_PARCELAMENTO')
               and iip.situacaolegal in (1, 2)
               and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
         ) as filtro
) as integracao