select filtro.idTipoAtualizacaoCredito,
       filtro.dtAtualizacao,
       filtro.nrdivida,
       filtro.nranodivida,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.idCreditoContribuinteItem,
       filtro.idparcelamento,
       filtro.idmovimentacaosequencia,
       filtro.idDacaoPagamentodebito,
       filtro.idReajuste,
       filtro.iddebitoreceita,
       filtro.vlAtualizacao,
       filtro.idtipocredito,
       tg.fundamentolegal as cdControleLeiAto
from (select 1                             as idTipoAtualizacaoCredito,
             tpd.valorjuros                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             0                             as idCreditoContribuinteItem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 2                             as idTipoAtualizacaoCredito,
             tpd.valormulta                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             0                             as idCreditoContribuinteItem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 3                             as idTipoAtualizacaoCredito,
             tpd.valorcorrecao             as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             0                             as idCreditoContribuinteItem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 1                             as idTipoAtualizacaoCredito,
             tcci.valorjuros               as vlAtualizacao,
             0                             as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorjuros > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 2                             as idTipoAtualizacaoCredito,
             tcci.valormulta               as vlAtualizacao,
             0                             as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valormulta > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 3                             as idTipoAtualizacaoCredito,
             tcci.valorcorrecao            as vlAtualizacao,
             0                             as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             0                             as idparcelamento,
             0                             as idmovimentacaosequencia,
             0                             as idDacaoPagamentodebito,
             0                             as iddebitoreceita,
             0                             as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorcorrecao > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 3                            as idTipoAtualizacaoCredito,
             dprr.VALORATUALIZACAO        as vlAtualizacao,
             0                            as idpagamentobloqueto,
             DPRR.iddebitoparcelareceita,
             0                            as iddebitoreceita,
             0                            as idCreditoContribuinteItem,
             0                            as idparcelamento,
             0                            as idmovimentacaosequencia,
             0                            as idDacaoPagamentodebito,
             dprr.idReajuste,
             r.data                       as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             trt.classificacaoreceitatipo as idTipoCredito,
             d.guiarecolhimento
      FROM TRIBREAJUSTE R
               JOIN TRIBDEBITOPARCELARECREAJUSTE DPRR
                    ON DPRR.IDREAJUSTE = R.ID
               JOIN TRIBDEBITOPARCELARECEITA DPR
                    ON DPRR.IDDEBITOPARCELARECEITA = DPR.IDDEBITOPARCELARECEITA
               JOIN TRIBDEBITOPARCELA DP
                    on dpr.ENTIDADE = dp.ENTIDADE
                        AND dpr.EXERCICIO = dp.EXERCICIO
                        AND dpr.TIPOCADASTRO = dp.TIPOCADASTRO
                        AND dpr.CADASTROGERAL = dp.CADASTROGERAL
                        AND dpr.GUIARECOLHIMENTO = dp.GUIARECOLHIMENTO
                        AND dpr.SUBDIVIDA = dp.SUBDIVIDA
                        and dpr.parcela = dp.parcela
               JOIN TRIBDEBITO D
                    on dpr.ENTIDADE = d.ENTIDADE
                        AND dpr.EXERCICIO = d.EXERCICIO
                        AND dpr.TIPOCADASTRO = d.TIPOCADASTRO
                        AND dpr.CADASTROGERAL = d.CADASTROGERAL
                        AND dpr.GUIARECOLHIMENTO = d.GUIARECOLHIMENTO
                        AND dpr.SUBDIVIDA = d.SUBDIVIDA
               LEFT JOIN tribguiarecolhimento tgr
                         ON tgr.entidade = :entidade
                             AND tgr.exercicio = :exercicio
                             AND tgr.guiarecolhimento = dpr.guiarecolhimento
               LEFT JOIN tribreceita tr
                         ON tr.entidade = :entidade
                             AND tr.exercicio = :exercicio
                             AND tr.receita = dpr.receita
               LEFT JOIN tribreceitatipo trt
                         ON trt.tiporeceita = tr.tiporeceita
               JOIN TRIBPARCELAMENTO p
                    ON p.IDPARCELAMENTO = COALESCE(d.IDPARCELAMENTO, d.IDREPARCELAMENTO)
               LEFT JOIN TRIBPARAMPARCELAMENTO PP
                         ON PP.IDPARAMETROPARCELAMENTO = P.IDPARAMETROPARCELAMENTO
               LEFT JOIN CGATO ATO
                         ON PP.FUNDAMENTOLEGAL = ATO.IDATO
                             AND PP.ENTIDADE = ATO.ENTIDADE
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = dprr.IDDEBITOPARCELARECEITA
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      WHERE R.ENTIDADE = :entidade
        AND R.DATA BETWEEN :dataInicial and :dataFinal
        AND dp.SITUACAOLEGAL IN (1, 2)
        AND trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
      union all
      select valores.tipoAtualizacao       as idTipoAtualizacaoCredito,
             valores.valor                 as vlAtualizacao,
             0                             as idpagamentobloqueto,
             valores.iddebitoparcelareceita,
             0                             as iddebitoreceita,
             0                             as idcreditocontribuinteitem,
             tp.idparcelamento,
             0                             as movimentacaosequencia,
             0                             as iddacaopagamentodebito,
             0                             as idreajuste,
             tp.dataparcelamento           as dtAtualizacao,
             tida.nrdivida,
             tida.nranodivida,
             tcrt.classificacaoreceitatipo as idtipocredito,
             valores.guiarecolhimento
      from tribparcelamento tp
               left join (select case
                                     when x.parcela = x.max_parcela then
                                                 x.valorjuros + x.valorjurosfinan -
                                                 coalesce((select sum(y.rateio_juros + y.rateio_juros_financiamento)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = x.idparcelamento
                                                             and y.iddebito = x.iddebito
                                                             and y.receitaorigem = x.receitaorigem
                                                             and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_juros end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 1                           as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal in (1, 2)
                          union
                          select case
                                     when x.parcela = x.max_parcela then
                                             x.valormulta - coalesce((select sum(y.rateio_multa)
                                                                      from vw_atualizacao_parcelamento y
                                                                      where y.idparcelamento = x.idparcelamento
                                                                        and y.iddebito = x.iddebito
                                                                        and y.receitaorigem = x.receitaorigem
                                                                        and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_multa end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 2                           as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal in (1, 2)
                          union
                          select case
                                     when x.parcela = x.max_parcela then
                                             x.valorcorrecao - coalesce((select sum(y.rateio_correcao)
                                                                         from vw_atualizacao_parcelamento y
                                                                         where y.idparcelamento = x.idparcelamento
                                                                           and y.iddebito = x.iddebito
                                                                           and y.receitaorigem = x.receitaorigem
                                                                           and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_correcao end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 3                              as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal in (1, 2)) as valores
                         on valores.idparcelamento = tp.idparcelamento
               left join tcedebitoinsccreditoda tdida on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
               left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
               left join tribreceita tr
                         on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
               left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               left join tribclassificacaoreceitatipo tcrt
                         on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
      where tp.dataparcelamento between :dataInicial and :dataFinal
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and valores.situacaolegal in (1, 2)
        and valores.valor <> 0
        and not exists (select 1 from tceatualizamoneparcda tampcd where valores.idparcelamento = tampcd.idparcelamento and
                                                                   tampcd.iddebitoparcelareceita = valores.iddebitoparcelareceita)) filtro
         left join tribguiarecolhimento tg on tg.entidade = :entidade
    and tg.exercicio = :exercicio
    and tg.guiarecolhimento = filtro.guiarecolhimento
order by filtro.dtAtualizacao,
         filtro.nrdivida,
         filtro.nranodivida,
         filtro.idpagamentobloqueto,
         filtro.iddebitoparcelareceita,
         filtro.idTipoAtualizacaoCredito,
         filtro.idtipocredito