select filtro.entidade,
       filtro.exercicio,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.idTipoOrigemReceita,
       filtro.idTipoArrecadacao,
       filtro.iddebitoparcelareceita,
       filtro.vlArrecadacao,
       filtro.nrCredito,
       filtro.nrAnoCredito,
       filtro.nrDivida,
       filtro.nrAnoDivida,
       filtro.IdRetencaoContabil,
       filtro.nrMes,
       filtro.nrAno,
       filtro.idTipoCredito
from
    (
        SELECT tp.entidade,
               tp.exerciciopagamento AS exercicio,
               tpb.idpagamentobloqueto,
               0 as idcreditocontribuinteitem,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               1 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpago AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null end as nranodivida,
               0 as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribpagamento tp
                 JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
                 JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
                 left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
                 left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
                 left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
                 join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
        WHERE tp.entidade = :entidade
          AND tp.datalancamento  BETWEEN :dataInicial AND :dataFinal
          and tpd.valorpago > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tcearrtipocreditopagamento atcp
                          where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                            and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
        union all
        SELECT tp.entidade,
               tp.exerciciopagamento AS exercicio,
               tpb.idpagamentobloqueto,
               0 as idcreditocontribuinteitem,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               4 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpagomaior	 AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null end as nranodivida,
               0 as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribpagamento tp
                 JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
                 JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
                 left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
                 left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
                 left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
                 join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
        WHERE tp.entidade = :entidade
          AND tp.datalancamento  BETWEEN :dataInicial AND :dataFinal
          and tpd.valorpagomaior > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tcearrtipocreditopagamento atcp
                          where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                            and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
        union all
        SELECT tcc.entidade,
               tcc.exercicio,
               0 as idpagamentobloqueto,
               tcci.idcreditocontribuinteitem,
               CASE WHEN tdp.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               4 AS idTipoArrecadacao,
               tcci.iddebitoparcelareceita,
               tcci.valorlancado AS valor,
               case when (tdp.situacaolegal = 0) then tlc.nrcredito else null end as nrCredito,
               case when (tdp.situacaolegal = 0) then tlc.nranocredito else null end as nranocredito,
               case when (tdp.situacaolegal in (1,2)) then tid.nrdivida else null end as nrdivida,
               case when (tdp.situacaolegal in (1,2)) then tid.nranodivida else null end as nranodivida,
               0 as IdRetencaoContabil,
               extract(month from tcc.data) as nrMes,
               extract(year  from tcc.data) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribcreditocontribuinte tcc
                 JOIN tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
                 left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
                 left outer join tribdebitoparcela tdp on tdp.entidade  = tdpr.entidade
            and tdp.exercicio = tdpr.exercicio
            and tdp.tipocadastro = tdpr.tipocadastro
            and tdp.cadastrogeral  = tdpr.cadastrogeral
            and tdp.guiarecolhimento  = tdpr.guiarecolhimento
            and tdp.subdivida  = tdpr.subdivida
            and tdp.parcela = tdpr.parcela
                 left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
                 left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
                 join contabancaria cb  on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
        WHERE tcc.entidade = :entidade
          AND tcc.data BETWEEN :dataInicial AND :dataFinal
          and tcci.valorlancado > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tceArrTipocreditoCredito atcc
                          where atcc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                            and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
        SELECT
            0 as entidade,
            0 as exercicio,
            0 as idpagamentobloqueto,
            0 as idcreditocontribuinteitem,
            1 as idTipoOrigemReceita,
            1 AS idTipoArrecadacao,
            0 as iddebitoparcelareceita,
            trc.valor AS valor,
            tlc.nrcredito as nrCredito,
            tlc.nranocredito as nranocredito,
            null as nrDivida,
            null as nranodivida,
            trc.IdRetencaoContabil,
            extract(month from trc.dtlancamento) as nrMes,
            extract(year  from trc.dtlancamento) as nrAno,
            trc.idtipocredito                    as idtipocredito
        from tceRetencaoContabil trc
                 join tceretencaolanccredito rlc on trc.idretencaocontabil = rlc.idretencaocontabil
                 join tcelanccredito tlc on rlc.idtcelanccredito = tlc.idtcelanccredito
        where (trc.dtlancamento BETWEEN :dataInicial AND :dataFinal)
          and not exists (
            select 1 from tcearrtipocreditoretencao tatcr
            where tatcr.idretencaocontabil = trc.idRetencaoContabil
        )
    ) as filtro
ORDER by filtro.idTipoOrigemReceita