select tp.entidade,
       tep.dataestorno           as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       tr.tiporeceita            as tipoTributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
         then tdp.situacaolegal
         else 0
       end                       situacaolegal,
       case
         when tr.classificacao = 'F'
         then ttotjurosfinan.codigotce
         else ttot.codigotce
       end                       tipooperacaodeducao,
       'ESTORNO_ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       sum(acrescimo.valor)      as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivoestorno = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
       left outer join tribmotivodesconto tmdjurosfinan
                    on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
       left outer join tribtipooperacaotce ttotjurosfinan
                    on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
       left outer join (select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.jurosdestino as tributo,
                               tpre.valorjuros   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorjuros > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.multadestino as tributo,
                               tpre.valormulta   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valormulta > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.correcaodestino as tributo,
                               tpre.valorcorrecao   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorcorrecao > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.jurosfinandestino as tributo,
                               tpre.valorjurosfinan as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorjurosfinan > 0) acrescimo
                    on acrescimo.idparcelamento = tp.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = acrescimo.iddebitonovo
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and acrescimo.tributo = tr.receita
where  td.constituido = 'S'
  and  tep.dataestorno in (:datasMovimento)
  and  tp.anocontrato = :exercicio
  and  (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem > tepd.iddebitodestino)
group  by tp.entidade,
          tep.dataestorno,
          tr.receita,
          tr.descricao,
          case
            when tr.classificacao = 'F'
            then 'J'
            else tr.classificacao
          end,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
            then tdp.situacaolegal
            else 0
          end,
          case
            when tr.classificacao = 'F'
            then ttotjurosfinan.codigotce
            else ttot.codigotce
          end,
          td.iddebito,
          tr.tiporeceita