select
	debito.iddebito,
	pessoa.pessoa,
	tributo.id as idtributo,
    tributo.classificacao as classificacaotributo,
	pagamentodebito.situacaolegal,
	motivodeducao.motivodesconto as idmotivodeducao,
    tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
	contabancaria.id as idcontacontabil,
	tributo.tiporeceita as tipoTributo,
    sum(coalesce(pagamentodebito.valorprincipal,0)) as valorprincipal,
    sum(coalesce(pagamentodebito.valorjuros,0)) as valorjuros,
    sum(coalesce(pagamentodebito.valormulta,0)) as valormulta,
    sum(coalesce(pagamentodebito.valorcorrecao,0)) as valorcorrecao,
    sum(coalesce(pagamentodebito.valordescontoprincipal,0)) as valordescontoprincipal,
    sum(coalesce(pagamentodebito.valordescontojuros,0)) as valordescontojuros,
    sum(coalesce(pagamentodebito.valordescontomulta,0)) as valordescontomulta,
    sum(coalesce(pagamentodebito.valordescontocorrecao,0)) as valordescontocorrecao,
    sum(coalesce(pagamentodebito.valordescontojurosfinan,0)) as valordescontojurosfinan
from tribestornopagamento estornopagamento
left join tribestornopagamentoitem estornopagamentoitem
										 on estornopagamento.entidade = estornopagamentoitem.entidade
										and estornopagamento.exercicio = estornopagamentoitem.exercicio
										and estornopagamento.estorno = estornopagamentoitem.estorno
left join contabancaria on estornopagamento.contabancariaestorno = contabancaria.contabancaria
left join tribpagamentodebito pagamentodebito on estornopagamentoitem.iddebitoparcelareceita = pagamentodebito.iddebitoparcelareceita
                                             and estornopagamentoitem.idpagamentobloqueto = pagamentodebito.idpagamentobloqueto
left join tribmotivodesconto motivodeducao on estornopagamento.motivodesconto = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join tribdebitoparcelareceita parcelatributo on pagamentodebito.iddebitoparcelareceita = parcelatributo.iddebitoparcelareceita
join tribdebitoparcela debitoparcela
                               on parcelatributo.entidade = debitoparcela.entidade
                              and parcelatributo.exercicio = debitoparcela.exercicio
                              and parcelatributo.tipocadastro = debitoparcela.tipocadastro
                              and parcelatributo.cadastrogeral = debitoparcela.cadastrogeral
                              and parcelatributo.guiarecolhimento = debitoparcela.guiarecolhimento
                              and parcelatributo.subdivida = debitoparcela.subdivida
                              and parcelatributo.parcela = debitoparcela.parcela
join tribdebito debito on debitoparcela.entidade = debito.entidade
                      and debitoparcela.exercicio = debito.exercicio
                      and debitoparcela.tipocadastro = debito.tipocadastro
                      and debitoparcela.cadastrogeral = debito.cadastrogeral
                      and debitoparcela.guiarecolhimento = debito.guiarecolhimento
                      and debitoparcela.subdivida = debito.subdivida
join tribcadastrogeral cadastrogeral
						 on debito.tipocadastro  = cadastrogeral.tipocadastro
						and debito.cadastrogeral = cadastrogeral.cadastrogeral
join pessoa on cadastrogeral.pessoa = pessoa.pessoa
join tribreceita tributo on parcelatributo.entidade = tributo.entidade
						and :exercicio = tributo.exercicio
						and parcelatributo.receita = tributo.receita
where contabancaria.integraarrecadacao = 'S'
and estornopagamento.data = :dataParam
and coalesce(pagamentodebito.valorprincipal,0)   > 0
group by debito.iddebito,
    pessoa.pessoa,
    tributo.id,
    tributo.classificacao,
    pagamentodebito.situacaolegal,
    motivodeducao.motivodesconto,
    tipooperacaotce.idtipooperacaotce,
    contabancaria.id,
    tributo.tiporeceita

union

/*Devolução com pagamento*/
select
	debito.iddebito,
	pessoa.pessoa,
	tributo.id as idtributo,
    tributo.classificacao as classificacaotributo,
	pagamentodebito.situacaolegal,
	motivodeducao.motivodesconto as idmotivodeducao,
    tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
	contabancaria.id as idcontacontabil,
	tributo.tiporeceita as tipoTributo,
    sum(coalesce(pagamentodebito.valorprincipal,0)) as valorprincipal,
    sum(coalesce(pagamentodebito.valorjuros,0)) as valorjuros,
    sum(coalesce(pagamentodebito.valormulta,0)) as valormulta,
    sum(coalesce(pagamentodebito.valorcorrecao,0)) as valorcorrecao,
    sum(coalesce(pagamentodebito.valordescontoprincipal,0)) as valordescontoprincipal,
    sum(coalesce(pagamentodebito.valordescontojuros,0)) as valordescontojuros,
    sum(coalesce(pagamentodebito.valordescontomulta,0)) as valordescontomulta,
    sum(coalesce(pagamentodebito.valordescontocorrecao,0)) as valordescontocorrecao,
    sum(coalesce(pagamentodebito.valordescontojurosfinan,0)) as valordescontojurosfinan
from tribdevolucaocredito devolucaoCredito
left join tribdevolucaocreditoitem devolucaocreditoitem
	on devolucaocredito.iddevolucaocredito = devolucaocreditoItem.iddevolucaocredito
left join contabancaria on devolucaoCredito.contabancaria = contabancaria.contabancaria
left join tribpagamento pagamento
	on pagamento.pagamento = devolucaocreditoitem.pagamento
	and pagamento.entidade = devolucaocreditoitem.entidade
	and pagamento.exerciciopagamento  = devolucaocreditoitem.exerciciopagamento
left join tribpagamentobloqueto  pagamentobloqueto
	on pagamentobloqueto.pagamento = pagamento.pagamento
	and pagamentobloqueto.entidade = pagamento.entidade
	and pagamentobloqueto.exerciciopagamento = pagamento.exerciciopagamento
left join tribpagamentodebito pagamentodebito
	on pagamentodebito.idpagamentobloqueto = pagamentobloqueto.idpagamentobloqueto
join tribbloqueto boleto on pagamentobloqueto.entidade = boleto.entidade
                        and pagamentobloqueto.exerciciobloqueto = boleto.exerciciobloqueto
                        and pagamentobloqueto.bloqueto = boleto.bloqueto
left join tribmotivodesconto motivodeducao on devolucaoCredito.motivodesconto = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join tribdebitoparcelareceita debitoparcelareceita on pagamentodebito.iddebitoparcelareceita = debitoparcelareceita.iddebitoparcelareceita
join tribdebitoparcela parcela on debitoparcelareceita.entidade = parcela.entidade
                              and debitoparcelareceita.exercicio = parcela.exercicio
                              and debitoparcelareceita.tipocadastro = parcela.tipocadastro
                              and debitoparcelareceita.cadastrogeral = parcela.cadastrogeral
                              and debitoparcelareceita.guiarecolhimento = parcela.guiarecolhimento
                              and debitoparcelareceita.subdivida = parcela.subdivida
                              and debitoparcelareceita.parcela = parcela.parcela
join tribdebito debito on parcela.entidade = debito.entidade
                      and parcela.exercicio = debito.exercicio
                      and parcela.tipocadastro = debito.tipocadastro
                      and parcela.cadastrogeral = debito.cadastrogeral
                      and parcela.guiarecolhimento = debito.guiarecolhimento
                      and parcela.subdivida = debito.subdivida
join tribcadastrogeral cadastrogeral
						 on debito.tipocadastro  = cadastrogeral.tipocadastro
						and debito.cadastrogeral = cadastrogeral.cadastrogeral
join pessoa on cadastrogeral.pessoa = pessoa.pessoa
join tribreceita tributo on debitoparcelareceita.entidade = tributo.entidade
                        and :exercicio = tributo.exercicio
                        and debitoparcelareceita.receita = tributo.receita
where contabancaria.integraarrecadacao = 'S'
	and devolucaoCredito.data = :dataParam
	and devolucaoCredito.situacao = 'D'
	and coalesce(pagamentodebito.valorprincipal,0)   > 0

group by debito.iddebito,
    pessoa.pessoa,
    tributo.id,
    tributo.classificacao,
    pagamentodebito.situacaolegal,
    motivodeducao.motivodesconto,
    tipooperacaotce.idtipooperacaotce,
    contabancaria.id,
    tributo.tiporeceita
