 select tributo.receita as tributo,
       item.classificacaoTributo,
       trim(tributo.descricao) as descricaoTributo,
       item.situacaoLegal,
       tipoOperacaoTce.codigoTce as tipoOperacaoDeducao,
       tributo.tiporeceita as tipoTributo,
       case when coalesce(item.tributoPrincipal, 'N') = 'S' then 'true' else 'false' end as inscrito,
       sum(item.valorTributo) as valorTributo,
       sum(item.valorDeducao) as valorDeducao
 from loteintegracaocontabil lote
 join loteitemintegracaocontabil item on lote.id = item.idLote
 join tribreceita tributo on item.idTributo = tributo.id
 left join contabancaria on lote.idContaBancaria = contabancaria.id
 left join tribmotivodesconto motivoDeducao on item.idMotivoDeducao = motivoDeducao.motivodesconto
 left join tribtipooperacaotce tipoOperacaoTce on motivoDeducao.idTipoOperacaoTce = tipoOperacaoTce.idtipooperacaotce
 where item.idLote = :idLote
 group by tributo.receita,
          item.classificacaoTributo,
          tributo.descricao,
          item.situacaoLegal,
          tipoOperacaoTce.codigoTce,
          contabancaria.localContabil,
          tributo.tiporeceita,
          item.tributoPrincipal