/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.soap.client;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.soap.webservice.caixa.manutencao.ObjectFactory;
import br.com.elotech.soap.webservice.caixa.manutencao.ServicoEntradaNegocialType;
import br.com.elotech.soap.webservice.caixa.manutencao.ServicoSaidaNegocialType;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.ws.soap.client.InclusaoBoletoSoapRequestHeaderModifier;
import java.util.Optional;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

public class ManutencaoBancariaCEFClient
extends WebServiceGatewaySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManutencaoBancariaCEFClient.class);
    @Autowired
    private InclusaoBoletoSoapRequestHeaderModifier inclusaoBoletoSoapRequestHeaderModifier;
    @Autowired
    private ParametroGeralService parametroGeralService;

    public ServicoSaidaNegocialType includeRegistryBoleto(ServicoEntradaNegocialType request) {
        LOGGER.info("Realizando a inclus\u00e3o de boleto registrado CEF. request {}", (Object)request);
        String urlApiBoletoCEF = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_CEF_URLAPI, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        ServicoSaidaNegocialType response = Optional.ofNullable((JAXBElement)this.getWebServiceTemplate().marshalSendAndReceive(urlApiBoletoCEF, (Object)new ObjectFactory().createSERVICOENTRADA(request), (WebServiceMessageCallback)this.inclusaoBoletoSoapRequestHeaderModifier)).map(JAXBElement::getValue).orElse(null);
        LOGGER.info("Realizado a inclus\u00e3o de boleto registrado CEF. response {}", (Object)response);
        return response;
    }
}

