/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoHandler;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.IdDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.params.ExtratoParams;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ws.oxy.OxyAiseDebitoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.DebitoExtratoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AiseDebitoServiceRest
implements AiseDebitoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;
    private final DebitoMapper debitoMapper;
    private final DebitoRepository debitoRepository;
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final Integer IN_STATEMENT_MAX_LENGTH = 999;
    private final TributosProperties tributosProperties;
    private final Environment environment;
    private final OxyAiseDebitoService oxyAiseDebitoService;

    public AiseDebitoServiceRest(RestTemplate restTemplate, TributosProperties tributosProperties, AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService, DebitoMapper debitoMapper, DebitoRepository debitoRepository, Environment environment, OxyAiseDebitoService oxyAiseDebitoService) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.debitoMapper = debitoMapper;
        this.debitoRepository = debitoRepository;
        this.environment = environment;
        this.oxyAiseDebitoService = oxyAiseDebitoService;
    }

    public List<DebitoDTO> getDebitos(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        return delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }

    private DebitoTransportDTO getDebitosEmAberto(CadastroGeralParams params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitos() + params.getTipoCadastro().getValue().toString() + "/" + params.getCadastroGeral().toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    private DebitoTransportDTO getDebitosEmAbertoPorId(Long idDebito) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitosPorId() + idDebito.toString(), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    private DebitoTransportDTO getDebitosEmAbertoPorIdParcelamento(Long idParcelamento) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetDebitosPorIdParcelamento(idParcelamento), HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    public List<DebitoDTO> getDebitosAgrupados(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        return DebitoHandler.agrupaContratoParcela(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
    }

    public List<DebitoDTO> getDebitosAgrupadosVencidos(CadastroGeralParams params) {
        return this.getDebitosAgrupados(params).stream().filter(DebitoDTO::getVencido).collect(Collectors.toList());
    }

    public List<DebitoMobileDTO> getDebitosMobile(CadastroGeralParams params) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAberto(params);
        List listDebitosAgrupados = DebitoHandler.agrupaDebitoMobile(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
        return listDebitosAgrupados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoParcelaMobileDTO> getParcelas(Long idDebito) {
        DebitoTransportDTO debitos = this.getDebitosEmAbertoPorId(idDebito);
        return debitos.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoParcelaMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public List<DebitoParcelaMobileDTO> getParcelasParcelamento(Long idParcelamento) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAbertoPorIdParcelamento(idParcelamento);
        List listDebitosAgrupados = DebitoHandler.agrupaContratoParcela(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
        return listDebitosAgrupados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoParcelaMobileDTO(arg_0)).collect(Collectors.toList());
    }

    public GerarDebitoResponseDTO geraDebito(GerarDebitoRequestDTO debito) {
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"!onpremise"}))) {
            return this.oxyAiseDebitoService.geraDebito(debito);
        }
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((Object)debito, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGeraDebito(), HttpMethod.POST, entity, GerarDebitoResponseDTO.class, new Object[0]);
        if (((GerarDebitoResponseDTO)response.getBody()).getIdDebito() == 0L) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito.");
        }
        return (GerarDebitoResponseDTO)response.getBody();
    }

    public List<IdDebitoDTO> verificarPagos(List<IdDebitoDTO> listIdDebito) {
        List partitions = Lists.partition(listIdDebito.stream().map(IdDebitoDTO::getIdDebito).filter(Objects::nonNull).collect(Collectors.toList()), (int)IN_STATEMENT_MAX_LENGTH);
        return partitions.stream().map(arg_0 -> ((DebitoRepository)this.debitoRepository).findPagos(arg_0)).flatMap(Collection::stream).map(IdDebitoDTO::new).collect(Collectors.toList());
    }

    public Boolean possuiDebitos(String cnpjCpf) {
        return Optional.ofNullable(cnpjCpf).map(arg_0 -> ((DebitoRepository)this.debitoRepository).possuiDebitosVencidos(arg_0)).orElse(Boolean.FALSE);
    }

    public List<DebitoExtratoDTO> getExtratoDebitos(ExtratoParams params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(AUTHORIZATION, BEARER + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlGetExtratoDebitos(), HttpMethod.POST, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (List)response.getBody();
    }

    public DebitosEmAbertoComTotalizadorDTO getDebitosAbertosAgrupados(CadastroGeralParams params) {
        List debitosEmAberto = this.getDebitos(params).stream().map(DebitoEmAbertoDTO::fromDebitoDto).collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getIdDebito, Collectors.reducing(DebitoEmAbertoDTO::add))).values().stream().map(Optional::get).sorted(Comparator.comparing(CalculaAcrescimoBaseDTO::getExercicio).thenComparing(CalculaAcrescimoBaseDTO::getDivida).thenComparing(CalculaAcrescimoBaseDTO::getSubDivida)).collect(Collectors.toList());
        return new DebitosEmAbertoComTotalizadorDTO(debitosEmAberto);
    }

    public List<DebitoDTO> getDebitosParcelamento(Long idParcelamento) {
        return this.debitoRepository.findDebitoComParcelaEmAberto(idParcelamento);
    }

    private String urlGetDebitos() {
        return this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tdebitos/emaberto/";
    }

    private String urlGetDebitosPorId() {
        return this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tdebitos/emabertoporid/";
    }

    private String urlGetDebitosPorIdParcelamento(Long idParcelamento) {
        return this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tdebitos/emabertoporidparcelamento/" + idParcelamento.toString();
    }

    private String urlGeraDebito() {
        return this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tdebitos/gerar";
    }

    private String urlGetExtratoDebitos() {
        return this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tdebitos/extrato";
    }
}

