/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.AtualizacaoMonetariaCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaCreditoMaService
implements ManutencaoArquivoSimAmService<AtualizacaoMonetariaCreditoMaDTO> {
    private final AtualizacaoMonetariaCreditoRepository arrecadacaoCreditoRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;
    private final AtoRepository atoRepository;
    private final EntityManager entityManager;
    private final ContextService contextService;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO;
    }

    public Page<AtualizacaoMonetariaCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtAtualizacao"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.arrecadacaoCreditoRepository.findAll(specification, pageable).map(AtualizacaoMonetariaCreditoMaDTO::from);
    }

    public List<AtualizacaoMonetariaCreditoMaDTO> updateAll(List<AtualizacaoMonetariaCreditoMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(AtualizacaoMonetariaCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.arrecadacaoCreditoRepository.saveAll((Iterable)arquivos.stream().map(AtualizacaoMonetariaCreditoMaDTO::toAtualizacaoMonetariaCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<AtualizacaoMonetariaCreditoMaDTO> arrecadacaoTipoCredito) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return arrecadacaoTipoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrCredito(current);
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrCredito(AtualizacaoMonetariaCreditoMaDTO arrecadacaoTipoCredito) {
        if (!this.lancamentoCreditoRepository.existsByNrCreditoAndNrAnoCredito(arrecadacaoTipoCredito.getNrCredito(), arrecadacaoTipoCredito.getNrAnoCredito()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de lan\u00e7amento de cr\u00e9dito com a chave nrCredito/nrAnoCredito com os valores %s/%s.", arrecadacaoTipoCredito.getNrCredito(), arrecadacaoTipoCredito.getNrAnoCredito()));
        }
    }

    private void validaCdControleLeiAto(AtualizacaoMonetariaCreditoMaDTO arrecadacaoTipoCredito, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, arrecadacaoTipoCredito.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela AtualizacaoMonetariaCredito n\u00e3o est\u00e1 presente na tabela CgAto.", arrecadacaoTipoCredito.getCdControleLeiAto(), arrecadacaoTipoCredito.getId()));
        }
    }

    @Generated
    public AtualizacaoMonetariaCreditoMaService(AtualizacaoMonetariaCreditoRepository arrecadacaoCreditoRepository, LancamentoCreditoRepository lancamentoCreditoRepository, AtoRepository atoRepository, EntityManager entityManager, ContextService contextService) {
        this.arrecadacaoCreditoRepository = arrecadacaoCreditoRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
        this.atoRepository = atoRepository;
        this.entityManager = entityManager;
        this.contextService = contextService;
    }
}

