/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoContabilPayload;
import br.com.elotech.tributos.dto.integracaocontabil.LoteIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.SolicitacaoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoPatrimonialService;
import br.com.elotech.tributos.service.integracaocontabil.LoteIntegracaoContabilService;
import br.com.elotech.tributos.service.integracaocontabil.LoteItemIntegracaoContabilService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegracaoContabilService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegracaoContabilService.class);
    private static final DateTimeFormatter formatterUserDate = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final String ID_ANO = "%d/%d";
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final LoteIntegracaoContabilService loteIntegracaoContabilService;
    private final LoteItemIntegracaoContabilService loteItemIntegracaoContabilService;
    private final PagamentoLoteService pagamentoLoteService;
    private final Publisher publisher;
    private final IntegracaoPatrimonialService integracaoPatrimonialService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoClient notificacaoClient;

    public IntegracaoContabilService(MovimentacaoDiariaService movimentacaoDiariaService, LoteIntegracaoContabilService loteIntegracaoContabilService, LoteItemIntegracaoContabilService loteItemIntegracaoContabilService, PagamentoLoteService pagamentoLoteService, Publisher publisher, IntegracaoPatrimonialService integracaoPatrimonialService, TarefaAssincronaService tarefaAssincronaService, NotificacaoClient notificacaoClient) {
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.loteIntegracaoContabilService = loteIntegracaoContabilService;
        this.loteItemIntegracaoContabilService = loteItemIntegracaoContabilService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.publisher = publisher;
        this.integracaoPatrimonialService = integracaoPatrimonialService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoClient = notificacaoClient;
    }

    public LoteIntegracaoContabilDTO loadInformacoesLote(Long id) {
        LoteIntegracaoContabil lote = (LoteIntegracaoContabil)this.loteIntegracaoContabilService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Lote %d n\u00e3o encontrado.", id)));
        List itens = this.loteItemIntegracaoContabilService.findItensIntegracao(id, lote.getTipoLote());
        LoteIntegracaoContabilDTO loteIntegracao = lote.toDTO();
        loteIntegracao.setItens(itens);
        return loteIntegracao;
    }

    @Transactional
    public LoteIntegracaoContabil integrarLote(SolicitacaoIntegracaoDTO solicitacaoIntegracaoDTO) {
        if (TipoMovimento.PAGAMENTO.equals((Object)solicitacaoIntegracaoDTO.getTipo())) {
            PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(solicitacaoIntegracaoDTO.getEntidade(), solicitacaoIntegracaoDTO.getExercicio(), solicitacaoIntegracaoDTO.getLote());
            if (SituacaoPagamentoLote.ABERTO.equals((Object)pagamentoLote.getSituacao())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel integrar lote em aberto %d/%d.", pagamentoLote.getId().getLote(), pagamentoLote.getId().getExercicio()));
            }
            LoteIntegracaoContabil loteIntegracaoContabil = this.loteIntegracaoContabilService.findLoteIntegracaoByPagamentoLoteId(pagamentoLote);
            if (Objects.nonNull(loteIntegracaoContabil) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)loteIntegracaoContabil.getSituacaoIntegracaoContabil())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel integrar lote %d/%d j\u00e1 enviado para a contabilidade.", loteIntegracaoContabil.getLote(), loteIntegracaoContabil.getExercicio()));
            }
            return this.solicitaIntegracaoLotePagamento(pagamentoLote);
        }
        throw new NotImplementedException(String.format("Integra\u00e7\u00e3o para o tipo de movimento %s n\u00e3o implementada.", solicitacaoIntegracaoDTO.getTipo().getDescricao()));
    }

    @Async
    @Transactional
    public void integrarDatasAssincrono(List<LocalDate> datasSelecionadas, String userAise, String userId) {
        this.integrarDatasEmTarefaAssincrona(datasSelecionadas, userAise, userId);
    }

    @Transactional
    public void integrarDatasEmTarefaAssincrona(List<LocalDate> datasSelecionadas, String userAise, String userId) {
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.criarTarefaAssincronaIntegracaoContabil(datasSelecionadas);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        this.sendNotificacao(String.format("Iniciada a integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), tarefa, userId);
        this.integrarDatas(datasSelecionadas, execucao, userAise, userId);
    }

    @Async
    @Transactional
    public void retryIntegrarDatasAssincrono(Long tarefa, String userAise, String userId) {
        this.retryIntegrarDatasEmTarefaAssincrona(tarefa, userAise, userId);
    }

    @Transactional
    public void retryIntegrarDatasEmTarefaAssincrona(Long tarefa, String userAise, String userId) {
        TarefaAssincrona tarefaAssincrona = this.tarefaAssincronaService.findOne(tarefa);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.criarNovaExecucao(tarefaAssincrona);
        List datas = tarefaAssincrona.getParametros().stream().filter(parametro -> "DATA_INTEGRACAO".equals(parametro.getChave()) && TipoParametro.DATA.equals((Object)parametro.getTipo())).map(parametro -> DateUtils.stringToLocalDate((String)parametro.getValor())).collect(Collectors.toList());
        this.sendNotificacao(String.format("Iniciada nova tentativa da integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), tarefa, userId);
        this.integrarDatas(datas, execucao, userAise, userId);
    }

    @Transactional
    public void integrarDatas(List<LocalDate> datasSelecionadas, TarefaAssincronaExecucao execucao, String userAise, String userId) {
        LOGGER.info("In\u00edcio da integra\u00e7\u00e3o cont\u00e1bil de dias");
        Long tarefa = execucao.getTarefaAssincrona().getId();
        List movimentacoesDiarias = new ArrayList();
        try {
            movimentacoesDiarias = this.movimentacaoDiariaService.verificaSituacaoParaIntegracaoContabil(datasSelecionadas, userAise);
            this.solicitaIntegracaoPatrimonial(datasSelecionadas);
            LOGGER.debug("Iniciando integra\u00e7\u00e3o financeira");
            datasSelecionadas.forEach(data -> {
                LOGGER.debug("Iniciando integra\u00e7\u00e3o financeira do dia {}", data);
                this.integrarPagamentos(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de pagamentos");
                this.solicitaIntegracaoEstornoPagamento(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de estornos de pagamentos");
                this.solicitaIntegracaoReabilitacaoPagamento(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de reabilita\u00e7\u00e3o de pagamentos");
                this.solicitaIntegracaoLoteEstornoCredito(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de estornos de creditos");
            });
            this.movimentacaoDiariaService.integrarData(movimentacoesDiarias);
        }
        catch (Exception exception) {
            LOGGER.error("Erro na integra\u00e7\u00e3o cont\u00e1bil de dias: {}", (Object)exception.getMessage());
            this.movimentacaoDiariaService.updateSituacaoMovimentacoesDiarias(movimentacoesDiarias, SituacaoMovimentacaoDiaria.TRIBUTACAO);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
            this.sendNotificacao(String.format("Ocorreu um erro na integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), tarefa, userId);
            return;
        }
        this.tarefaAssincronaService.finalizarExecucao(execucao);
        this.sendNotificacao(String.format("Finalizada a integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), tarefa, userId);
        LOGGER.info("T\u00e9rmino da integra\u00e7\u00e3o cont\u00e1bil de dias");
    }

    public void republish(Long idLote) {
        LoteIntegracaoContabil lote = (LoteIntegracaoContabil)this.loteIntegracaoContabilService.findById((Serializable)idLote).orElseThrow(() -> new EloValidationException(String.format("Lote %d n\u00e3o encontrado.", idLote)));
        if (!SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.equals((Object)lote.getSituacaoIntegracaoContabil())) {
            throw new EloValidationException(String.format("Apenas lotes com status %s podem ser reenviados.", SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.getDescricao()));
        }
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)lote.toPayload());
    }

    private void integrarPagamentos(LocalDate data) {
        LOGGER.info("Integrando pagamentos " + data);
        List lotes = this.pagamentoLoteService.findAllNotIntegradoByDataMovimentoAndSituacao(data);
        String lotesAbertos = lotes.stream().filter(lote -> SituacaoPagamentoLote.ABERTO.equals((Object)lote.getSituacao())).map(lote -> String.format(ID_ANO, lote.getId().getLote(), lote.getId().getExercicio())).collect(Collectors.joining(","));
        if (!lotesAbertos.isEmpty()) {
            throw new EloValidationException(String.format("Data %s possu\u00ed lote(s) em aberto %s.", data.format(formatterUserDate), lotesAbertos));
        }
        lotes.forEach(arg_0 -> this.solicitaIntegracaoLotePagamento(arg_0));
    }

    private LoteIntegracaoContabil solicitaIntegracaoLotePagamento(PagamentoLote pagamentoLote) {
        LoteIntegracaoContabil loteIntegracaoContabil = this.loteIntegracaoContabilService.geraLoteIntegracaoPagamento(pagamentoLote);
        IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
        integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
        integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
        LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        return loteIntegracaoContabil;
    }

    private void solicitaIntegracaoEstornoPagamento(LocalDate dataEstorno) {
        LOGGER.info("Integrando estorno de pagamentos " + dataEstorno);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoEstornoPagamento(dataEstorno);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Estorno Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoReabilitacaoPagamento(LocalDate dataReabilitacao) {
        LOGGER.info("Integrando reabilitacao de pagamento " + dataReabilitacao);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoReabilitacaoPagamento(dataReabilitacao);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Reabilita\u00e7\u00e3o Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoLoteEstornoCredito(LocalDate dataEstorno) {
        LOGGER.info("Integrando estorno de credito " + dataEstorno);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoEstornoCredito(dataEstorno);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Estorno Cr\u00e9dito) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoPatrimonial(List<LocalDate> datasMovimento) {
        LOGGER.info("Iniciando integracao patrimonial");
        List integracoesPatrimoniais = this.integracaoPatrimonialService.geraIntegracaoPatrimonial(datasMovimento);
        LOGGER.debug("Iniciando envio das mensagens da integra\u00e7\u00e3o patrimonial para a fila");
        integracoesPatrimoniais.forEach(integracaoPatrimonial -> this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoPatrimonial.toPayload()));
        LOGGER.debug("Finalizou envio das mensagens da integra\u00e7\u00e3o patrimonial para a fila");
    }

    private void sendNotificacao(String title, Long tarefa, String userId) {
        Notificacao notificacao = Notificacao.builder().title(title).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata("tipoTarefaAssincrona", (Object)TipoTarefaAssincrona.INTEGRACAO_CONTABIL_DIA).metadata("tarefa", (Object)tarefa).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(userId));
    }
}

