/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicredi;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoRefreshTokenService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class AutenticacaoSicrediService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutenticacaoSicrediService.class);
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final List<IntegracaoRefreshTokenService> integracaoRefreshTokenServices;
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private static final String URL_TOKEN = "/auth/openapi/token";

    public String getAccessToken(String url, String beneficiario, String cooperativa) {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_SICREDI, IntegracaoTokenOperation.BOLETO);
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        IntegracaoRefreshTokenService refreshTokenService = this.getRefreshTokenService();
        JsonNode response = this.generateNewAccessToken(url, beneficiario, cooperativa);
        return refreshTokenService.saveIntegracaoWithRefreshToken(Banco.CODIGO_SICREDI, IntegracaoTokenOperation.BOLETO, response);
    }

    public JsonNode generateNewAccessToken(String url, String beneficiario, String cooperativa) {
        IntegracaoRefreshTokenService refreshTokenService = this.getRefreshTokenService();
        Optional refresh_token = refreshTokenService.getRefreshToken(Banco.CODIGO_SICREDI, IntegracaoTokenOperation.BOLETO);
        String urlToken = url.concat(URL_TOKEN);
        String acessToken = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_SICREDI_TOKEN, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String codigoAcesso = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_CODIGO_ACESSO_SICREDI, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("x-api-key", acessToken);
        headers.add("context", "COBRANCA");
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"scope", (Object)"cobranca");
        if (refresh_token.isPresent()) {
            body.add((Object)"grant_type", (Object)"refresh_token");
            body.add((Object)"refresh_token", (Object)((String)refresh_token.get()));
        } else {
            body.add((Object)"grant_type", (Object)"password");
            body.add((Object)"username", (Object)beneficiario.concat(cooperativa));
            body.add((Object)"password", (Object)codigoAcesso);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)RestTemplateUtils.restTemplate.exchange(urlToken, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response;
        }
        catch (RestException e) {
            JsonNode jsonNode = this.converteErroResposta(e.getMessage());
            if (jsonNode.has("error_description")) {
                throw new RestException(e.getStatus(), jsonNode.get("error_description").asText(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    private JsonNode converteErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao ler o json do retorno com erro. " + json, (Throwable)e);
            throw new RuntimeException("Erro ao ler o json do retorno com erro. " + json);
        }
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept("DEFAULT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    private IntegracaoRefreshTokenService getRefreshTokenService() {
        return this.integracaoRefreshTokenServices.stream().filter(s -> s.accept("DEFAULT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    @Generated
    public AutenticacaoSicrediService(List<IntegracaoTokenService> integracaoTokenServices, List<IntegracaoRefreshTokenService> integracaoRefreshTokenServices, ParametroGeralService parametroGeralService, ObjectMapper mapper) {
        this.integracaoTokenServices = integracaoTokenServices;
        this.integracaoRefreshTokenServices = integracaoRefreshTokenServices;
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
    }
}

