/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPago;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPagoPaginacao;
import br.com.elotech.tributos.dto.pix.sicoob.SicoobPixPagoResponse;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.AutenticacaoSicoobService;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.PixPagoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class SicoobPixPagoService
implements PixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SicoobPixPagoService.class);
    private static final DateTimeFormatter FORMATO_DATA_HORA_API = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH'%3A'mm'%3A'ss'Z'");
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private final AutenticacaoSicoobService autenticacaoSicoobService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ContextService contextService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final BloquetoService boletoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final ParametroGeralService parametroGeralService;
    private final ParametroPixRepository parametroPixRepository;
    private final TipoMensagemService tipoMensagemService;
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ObjectMapper objectMapper;
    private final ConfigurableEnvironment environment;

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_SICOOB.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        Long entidade = this.contextService.getEntidadePrincipal();
        ImportacaoPixPagoResultadoDTO resultado = new ImportacaoPixPagoResultadoDTO();
        IntegracaoPixPagoLog integracaoPixPagoLog = this.buildLog(convenio, dataReferencia);
        try {
            SicoobPixPagoResponse response = this.getPixPagos(dataReferencia, entidade);
            SicoobPixPagoPaginacao paginacao = response.getParametros().getPaginacao();
            integracaoPixPagoLog.setQuantidadeRegistros(paginacao.getQuantidadeTotalDeItens());
            if (paginacao.getQuantidadeTotalDeItens().equals(0)) {
                resultado.setPossuiRegistros(Boolean.FALSE);
                ImportacaoPixPagoResultadoDTO importacaoPixPagoResultadoDTO = resultado;
                return importacaoPixPagoResultadoDTO;
            }
            ArrayList itensGerados = new ArrayList();
            itensGerados.addAll(this.processarPixPagos(response.getPix(), integracaoPixPagoLog));
            if (paginacao.getQuantidadeDePaginas() > 1) {
                Integer totalPaginas = paginacao.getQuantidadeDePaginas();
                Integer pagina = 1;
                while (pagina < totalPaginas) {
                    SicoobPixPagoResponse respostaPagina = this.getPixPagos(dataReferencia, pagina, entidade);
                    itensGerados.addAll(this.processarPixPagos(respostaPagina.getPix(), integracaoPixPagoLog));
                    Integer n = pagina;
                    Integer n2 = pagina = Integer.valueOf(pagina + 1);
                }
            }
            resultado.setPossuiRegistros(Boolean.valueOf(!itensGerados.isEmpty()));
            integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(itensGerados.size()));
            if (!itensGerados.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, resultado);
                resultado.setDadosLote(lote.getId());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(itensGerados, lote, sequencia);
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
        return resultado;
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private void saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagos(List<SicoobPixPago> pixPagos, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return pixPagos.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            detalhe.setE2eid(pix.getEndToEndId());
            if (Objects.nonNull(pix.getTxid())) {
                detalhe.setTxid(pix.getTxid());
                detalhe.setBuscaPorE2E(Boolean.FALSE);
            } else {
                try {
                    SicoobPixPago pagamentoByE2E = this.getPagamentoByE2E(pix.getEndToEndId());
                    detalhe.setTxid(pagamentoByE2E.getTxid());
                    detalhe.setBuscaPorE2E(Boolean.TRUE);
                }
                catch (Exception e) {
                    detalhe.setObservacao(e.getMessage());
                    SicoobPixPagoService.log.error("Ocorreu um erro ao fazer a busca por E2E Id: {}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }
            if (detalhe.getTxid().isEmpty()) {
                detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
                return null;
            }
            log.getDetalhes().add(detalhe);
            Optional boleto = this.boletoService.findByTxid(detalhe.getTxid());
            if (boleto.isEmpty()) {
                detalhe.setObservacao("Boleto n\u00e3o encontrado.");
                return null;
            }
            detalhe.setBoleto(((Bloqueto)boleto.get()).getBloqueto());
            detalhe.setExercicioboleto(((Bloqueto)boleto.get()).getExercicioBloqueto());
            detalhe.setEntidade(((Bloqueto)boleto.get()).getEntidade());
            if (this.baixaAutomaticaDetalheService.existsByBoleto((Bloqueto)boleto.get())) {
                detalhe.setObservacao("Boleto j\u00e1 importado.");
                return null;
            }
            detalhe.setObservacao("Boleto importado corretamente.");
            BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
            baixaAutomaticaDetalhe.setBoleto((Bloqueto)boleto.get());
            baixaAutomaticaDetalhe.setNossoNumero(((Bloqueto)boleto.get()).getNossoNumero());
            baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setDataVencimento(((Bloqueto)boleto.get()).getDataVencimento());
            baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
            baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
            baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
            baixaAutomaticaDetalhe.setValorPago(new BigDecimal(pix.getValor()));
            baixaAutomaticaDetalhe.setValorPagoPrincipal(new BigDecimal(pix.getValor()));
            baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
            baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
            baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
            return baixaAutomaticaDetalhe;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private IntegracaoPixPagoLog buildLog(Convenio convenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog log = new IntegracaoPixPagoLog();
        log.setConvenio(convenio.getId());
        log.setDataIntegracao(LocalDateTime.now());
        log.setDataReferencia(dataReferencia);
        log.setUsuario(SecurityUtils.getUserName());
        return log;
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia));
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        pagamentoLote.setNomeArquivo(String.format("importacao_pix_%d_%s", convenio.getConvenio(), FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual)));
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private SicoobPixPagoResponse getPixPagos(LocalDate data, Long entidade) {
        return this.getPixPagos(data, Integer.valueOf(0), entidade);
    }

    private SicoobPixPagoResponse getPixPagos(LocalDate data, Integer page, Long entidade) {
        ParametroPix parametroPix = this.getParametroPixByEntidade(entidade);
        byte[] certificado = this.getCertificadoByParametroPix(parametroPix);
        String senhaCertificado = this.getSenhaCertificadoByParametroPix(parametroPix);
        HttpHeaders headers = this.buildHeaders(this.getAccessTokenByCertificadoESenha(certificado, senhaCertificado), this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID));
        URI url = this.buildUrl(data, page);
        log.debug("Buscando os pix pagos na url {}, com headers {}.", (Object)url, (Object)headers);
        JsonNode body = (JsonNode)this.getRestTemplate(certificado, senhaCertificado).exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), JsonNode.class).getBody();
        try {
            log.debug("Retorno da requis\u00e7\u00e3o para buscar pix pagos : {} ", (Object)body);
            return (SicoobPixPagoResponse)this.objectMapper.treeToValue((TreeNode)body, SicoobPixPagoResponse.class);
        }
        catch (JsonProcessingException e) {
            log.debug("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", (Throwable)e);
            throw new RuntimeException("Erro ao traduzir o retorno do m\u00e9todo getPixPagos para String: ", e);
        }
    }

    private HttpHeaders buildHeaders(String token, String clientId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("authorization", String.format("Bearer %s", token));
        headers.add("client_id", clientId);
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private URI buildUrl(LocalDate data, Integer pagina) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_PAGO_URL);
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/pix").queryParam("paginacao.paginaAtual", new Object[]{pagina}).queryParam("paginacao.itensPorPagina", new Object[]{100}).queryParam("inicio", new Object[]{this.localDateTimeToString(data.atStartOfDay())}).queryParam("fim", new Object[]{this.localDateTimeToString(data.atTime(23, 59, 59))}).build(true).toUri();
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String parametroInformado = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(parametroInformado) || StringUtils.isEmpty((String)parametroInformado)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return parametroInformado;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private String localDateTimeToString(LocalDateTime data) {
        return FORMATO_DATA_HORA_API.format(data);
    }

    public List<BaixaAutomaticaDetalhe> processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog log) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_SICOOB.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        List sicoobPixPagos = SicoobPixPago.to((JsonNode)pixPagos, (ObjectMapper)this.objectMapper);
        LocalDate dataReferencia = this.getDataReferencia(sicoobPixPagos);
        log.setDataReferencia(dataReferencia);
        log.setQuantidadeRegistros(Integer.valueOf(sicoobPixPagos.size()));
        ArrayList<BaixaAutomaticaDetalhe> baixaAutomaticaDetalhes = new ArrayList<BaixaAutomaticaDetalhe>();
        try {
            baixaAutomaticaDetalhes.addAll(this.processarPixPagos(sicoobPixPagos, log));
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO());
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequencia);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
        return baixaAutomaticaDetalhes;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        ParametroPix parametroPix = this.getParametroPixByEntidade(convenio.getEntidade());
        byte[] certificado = this.getCertificadoByParametroPix(parametroPix);
        String senhaCertificado = this.getSenhaCertificadoByParametroPix(parametroPix);
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, certificado, senhaCertificado);
        } else {
            this.deactivatePixWebhook(convenio, certificado, senhaCertificado);
        }
    }

    public SicoobPixPago getPagamentoByE2E(String endToendIdentification) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_PAGO_URL);
        String url = String.format("%s/pix/%s", baseUrl, endToendIdentification);
        Long entidade = this.contextService.getEntidadePrincipal();
        ParametroPix parametroPix = this.getParametroPixByEntidade(entidade);
        byte[] certificado = this.getCertificadoByParametroPix(parametroPix);
        String senhaCertificado = this.getSenhaCertificadoByParametroPix(parametroPix);
        HttpHeaders headers = this.buildHeaders(this.getAccessTokenByCertificadoESenha(certificado, senhaCertificado), this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID));
        SicoobPixPago response = (SicoobPixPago)RestTemplateUtils.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), SicoobPixPago.class, new Object[0]).getBody();
        return response;
    }

    private LocalDate getDataReferencia(List<SicoobPixPago> sicoobPixPagos) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return LocalDate.parse(sicoobPixPagos.stream().findFirst().map(SicoobPixPago::getHorario).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado data do pix")), formatter);
    }

    private ParametroPix getParametroPixByEntidade(Long entidade) {
        return this.parametroPixRepository.getByEntidade(entidade);
    }

    private byte[] getCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoSicoob).orElse(null);
    }

    private String getSenhaCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoSicoob).orElse(null);
    }

    private RestTemplate getRestTemplate(byte[] certificado, String senhaCertificado) {
        try {
            return RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private String getAccessTokenByCertificadoESenha(byte[] certificado, String senhaCertificado) {
        return this.autenticacaoSicoobService.getAccessToken(certificado, senhaCertificado);
    }

    private URI buildWebhookURI(Convenio convenio) {
        String baseUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_API_PIX_WEBHOOK);
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/" + convenio.getChavePix()).build().toUri();
    }

    private void activatePixWebhook(Convenio convenio, byte[] certificado, String senhaCertificado) {
        HttpHeaders headers = this.buildHeaders(this.getAccessTokenByCertificadoESenha(certificado, senhaCertificado), this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID));
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("webhookUrl", String.format("%s/api/integracao-boleto/%d/webhook/pix", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId()));
        this.getRestTemplate(certificado, senhaCertificado).exchange(this.buildWebhookURI(convenio), HttpMethod.PUT, new HttpEntity(body, (MultiValueMap)headers), SicoobPixPagoResponse.class);
    }

    private void deactivatePixWebhook(Convenio convenio, byte[] certificado, String senhaCertificado) {
        HttpHeaders headers = this.buildHeaders(this.getAccessTokenByCertificadoESenha(certificado, senhaCertificado), this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID));
        try {
            this.getRestTemplate(certificado, senhaCertificado).exchange(this.buildWebhookURI(convenio), HttpMethod.DELETE, new HttpEntity(null, (MultiValueMap)headers), SicoobPixPagoResponse.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    public SicoobPixPagoService(AutenticacaoSicoobService autenticacaoSicoobService, PagamentoLoteService pagamentoLoteService, ContextService contextService, ValidaDataMovimentacaoService validaDataMovimentacaoService, BloquetoService boletoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, ParametroGeralService parametroGeralService, ParametroPixRepository parametroPixRepository, TipoMensagemService tipoMensagemService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, PlatformTransactionManager transactionManager, ObjectMapper objectMapper, ConfigurableEnvironment environment) {
        this.autenticacaoSicoobService = autenticacaoSicoobService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.contextService = contextService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.boletoService = boletoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.parametroGeralService = parametroGeralService;
        this.parametroPixRepository = parametroPixRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.transactionManager = transactionManager;
        this.objectMapper = objectMapper;
        this.environment = environment;
    }
}

