/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.repository.ParcelamentoCarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.utils.TenantUtils;
import com.google.common.base.Stopwatch;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ParcelamentoCarneService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParcelamentoCarneService.class);
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoClient notificacaoClient;
    private final CarneService carneService;
    private final ParcelamentoCarneRepository parcelamentoCarneRepository;

    @Async
    public void gerarBoletoCarneAsync(ImpressaoBoletoParcelamentoDTO request, List<ParcelamentoDebitoParcelasDTO> parcelas, String chave, TarefaAssincronaExecucao execucao, Long parcelaInicial, Long parcelaFinal) {
        Long tarefa = execucao.getTarefaAssincrona().getId();
        this.sendNotificacao(String.format("Iniciada a gera\u00e7\u00e3o do carn\u00ea do parcelamento da tarefa %s", tarefa), tarefa, SecurityUtils.getUserId().toString());
        String userId = SecurityUtils.getUserId().toString();
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.carneService.gerarBoletoCarne(request, parcelas, chave, parcelaInicial, parcelaFinal);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.sendNotificacao(String.format("Finalizada com sucesso a gera\u00e7\u00e3o do carn\u00ea para o parcelamento da tarefa %s", tarefa), tarefa, userId);
            stopwatch.stop();
            log.info(String.format("Fim da geracao de boleto: %s", stopwatch));
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            log.error("Erro ao gerar o carn\u00ea para o parcelamento", (Throwable)e);
            this.sendNotificacao(String.format("Ocorreu um erro na gera\u00e7\u00e3o do carn\u00ea para o parcelamento tarefa %s", tarefa), tarefa, userId);
        }
    }

    private void sendNotificacao(String title, Long tarefa, String userId) {
        Notificacao notificacao = Notificacao.builder().title(title).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata("tipoTarefaAssincrona", (Object)TipoTarefaAssincrona.PARCELAMENTO_GERACAO_CARNE).metadata("tarefa", (Object)tarefa).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(userId));
    }

    public List<ParcelamentoCarne> getByChaveAndParcela(String chave, Long parcelaInicial, Long parcelaFinal) {
        return this.parcelamentoCarneRepository.getByChaveAndParcela(chave, parcelaInicial, parcelaFinal);
    }

    @Generated
    public ParcelamentoCarneService(TarefaAssincronaService tarefaAssincronaService, NotificacaoClient notificacaoClient, CarneService carneService, ParcelamentoCarneRepository parcelamentoCarneRepository) {
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoClient = notificacaoClient;
        this.carneService = carneService;
        this.parcelamentoCarneRepository = parcelamentoCarneRepository;
    }
}

