/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItemId;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.PagamentoBoletoRepository;
import br.com.elotech.tributos.repository.PagamentoRepository;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class DevolucaoCreditoItemService
extends CrudService<DevolucaoCreditoItem, DevolucaoCreditoItemId> {
    private static final int MAX_DIGITOS_NOSSO_NUMERO = 17;
    private final PagamentoRepository pagamentoRepository;
    private final BoletoRepository boletoRepository;
    private final PagamentoBoletoRepository pagamentoBoletoRepository;

    public DevolucaoCreditoItemService(PagamentoRepository pagamentoRepository, BoletoRepository boletoRepository, PagamentoBoletoRepository pagamentoBoletoRepository) {
        this.pagamentoRepository = pagamentoRepository;
        this.boletoRepository = boletoRepository;
        this.pagamentoBoletoRepository = pagamentoBoletoRepository;
    }

    public Optional<Bloqueto> findByNossoNumero(String nossoNumero) {
        return this.boletoRepository.findByNossoNumero(nossoNumero);
    }

    public Optional<Bloqueto> findByCodigoBarrasOuLinhaDigitavel(String codigoBarras) {
        return this.boletoRepository.findByCodigoBarrasOuLinhaDigitavel(codigoBarras);
    }

    public Pagamento findPagamentoByCamposBoleto(String termo, Long entidade, Long cadastroGeral, Long tipoCadastro) {
        Optional<Pagamento> pagamentoBoleto;
        Optional<Object> pagamento;
        FiltroPagamentoDTO filtro = new FiltroPagamentoDTO();
        String termoSemEspacos = termo.trim();
        boolean padraoPagamentoAno = Pattern.compile("\\d+\\/\\d+").matcher(termoSemEspacos).matches();
        boolean padraoNumerico = Pattern.compile("\\d+").matcher(termoSemEspacos).matches();
        if (!padraoPagamentoAno && !padraoNumerico) {
            throw new EloValidationException("Termo inv\u00e1lido para pesquisa.");
        }
        if (padraoPagamentoAno) {
            String[] pagamentoAno = termoSemEspacos.split("/");
            filtro.setPagamento(pagamentoAno[0]);
            filtro.setExercicioPagamento(pagamentoAno[1]);
            pagamento = this.pagamentoRepository.findPagamentos(entidade, filtro).stream().findFirst();
        } else if (termoSemEspacos.length() <= 17) {
            pagamentoBoleto = this.findByNossoNumero(termoSemEspacos).flatMap(arg_0 -> ((PagamentoBoletoRepository)this.pagamentoBoletoRepository).findByBoleto(arg_0));
            pagamento = pagamentoBoleto.map(PagamentoBoleto::getPagamento);
        } else {
            pagamentoBoleto = this.findByCodigoBarrasOuLinhaDigitavel(termoSemEspacos).flatMap(arg_0 -> ((PagamentoBoletoRepository)this.pagamentoBoletoRepository).findByBoleto(arg_0));
            pagamento = pagamentoBoleto.map(PagamentoBoleto::getPagamento);
        }
        Pagamento pagamentoEncontrado = pagamento.orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado Pagamento informado."));
        if (!this.validatePagamentoAssociadoCadastroGeral(pagamentoEncontrado, cadastroGeral, tipoCadastro).booleanValue()) {
            throw new EloValidationException("Pagamento n\u00e3o associado ao Cadastro");
        }
        if (pagamentoEncontrado.validatePagamentoEstornado().booleanValue()) {
            throw new EloValidationException("Pagamento j\u00e1 est\u00e1 estornado");
        }
        return pagamentoEncontrado;
    }

    public Boolean validatePagamentoAssociadoCadastroGeral(Pagamento pagamento, Long cadastroGeral, Long tipoCadastro) {
        return pagamento.getPagamentoBoleto().getPagamentosDebito().stream().allMatch(pagamentoDebito -> pagamentoDebito.getId().getDebitoParcelaTributo().getCadastroGeral().equals(cadastroGeral) && pagamentoDebito.getId().getDebitoParcelaTributo().getTipoCadastro().equals(tipoCadastro));
    }
}

