/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.VinculoCadastroFormaPagamentoService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.enums.SituacaoCarne;
import br.com.elotech.tributos.repository.CarneRepository;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.ParcelamentoCarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarneService
extends ReadOnlyService<Carne, CarneId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CarneService.class);
    private final CarneRepository carneRepository;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final GeraBoletoService geraBoletoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final VinculoCadastroFormaPagamentoService vinculoCadastroFormaPagamentoService;
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final ParcelamentoCarneRepository parcelamentoCarneRepository;

    @Transactional
    public ParcelamentoCarne gerarBoletoCarne(ImpressaoBoletoParcelamentoDTO request, List<ParcelamentoDebitoParcelasDTO> parcelas, String chave, Long parcelaInicial, Long parcelaFinal) {
        FormaPagamento formaPagamento = (FormaPagamento)this.formaPagamentoService.findById((Serializable)request.getFormaPagamento()).orElseThrow(() -> new EloValidationException(String.format("Forma de pagamento %d n\u00e3o encontrado", request.getFormaPagamento())));
        List parcelamentos = request.getParcelamentos().stream().map(ParcelamentoPassivelQuitacaoDTO::getIdParcelamento).collect(Collectors.toList());
        Carne carne = this.geraCarneAgrupado(parcelas, formaPagamento, request.getTipoCadastro(), request.getCadastroGeral(), request.getEntidade(), this.contextService.getExercicioAtual(), parcelamentos);
        ParcelamentoCarne parcelamentoCarne = new ParcelamentoCarne(chave, carne, parcelaInicial, parcelaFinal);
        return (ParcelamentoCarne)this.parcelamentoCarneRepository.save((Object)parcelamentoCarne);
    }

    @Transactional
    public Carne geraCarneAgrupado(List<ParcelamentoDebitoParcelasDTO> parcelas, FormaPagamento formaPagamento, Long tipoCadastro, Long cadastroGeral, Long entidade, Long exercicio, List<Long> parcelamentos) {
        Preconditions.checkArgument((!parcelas.isEmpty() ? 1 : 0) != 0, (Object)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea");
        CarneId id = new CarneId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        Carne carneSavedSemNumero = new Carne();
        carneSavedSemNumero.setId(id);
        carneSavedSemNumero.setTipoCadastro(tipoCadastro);
        carneSavedSemNumero.setCadastroGeral(cadastroGeral);
        carneSavedSemNumero = this.save(carneSavedSemNumero);
        carneSavedSemNumero = this.save(carneSavedSemNumero);
        TipoFormaPagamento tipoFormaPagamento = formaPagamento.getTipoFormaPagamento();
        if (!TipoFormaPagamento.PARCELADO.equals((Object)tipoFormaPagamento)) {
            throw new EloValidationException("O tipo da forma de pagamento deve ser PARCELADO");
        }
        ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        List numerosParcelas = parcelas.stream().map(ParcelamentoDebitoParcelasDTO::getParcela).collect(Collectors.toList());
        List debitoparcelas = this.debitoParcelaRepository.findByCadastroParcelaAndAberto(entidade, tipoCadastro, cadastroGeral, numerosParcelas, parcelamentos);
        Map<Long, List<DebitoParcela>> debitoParcelasPorParcela = debitoparcelas.stream().collect(Collectors.groupingBy(p -> p.getId().getParcela()));
        for (Long numeroParcela : debitoParcelasPorParcela.keySet()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            List debitoParcelasDto = debitoParcelasPorParcela.get(numeroParcela).stream().filter(dp -> this.isFormaPagamentoParceladoAndNaoVencido(tipoFormaPagamento.getValue(), dp)).map(dp -> DebitoParcelaDTO.convertBoleto((DebitoParcela)dp, (Long)dp.getDebito().getId())).collect(Collectors.toList());
            String elapsedTimeCarregarParcelas = stopwatch.toString();
            this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitoParcelasDto, formaPagamento.getId(), TipoBloqueto.AGRUPADO.getValue(), Boolean.TRUE, parametrosAcrescimos, (arg_0, arg_1, arg_2, arg_3) -> ((GeraBoletoService)this.geraBoletoService).geraBoleto(arg_0, arg_1, arg_2, arg_3));
            stopwatch.stop();
            log.debug(String.format("Tempo gasto para gerar boletos do carne %d/%d:\ncarregarParcelas: %s\ngerarBoletoEAdicionarNoCarne: %s", carneSavedSemNumero.getId().getCarne(), numeroParcela, elapsedTimeCarregarParcelas, stopwatch));
        }
        return carneSavedSemNumero;
    }

    @Transactional
    public CarneDTO geraCarne(DebitoCarneDTO debitoCarne) {
        List parcelas = this.debitoParcelaRepository.findByDebitoAndAberto(debitoCarne.getEntidade(), debitoCarne.getExercicio(), debitoCarne.getTipoCadastro(), debitoCarne.getCadastroGeral(), debitoCarne.getDivida(), debitoCarne.getSubDivida());
        Preconditions.checkArgument((!parcelas.isEmpty() ? 1 : 0) != 0, (Object)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea");
        Carne carneSavedSemNumero = this.save(debitoCarne.toEntity());
        ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        debitoCarne.getFormasPagamento().forEach(formaPagamento -> {
            ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
            for (DebitoParcela debitoParcela : parcelas) {
                if (formaPagamento.getTipoFormaPagamento().equals(TipoFormaPagamento.PARCELADO.getValue()) && !this.isFormaPagamentoParceladoAndNaoVencido(formaPagamento.getTipoFormaPagamento(), debitoParcela)) continue;
                DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debitoCarne.getIdDebito());
                debitosBoletoFormaPagamento.add(debitoParcelaDTO);
            }
            this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getFormaPagamento(), formaPagamento.getTipoFormaPagamento(), Boolean.TRUE, parametrosAcrescimos, (arg_0, arg_1, arg_2, arg_3) -> ((GeraBoletoService)this.geraBoletoService).geraBoleto(arg_0, arg_1, arg_2, arg_3));
        });
        this.getEm().flush();
        return CarneDTO.fromWithBoletos((Carne)this.save(carneSavedSemNumero));
    }

    private boolean isFormaPagamentoParceladoAndNaoVencido(String tipoFormaPagamento, DebitoParcela debitoParcela) {
        return TipoFormaPagamento.PARCELADO.getValue().equals(tipoFormaPagamento) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
    }

    private boolean isFormaPagamentoParceladoAndNaoVencido(String tipoFormaPagamento, ParcelamentoDebitoParcelasDTO debitoParcela) {
        return TipoFormaPagamento.PARCELADO.getValue().equals(tipoFormaPagamento) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
    }

    private void geraBoletoEAdicionaNoCarne(Carne carne, List<DebitoParcelaDTO> debitosBoleto, Long formaPagamento, String tipoFormaPagamento, Boolean somenteDebitosConstituidos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, GeraBoletoCarneFunction creator) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)tipoFormaPagamento));
        geraBoletoDTO.setDebitos(debitosBoleto);
        geraBoletoDTO.setExercicio(carne.getId().getExercicio());
        geraBoletoDTO.setImpressaoCarne(Boolean.TRUE);
        creator.apply(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos, parametrosAcrescimos).forEach(arg_0 -> ((Carne)carne).addBoleto(arg_0));
    }

    public Carne save(Carne carne) {
        if (Objects.isNull(carne.getData())) {
            carne.setData(LocalDate.now());
        }
        if (Objects.isNull(carne.getUsuario())) {
            carne.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(carne.getNumero()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setNumero(carne.getId().getCarne());
        }
        if (Objects.isNull(carne.getCodigoBarras()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setCodigoBarras(String.format("%02d%04d%08d", carne.getId().getEntidade(), carne.getId().getExercicio(), carne.getId().getCarne()));
        }
        return (Carne)this.carneRepository.save((Object)carne);
    }

    @Transactional
    public CarneDTO geraCarnePorFormaPagamento(DebitoAgrupadoPorFormaPagamentoDTO params) {
        DebitoCarneDTO debitoCarneDTO = new DebitoCarneDTO();
        debitoCarneDTO.setIdDebito(params.getIdDebito());
        debitoCarneDTO.setEntidade(params.getEntidade());
        debitoCarneDTO.setExercicio(params.getExercicio());
        debitoCarneDTO.setTipoCadastro(params.getTipoCadastro());
        debitoCarneDTO.setCadastroGeral(params.getCadastroGeral());
        debitoCarneDTO.setDivida(params.getDivida());
        debitoCarneDTO.setSubDivida(params.getSubDivida());
        debitoCarneDTO.setFormasPagamento(Collections.singletonList(params));
        return this.geraCarne(debitoCarneDTO);
    }

    @Transactional
    public CarneDTO geraCarneCalculo(CalculoCadastro calculoCadastro, Long calculoLoteImpressaoOrdem, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        try {
            Debito debito = calculoCadastro.getDebito();
            Carne carneSavedSemNumero = this.save(this.createCarne(debito, calculoCadastro.getCalculo().getExercicio()));
            calculoCadastro.getCalculo().getFormasPagamento().stream().filter(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getDivida().equals((Object)debito.getDivida())).sorted(Comparator.comparing(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getFormaPagamento().getOrdemEmissao(), Comparator.nullsLast(Comparator.naturalOrder()))).forEach(calculoFormaPagamento -> {
                FormaPagamento formaPagamento = calculoFormaPagamento.getDividaFormaPagamento().getFormaPagamento();
                ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
                if (!this.formaDePagamentoPermitido(calculoCadastro.getCadastro(), calculoCadastro.getDivida(), formaPagamento)) {
                    return;
                }
                for (DebitoParcela debitoParcela : debito.getParcelas()) {
                    if (!debitoParcela.getSituacaoDebito().isAberto().booleanValue()) {
                        log.debug("Tentando gerar boleto para parcela n\u00e3o aberta. Parcela {}", (Object)debitoParcela.getId());
                        continue;
                    }
                    if (formaPagamento.getTipoFormaPagamento().equals((Object)TipoFormaPagamento.PARCELADO) && !this.validaFormaPagamentoAndParcela(formaPagamento, debitoParcela, calculoFormaPagamento.getQuantidadeParcelas())) continue;
                    DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debito.getId());
                    debitosBoletoFormaPagamento.add(debitoParcelaDTO);
                }
                if (!debitosBoletoFormaPagamento.isEmpty()) {
                    this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getId(), formaPagamento.getTipoFormaPagamento().getValue(), Boolean.FALSE, parametrosAcrescimos, (arg_0, arg_1, arg_2, arg_3) -> ((GeraBoletoService)this.geraBoletoService).geraBoletoCarneCalculo(arg_0, arg_1, arg_2, arg_3));
                }
            });
            if (carneSavedSemNumero.getBoletos().isEmpty()) {
                throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o carn\u00ea do lote: %d, cadastro: %d - %d. Verifique a situa\u00e7\u00e3o das parcelas do d\u00e9bito e as formas de pagamento configuradas.", calculoLoteImpressaoOrdem, calculoCadastro.getCadastro().getTipoCadastro().getValue(), calculoCadastro.getCadastro().getCadastroGeral()));
            }
            CarneDTO dto = CarneDTO.from((Carne)this.save(carneSavedSemNumero));
            calculoCadastro.setSituacaoCarne(SituacaoCarne.GERADO);
            calculoCadastro.setErroEmissaoBoleto(null);
            return dto;
        }
        catch (Exception ex) {
            calculoCadastro.setSituacaoCarne(SituacaoCarne.ERRO);
            calculoCadastro.setErroEmissaoBoleto(ex.getMessage());
            log.error("Erro ao gerar o carn\u00ea: ", (Throwable)ex);
            return null;
        }
    }

    private boolean validaFormaPagamentoAndParcela(FormaPagamento formaPagamento, DebitoParcela debitoParcela, Long quantidadeParcelas) {
        log.debug("Validando parcela para emitir boleto. Parcela: {}, dataVencimento, {} formaPagamento: {}, quantidadeParcelas: {}", new Object[]{debitoParcela.getIdDebitoParcela(), debitoParcela.getDataVencimento(), formaPagamento.getId(), quantidadeParcelas});
        boolean formaPagamentoParcelada = TipoFormaPagamento.PARCELADO.equals((Object)formaPagamento.getTipoFormaPagamento());
        boolean parcelaNaoVencida = LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
        boolean parcelaMenorQueQuantidadeParcelas = Objects.isNull(quantidadeParcelas) || debitoParcela.getId().getParcela() <= quantidadeParcelas;
        log.debug("Resultado da valida\u00e7\u00e3o: Forma de Pagamento parcelada: {}, Parcela n\u00e3o vencida: {}, parcela Menor que a quantidade:{} ", new Object[]{formaPagamentoParcelada, parcelaNaoVencida, parcelaMenorQueQuantidadeParcelas});
        return formaPagamentoParcelada && parcelaNaoVencida && parcelaMenorQueQuantidadeParcelas;
    }

    private Carne createCarne(Debito debito, Long exercicioCarne) {
        CarneId id = new CarneId();
        id.setEntidade(debito.getEntidade());
        id.setExercicio(exercicioCarne);
        Carne carne = new Carne();
        carne.setId(id);
        carne.setTipoCadastro(debito.getTipoCadastro());
        carne.setCadastroGeral(debito.getCadastroGeralId());
        return carne;
    }

    public void deleteCarne(Long entidade, Long exercicio, Long numeroCarne) {
        CarneId carneId = new CarneId(entidade, exercicio, numeroCarne);
        Carne carne = (Carne)this.carneRepository.findById((Object)carneId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado carne %d no exercicio %d para entidade %d.", numeroCarne, exercicio, entidade)));
        this.carneRepository.delete((Object)carne);
    }

    public Optional<CarneDTO> findByDebito(Long idDebito, Long formaPagamento) {
        return this.carneRepository.findByDebitoAndFormaPagamento(idDebito, formaPagamento).map(CarneDTO::from);
    }

    private boolean formaDePagamentoPermitido(CadastroGeral cadastroGeral, Divida divida, FormaPagamento formaPagamento) {
        if (divida.getVerificaFormaPagamentoDiferenciada().equals(Boolean.FALSE)) {
            return true;
        }
        return this.vinculoCadastroFormaPagamentoService.existeVinculoComCadastroGeral(cadastroGeral.getId(), divida, formaPagamento);
    }

    @Generated
    public CarneService(CarneRepository carneRepository, DebitoParcelaRepository debitoParcelaRepository, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService, VinculoCadastroFormaPagamentoService vinculoCadastroFormaPagamentoService, FormaPagamentoService formaPagamentoService, ContextService contextService, ParcelamentoCarneRepository parcelamentoCarneRepository) {
        this.carneRepository = carneRepository;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.geraBoletoService = geraBoletoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.vinculoCadastroFormaPagamentoService = vinculoCadastroFormaPagamentoService;
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.parcelamentoCarneRepository = parcelamentoCarneRepository;
    }
}

