/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralImagem;
import br.com.elotech.tributos.repository.CadastroGeralImagemRepository;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CadastroGeralImagemService
extends CrudService<CadastroGeralImagem, Long> {
    private final CadastroGeralImagemRepository cadastroGeralImagemRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public CadastroGeralImagemService(CadastroGeralImagemRepository cadastroGeralImagemRepository, CadastroGeralRepository cadastroGeralRepository, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.cadastroGeralImagemRepository = cadastroGeralImagemRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }

    public Page<CadastroGeralImagem> findArquivos(Long id, Pageable page) {
        return this.cadastroGeralImagemRepository.findByIdCadastroGeral(id, page);
    }

    protected void beforeDelete(CadastroGeralImagem entity, Authentication authentication) {
        this.arquivoStorageFeignClient.delete(entity.getId());
        super.beforeDelete((EloEntity)entity, authentication);
    }

    public CadastroGeralImagem uploadArquivo(Long id, MultipartFile file) {
        String usuario = SecurityUtils.getUserName();
        ArquivoDTO arquivoDTO = this.buildArquivoDTO(file);
        CadastroGeral cadastroGeral = this.getCadastroGeralById(id);
        arquivoDTO = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, file);
        CadastroGeralImagem cadastroGeralImagem = this.buildCadastroGeralImagem(file, cadastroGeral, usuario, arquivoDTO);
        return (CadastroGeralImagem)this.cadastroGeralImagemRepository.save((Object)cadastroGeralImagem);
    }

    public String getUrlArquivoDownload(Long idArquivo) {
        ArquivoDTO dto = this.getArquivoFromUnicoById(idArquivo);
        return this.arquivoStorageFeignClient.getUrlDownload(dto.getFullPath(), dto.getNome()).getUrlAssinada();
    }

    public String getUrlArquivoDisplay(Long idArquivo) {
        ArquivoDTO dto = this.getArquivoFromUnicoById(idArquivo);
        return this.arquivoStorageFeignClient.getUrlDisplay(dto.getFullPath(), dto.getNome()).getUrlAssinada();
    }

    private ArquivoDTO getArquivoFromUnicoById(Long idArquivo) {
        return Optional.ofNullable(this.arquivoStorageFeignClient.findOne(idArquivo)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado arquivo no Unico com o id %d", idArquivo)));
    }

    private ArquivoDTO buildArquivoDTO(MultipartFile file) {
        return ArquivoDTO.builder().usuario(SecurityUtils.getUserId()).tipo(TipoArquivoEnum.OUTROS).modulo(Modulo.OXY_TRIBUTOS).mimeType(file.getContentType()).nome(file.getOriginalFilename()).build();
    }

    private CadastroGeral getCadastroGeralById(Long idCadastroGeral) {
        return (CadastroGeral)this.cadastroGeralRepository.findById((Object)idCadastroGeral).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro geral com id %d", idCadastroGeral)));
    }

    private CadastroGeralImagem buildCadastroGeralImagem(MultipartFile file, CadastroGeral cadastroGeral, String usuario, ArquivoDTO arquivoDTO) {
        return CadastroGeralImagem.from((MultipartFile)file, (CadastroGeral)cadastroGeral, (String)usuario, (Long)arquivoDTO.getId());
    }
}

