/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.SituacaoImobiliarioGeomaisDTO;
import br.com.elotech.tributos.service.SituacaoImobiliarioService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/situacao-imobiliario"})
public class SituacaoImobiliarioGeomaisResource {
    private final SituacaoImobiliarioService situacaoImobiliarioService;

    public SituacaoImobiliarioGeomaisResource(SituacaoImobiliarioService situacaoImobiliarioService) {
        this.situacaoImobiliarioService = situacaoImobiliarioService;
    }

    @ApiOperation(value="Retorna uma lista de situa\u00e7\u00f5es do cadastro imobili\u00e1rio")
    @GetMapping
    public ResponseEntity<Page<SituacaoImobiliarioGeomaisDTO>> findAll(Pageable page) {
        Page situacoes = this.situacaoImobiliarioService.findAll(page).map(SituacaoImobiliarioGeomaisDTO::from);
        return ResponseEntity.ok((Object)situacoes);
    }

    @ApiOperation(value="Retorna uma situa\u00e7\u00e3o dos cadastros imobili\u00e1rios em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<SituacaoImobiliarioGeomaisDTO> findById(@PathVariable Long id) {
        SituacaoImobiliarioGeomaisDTO situacaoImobiliarioGeomaisDTO = this.situacaoImobiliarioService.findById((Serializable)id).map(SituacaoImobiliarioGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a Situa\u00e7\u00e3o do Imobili\u00e1rio com o id '%d'.", id)));
        return ResponseEntity.ok((Object)situacaoImobiliarioGeomaisDTO);
    }
}

