/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.RepresentanteLegalDTO;
import br.com.elotech.tributos.service.RepresentanteLegalService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-mobiliario/{idCadastroMobiliario}/representantes-legais"})
public class RepresentanteLegalResource {
    private final RepresentanteLegalService representanteLegalService;

    public RepresentanteLegalResource(RepresentanteLegalService representanteLegalService) {
        this.representanteLegalService = representanteLegalService;
    }

    @GetMapping
    public ResponseEntity<List<RepresentanteLegalDTO>> findAll(@PathVariable Long idCadastroMobiliario) {
        return ResponseEntity.ok((Object)this.representanteLegalService.getByCadastroMobiliarioId(idCadastroMobiliario));
    }

    @PostMapping
    public ResponseEntity<RepresentanteLegalDTO> create(@Valid @RequestBody RepresentanteLegalDTO representanteLegalDTO) {
        return ResponseEntity.ok((Object)this.representanteLegalService.save(representanteLegalDTO));
    }

    @PutMapping(value={"/{idRepresentanteLegal}"})
    public ResponseEntity<RepresentanteLegalDTO> update(@PathVariable Long idRepresentanteLegal, @Valid @RequestBody RepresentanteLegalDTO representanteLegalDTO) {
        return ResponseEntity.ok((Object)this.representanteLegalService.update(idRepresentanteLegal, representanteLegalDTO));
    }

    @DeleteMapping(value={"/{idRepresentanteLegal}"})
    public ResponseEntity<Void> delete(@PathVariable Long idRepresentanteLegal) {
        this.representanteLegalService.delete(idRepresentanteLegal);
        return ResponseEntity.noContent().build();
    }
}

