/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.dto.IdItbiDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.UsuarioDTO;
import br.com.elotech.tributos.dto.itbi.ImobiliarioItbiDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.ItbiService;
import br.com.elotech.tributos.service.ws.AiseItbiService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.ParamTransferenciaItbiDTO;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/itbi"})
public class ItbiResource {
    private final AiseItbiService aiseItbiService;
    private final ItbiService itbiService;
    private final RelatorioResource relatorioResource;

    public ItbiResource(AiseItbiService aiseItbiService, ItbiService itbiService, RelatorioResource relatorioResource) {
        this.aiseItbiService = aiseItbiService;
        this.itbiService = itbiService;
        this.relatorioResource = relatorioResource;
    }

    @PostMapping(value={"/{id}/transferir"})
    public ResponseEntity<Void> transferir(@PathVariable Long id, @RequestBody ParamTransferenciaItbiDTO transferencia) {
        this.aiseItbiService.transferir(id, transferencia.getUsuario());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/cancelar"})
    public ResponseEntity<Void> cancelar(@PathVariable Long id, @RequestBody ParamTransferenciaItbiDTO transferencia) {
        this.aiseItbiService.cancelar(id, transferencia.getUsuario(), transferencia.getMotivo());
        return ResponseEntity.ok().build();
    }

    @PostMapping
    public ResponseEntity<ImobiliarioItbi> gerarItbi(@RequestBody ImobiliarioItbiDTO imobiliarioItbiDTO) {
        return ResponseEntity.ok((Object)this.itbiService.gerarItbi(imobiliarioItbiDTO));
    }

    @PostMapping(value={"/{id}/debito"})
    public ResponseEntity<GerarDebitoResponseDTO> gerarDebito(@PathVariable Long id, @RequestBody GerarDebitoRequestDTO gerarDebitoRequestDTO) {
        return ResponseEntity.ok((Object)this.aiseItbiService.gerarDebito(id, gerarDebitoRequestDTO));
    }

    @PostMapping(value={"/{id}/bloqueto"})
    public ResponseEntity<BloquetoDTO> gerarBloqueto(@PathVariable Long id, @RequestBody UsuarioDTO usuarioDTO) {
        return ResponseEntity.ok((Object)this.aiseItbiService.gerarBloqueto(id, usuarioDTO.getUsuario()));
    }

    @PostMapping(value={"/verificar-pagamentos"})
    public ResponseEntity<List<IdItbiDTO>> verificarPagos(@RequestBody List<IdItbiDTO> listIdItbi) {
        return ResponseEntity.ok((Object)this.itbiService.verificarPagos(listIdItbi));
    }

    @PostMapping(value={"/imprimir-termo-isencao"})
    public void printTermoIsencao(HttpServletResponse response, @RequestBody ImobiliarioItbiDTO imobiliarioItbiDTO) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.itbiService.printTermoIsencao(imobiliarioItbiDTO);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }
}

