/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DocumentoTipoDTO;
import br.com.elotech.tributos.service.DocumentoTipoService;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-tipos"})
public class DocumentoTipoResource {
    private final DocumentoTipoService documentoTipoService;

    public DocumentoTipoResource(DocumentoTipoService documentoTipoService) {
        this.documentoTipoService = documentoTipoService;
    }

    @GetMapping
    public ResponseEntity<List<DocumentoTipo>> findByRsql(@RequestParam Optional<String> search) {
        return ResponseEntity.ok((Object)this.documentoTipoService.findByRsql(search));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DocumentoTipoDTO>> findByRsqlPaged(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.documentoTipoService.findByRsqlPaged(search, pageable).map(DocumentoTipoDTO::of));
    }

    @GetMapping(value={"/permitidos"})
    public ResponseEntity<List<DocumentoTipoDTO>> findPermitidos(@RequestParam(value="tipo-cadastro") Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.documentoTipoService.findPermitidos(tipoCadastro));
    }

    @GetMapping(value={"/{tipoDocumento}/tipos-cadastro"})
    public ResponseEntity<List<TipoCadastro>> findTiposCadastroDisponiveisEmissao(@PathVariable(value="tipoDocumento") Long tipoDocumento) {
        return ResponseEntity.ok((Object)this.documentoTipoService.findTiposCadastroDisponiveisEmissao(tipoDocumento));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DocumentoTipoDTO> findById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.documentoTipoService.findByTipoDocumento(id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DocumentoTipoDTO> atualizar(@PathVariable Long id, @RequestBody @Valid DocumentoTipoDTO documentoTipo) {
        return ResponseEntity.ok((Object)DocumentoTipoDTO.of((DocumentoTipo)this.documentoTipoService.update(id, documentoTipo)));
    }
}

