/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.BoletoResumoDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.dto.GeraBoletoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.params.GeraBloquetoParams;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.requerimento.RequerimentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoCidadaoDTO;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bloqueto"})
public class BoletoResource
extends ReadOnlyResource<Bloqueto, Long> {
    private final AiseBloquetoService aiseBloquetoService;
    private final AisePdfService aisePdfService;
    private final BloquetoService bloquetoService;
    private final RequerimentoService requerimentoService;

    @GetMapping(params={"bloqueto"})
    public ResponseEntity<Bloqueto> findByBloqueto(Long bloqueto) {
        Bloqueto bloquetoResult = this.findByIdBloqueto(bloqueto);
        return ResponseEntity.ok().body((Object)bloquetoResult);
    }

    @PostMapping(path={"/gera/imprime"})
    public ImpressaoDTO geraBloquetoEImprime(@RequestBody List<DebitoDTO> params) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloqueto(params);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(bloquetoDTO.getBloqueto(), bloquetoDTO.getExercicioBloqueto()));
    }

    @PostMapping(path={"/gera"})
    public ResponseEntity<BloquetoDTO> geraBloqueto(@RequestBody List<DebitoDTO> params, HttpServletResponse response) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloqueto(params);
        return ResponseEntity.ok().body((Object)bloquetoDTO.setCadastroPessoaDTO());
    }

    @PostMapping(path={"/gera-por-data-pagamento"})
    public ResponseEntity<BloquetoDTO> geraBloquetoPorDataPagamento(@RequestBody GeraBloquetoParams params, HttpServletResponse response) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloquetoPorDataPagamento(params.getDebitos(), params.getDataReferencia());
        return ResponseEntity.ok().body((Object)bloquetoDTO);
    }

    @PostMapping(path={"/gera-por-forma-pagamento"})
    public ResponseEntity<BloquetoDTO> geraBloquetoPorFormaPagamento(@RequestBody GeraBoletoPorFormaPagamentoDTO params, HttpServletResponse response) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBoletoPorFormaPagamento(params);
        return ResponseEntity.ok().body((Object)bloquetoDTO);
    }

    @GetMapping(path={"/imprime"}, params={"bloqueto"})
    public ImpressaoDTO imprimirBloqueto(@RequestParam(value="bloqueto") Long boleto) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto, Long.valueOf(LocalDate.now().getYear())));
    }

    @GetMapping(path={"/imprime-por-exercicio"}, params={"bloqueto", "exercicioBloqueto"})
    public ImpressaoDTO imprimirBloquetoPorExercicio(@RequestParam(value="bloqueto") Long boleto, @RequestParam(value="exercicioBloqueto") Long exercicioBoleto) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto, exercicioBoleto));
    }

    @GetMapping(value={"/imprime-por-requerimento"})
    public ImpressaoDTO imprimirBoletoRequerimento(@RequestParam(value="idRequerimento") Long idRequerimento, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio) {
        return this.requerimentoService.imprimirBoletoRequerimento(RequerimentoId.from((Long)entidade, (Long)exercicio, (Long)idRequerimento));
    }

    private Bloqueto findByIdBloqueto(Long idBloqueto) {
        Bloqueto bloqueto = this.bloquetoService.findByBloqueto(idBloqueto);
        return Optional.ofNullable(bloqueto).orElseThrow(() -> RestException.notFound((String)"Verificar se o banco est\u00e1 configurado para o mesmo que o do webservices"));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<Page<BoletoDTO>> search(@RequestBody FiltroBoletoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.bloquetoService.findBoleto(filtro, pageable));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<BoletoResumoDTO> getBoletoResumoById(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.bloquetoService.findBoletoResumoById(id));
    }

    @GetMapping(path={"/search-boleto-pagamento"}, params={"termo"})
    public ResponseEntity<BoletoDTO> getBoletoPorTermo(@RequestParam(value="termo") String termo) {
        return ResponseEntity.ok((Object)this.bloquetoService.getBoletoLoteManualPorTermo(termo));
    }

    @GetMapping(path={"/search-boleto-pagamento-cadastro"}, params={"termo", "entidade", "exercicioPagamento", "bloqueto"})
    public ResponseEntity<BoletoDTO> findBoletoPorTermoAndPagamento(@RequestParam(value="termo") String termo, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicioPagamento") Long exercicioPagamento, @RequestParam(value="bloqueto") Long bloqueto) {
        return ResponseEntity.ok((Object)this.bloquetoService.getBoletoLoteManualPorTermoEMesmoCadastroPagamento(termo, entidade, exercicioPagamento, bloqueto));
    }

    @PostMapping(path={"/gera-por-data-pagamento/cidadao"})
    public ResponseEntity<BloquetoCidadaoDTO> geraBloquetoPorDataPagamentoCidadao(@RequestBody GeraBloquetoParams params, HttpServletResponse response) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloquetoPorDataPagamento(params.getDebitos(), params.getDataReferencia());
        BloquetoCidadaoDTO bloquetoCidadaoDTO = BloquetoCidadaoDTO.from((Bloqueto)((Bloqueto)this.bloquetoService.findOne((Serializable)bloquetoDTO.getId())));
        bloquetoCidadaoDTO.setUrlImpressao(bloquetoDTO.getUrlImpressao());
        return ResponseEntity.ok().body((Object)bloquetoCidadaoDTO);
    }

    @Generated
    public BoletoResource(AiseBloquetoService aiseBloquetoService, AisePdfService aisePdfService, BloquetoService bloquetoService, RequerimentoService requerimentoService) {
        this.aiseBloquetoService = aiseBloquetoService;
        this.aisePdfService = aisePdfService;
        this.bloquetoService = bloquetoService;
        this.requerimentoService = requerimentoService;
    }
}

