/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobile;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.sql.SqlWhere;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.dto.mobile.EnderecoMobileDTO;
import br.com.elotech.tributos.dto.mobile.PropriedadeMobileDTO;
import br.com.elotech.tributos.dto.mobile.TipoCadastroMobileDTO;
import br.com.elotech.tributos.service.RegimeFiscalPeriodoService;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class PropriedadeMobileRepository {
    private static final String COLUMN_DATAVENCIMENTO = "datavencimento";
    private static final String COLUMN_DESCRICAO = "descricao";
    private static final String COLUMN_VALOR = "valor";
    private static final String COLUMN_PARCELA = "parcela";
    private static final String COLUMN_ID_DEBITO = "idDebito";
    private static final String COLUMN_ESTADO = "estado";
    private static final String COLUMN_CEP = "cep";
    private static final String COLUMN_COMPLEMENTO = "complemento";
    private static final String COLUMN_NUMERO = "numero";
    private static final String COLUMN_RUA = "rua";
    private static final String COLUMN_CIDADE = "cidade";
    private static final String COLUMN_NOME = "nome";
    private static final String COLUMN_CPF_CNPJ = "cpfCnpj";
    private static final String COLUMN_CADASTROGERAL = "cadastrogeral";
    private static final String COLUMN_TIPOCADASTRO = "tipocadastro";
    private static final String COLUMN_POSSUI_COTA_UNICA = "possuiCotaUnica";
    private static final String COLUMN_CADASTROGERALISS = "idCadastroGeralIss";
    private static final String COLUMN_SITUACAO = "situacao";
    private static final String COLUMN_DESCSITUACAO = "descSituacao";
    private static final String COLUMN_NUMEROALVARA = "numeroAlvara";
    private static final String COLUMN_EXERCICIOLVARA = "exercicioAlvara";
    private static final String COLUMN_ATIVIDADEPRINCIPAL = "atividadePrincipal";
    private static final String COLUMN_OBSERVACAOALVARA = "observacaoAlvara";
    private static final String COLUMN_DATAABERTURA = "dataAbertura";
    private static final String COLUMN_DATAVALIDADEALVARA = "dataValidadeAlvara";
    private static final String COLUMN_DATAENCERRAMENTO = "dataEncerramento";
    private static final String COLUMN_DATAULTIMAFISCALIZACAO = "dataUltimaFiscalizacao";
    private static final String COLUMN_REPRESENTANTELEGAL = "representanteLegal";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    @Autowired
    private RegimeFiscalPeriodoService regimeFiscalPeriodoService;
    private static final String SQL_DEBITO_ABERTO = "br/com/elotech/tributos/repository/mobile/findPropriedadesComDebitoEmAberto.sql";
    private static final String SQL_PROPRIEDADE_BY_TIPO_AND_CODIGO = "br/com/elotech/tributos/repository/mobile/findPropriedadeByTipoAndCodigo.sql";
    private static final String SQL_TIPOCADASTRO_CPFCNPJ = "br/com/elotech/tributos/repository/mobile/findTipoCadastroByCpfCnpj.sql";
    private static final String SQL_PROPRIEDADES_CPFCNPJ = "br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpj.sql";
    private static final String SQL_DEBITO_ABERTO_PERIODO = "br/com/elotech/tributos/repository/mobile/findPropriedadeComDebitoEmAbertoPorPeriodo.sql";
    private static final String SQL_PROPRIEDADES_CPFCNPJ_AND_FILTRES = "br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpjAndFilters.sql";

    public List<PropriedadeMobileDTO> findPropriedadesDebitoEmAberto(String cpfCnpj, Long entidade, Long exercicio, LocalDate dataVencimento) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadesComDebitoEmAberto.sql");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("entidade", (Object)entidade);
        parameter.addValue("exercicio", (Object)exercicio);
        parameter.addValue("dataVencimento", (Object)Date.valueOf(dataVencimento));
        parameter.addValue("cnpjcpf", (Object)cpfCnpj);
        return this.namedJdbcTemplate.query(sql, (SqlParameterSource)parameter, (rs, rowNum) -> {
            PropriedadeMobileDTO propriedadeMobileDTO = this.setPropriedadeMobileDTO(rs);
            propriedadeMobileDTO.setPossuiCotaUnica(Boolean.valueOf(rs.getBoolean("possuiCotaUnica")));
            return propriedadeMobileDTO;
        });
    }

    public PropriedadeMobileDTO findPropriedadeByTipoAndCodigo(Integer tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadeByTipoAndCodigo.sql");
        return (PropriedadeMobileDTO)this.jdbcTemplate.queryForObject(sql, new Object[]{tipoCadastro, cadastroGeral}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public List<TipoCadastroMobileDTO> findTipoCadastroByCpfCnpj(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findTipoCadastroByCpfCnpj.sql");
        return this.jdbcTemplate.query(sql, new Object[]{cpfCnpj}, (rs, rowNum) -> {
            TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)rs.getLong("tipocadastro"));
            return new TipoCadastroMobileDTO(tipoCadastro.getValue(), tipoCadastro.getDescricao());
        });
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpjAndTipoCadastro(String cpfCnpj, Long tipoCadastro) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpj.sql"));
        sql.append(" AND ger.tipocadastro = ? ");
        return this.jdbcTemplate.query(sql.toString(), new Object[]{cpfCnpj, tipoCadastro}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpj(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpj.sql");
        return this.jdbcTemplate.query(sql, new Object[]{cpfCnpj}, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
    }

    public Page<PropriedadeMobileDTO> findPropriedadesByCpfCnpjAndTipoAndCodigo(String cpfCnpj, Optional<String> search, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadesByCpfCnpjAndFilters.sql");
        String finalSql = sql.replace("$[FILTROS]", this.addFilterCadastros(cpfCnpj, search));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Optional sqlWhere = PropriedadeMobileRepository.createNewConditions((String)search.get());
        if (sqlWhere.isPresent()) {
            parameters = new MapSqlParameterSource(((SqlWhere)sqlWhere.get()).getParams());
        }
        parameters.addValue("cpfCnpj", (Object)cpfCnpj);
        String sqlComPaginacao = SqlUtils.withPagination((String)finalSql, (Pageable)pageable, (DataSource)this.namedJdbcTemplate.getJdbcTemplate().getDataSource());
        List lista = this.namedJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (rs, rowNum) -> this.setPropriedadeMobileDTO(rs));
        return new PageImpl(lista, pageable, (long)pageable.getPageSize());
    }

    private StringBuilder addFilterCadastros(String cpfCnpj, Optional<String> search) {
        StringBuilder stringBuilder = new StringBuilder();
        if (search.isPresent()) {
            String filtro = search.get();
            Optional filtros = PropriedadeMobileRepository.createNewConditions((String)filtro);
            filtros.ifPresent(sqlWhere -> stringBuilder.append(String.format(" and %s ", sqlWhere.getWhere()).replace("tipoCadastro ", "ger.tipocadastro ").replace("cadastroGeral ", "ger.cadastrogeral ")));
        }
        stringBuilder.append(" and pes.cnpj_cpf = :cpfCnpj ");
        return stringBuilder;
    }

    private static Optional<SqlWhere> createNewConditions(String filtro) {
        return StringUtils.isNotBlank((CharSequence)filtro) ? Optional.of(RsqlUtils.transformToSql((String)filtro, PropriedadeMobileDTO.class)) : Optional.empty();
    }

    private PropriedadeMobileDTO setPropriedadeMobileDTO(ResultSet rs) throws SQLException {
        Integer tipoCadastro = rs.getInt("tipocadastro");
        PropriedadeMobileDTO prop = new PropriedadeMobileDTO();
        prop.setTipoCadastro(tipoCadastro);
        prop.setCadastroGeral(Long.valueOf(rs.getLong("cadastrogeral")));
        prop.setCpfCnpj(rs.getString("cpfCnpj"));
        prop.setNome(rs.getString("nome"));
        prop.setPossuiCotaUnica(Boolean.valueOf(false));
        EnderecoMobileDTO endereco = new EnderecoMobileDTO();
        endereco.setCidade(rs.getString("cidade"));
        endereco.setRua(rs.getString("rua"));
        endereco.setNumero(rs.getString("numero"));
        endereco.setComplemento(rs.getString("complemento"));
        endereco.setCep(rs.getString("cep"));
        endereco.setEstado(rs.getString("estado"));
        EnderecoMobileDTO enderecoEntrega = new EnderecoMobileDTO();
        enderecoEntrega.setCidade(rs.getString("cidade"));
        enderecoEntrega.setRua(rs.getString("rua"));
        enderecoEntrega.setNumero(rs.getString("numero"));
        enderecoEntrega.setComplemento(rs.getString("complemento"));
        enderecoEntrega.setCep(rs.getString("cep"));
        enderecoEntrega.setEstado(rs.getString("estado"));
        prop.setEndereco(endereco);
        prop.setEnderecoCorrespondencia(enderecoEntrega);
        prop.setSituacao(Long.valueOf(rs.getLong("situacao")));
        prop.setDescSituacao(rs.getString("descSituacao"));
        prop.setRepresentanteLegal(Boolean.valueOf(Objects.equals("S", rs.getString("representanteLegal"))));
        if (Objects.equals(TipoCadastro.MOBILIARIO.getValue().intValue(), tipoCadastro)) {
            RegimeFiscal regimeFiscal = null;
            Long idCadastroGeralISS = rs.getLong("idCadastroGeralIss");
            if (Objects.nonNull(idCadastroGeralISS) && idCadastroGeralISS > 0L) {
                regimeFiscal = this.regimeFiscalPeriodoService.findRegimeFiscal(idCadastroGeralISS);
            }
            if (Objects.nonNull(regimeFiscal)) {
                prop.setRegimeFiscal(regimeFiscal.getDescricao());
            }
            prop.setNumeroAlvara(Long.valueOf(rs.getLong("numeroAlvara")));
            prop.setExercicioAlvara(Long.valueOf(rs.getLong("exercicioAlvara")));
            prop.setAtividadePrincipal(rs.getString("atividadePrincipal"));
            prop.setObservacaoAlvara(rs.getString("observacaoAlvara"));
            Optional.ofNullable(rs.getDate("dataAbertura")).ifPresent(data -> prop.setDataAbertura(data.toLocalDate()));
            Optional.ofNullable(rs.getDate("dataEncerramento")).ifPresent(data -> prop.setDataAbertura(data.toLocalDate()));
            Optional.ofNullable(rs.getDate("dataValidadeAlvara")).ifPresent(data -> prop.setDataAbertura(data.toLocalDate()));
            Optional.ofNullable(rs.getDate("dataUltimaFiscalizacao")).ifPresent(data -> prop.setDataAbertura(data.toLocalDate()));
        }
        return prop;
    }

    public List<PropriedadeMobileDTO> findPropriedadesDebitoEmAbertoByCpfCnpjAndDataVencimento(String cpfCnpj, Date ... vencimentos) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/mobile/findPropriedadeComDebitoEmAbertoPorPeriodo.sql"));
        sql.append(" and ( ").append(this.getFiltroVencimento(vencimentos)).append(" ) ");
        Object[] parameters = this.getParametersFindByCpfCnpjAndDataVencimento(cpfCnpj, vencimentos);
        return this.jdbcTemplate.query(sql.toString(), parameters, (rs, rowNum) -> this.setPropriedadeDebitoMobileDTO(rs));
    }

    private Object[] getParametersFindByCpfCnpjAndDataVencimento(String cpfCnpj, Date ... vencimentos) {
        Integer quantidadeParametros = vencimentos.length + 1;
        Object[] parameters = new Object[quantidadeParametros.intValue()];
        parameters[0] = cpfCnpj;
        System.arraycopy(vencimentos, 0, parameters, 1, vencimentos.length);
        return parameters;
    }

    private String getFiltroVencimento(Date ... vencimentos) {
        StringBuilder filtro = new StringBuilder();
        for (int i = 0; i < vencimentos.length; ++i) {
            if (filtro.length() == 0) {
                filtro.append(" par.datavencimento = ? ");
                continue;
            }
            filtro.append(" or par.datavencimento = ? ");
        }
        return filtro.toString();
    }

    private PropriedadeMobileDTO setPropriedadeDebitoMobileDTO(ResultSet rs) throws SQLException {
        PropriedadeMobileDTO prop = new PropriedadeMobileDTO();
        prop.setTipoCadastro(Integer.valueOf(rs.getInt("tipocadastro")));
        prop.setCadastroGeral(Long.valueOf(rs.getLong("cadastrogeral")));
        prop.setCpfCnpj(rs.getString("cpfCnpj"));
        prop.setNome(rs.getString("nome"));
        DebitoMobileDTO debito = new DebitoMobileDTO();
        debito.setIdDebito(Long.valueOf(rs.getLong("idDebito")));
        debito.setDescricaoVisualizacao(rs.getString("descricao"));
        DebitoParcelaMobileDTO parcela = new DebitoParcelaMobileDTO();
        parcela.setIdDebito(Long.valueOf(rs.getLong("idDebito")));
        parcela.setParcela(Integer.valueOf(rs.getInt("parcela")));
        parcela.setValor(rs.getBigDecimal("valor"));
        parcela.setVencimento(rs.getDate("datavencimento"));
        debito.setParcelas(new ArrayList<DebitoParcelaMobileDTO>(Arrays.asList(parcela)));
        prop.setDebitos(new ArrayList<DebitoMobileDTO>(Arrays.asList(debito)));
        return prop;
    }
}

