/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaogeomais;

import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroImobiliarioSegmentoGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.SituacaoSegmentoImobGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.TipoSegmentoGeomaisDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroImobiliarioSegmentoGeomaisDTO {
    private Long id;
    @NotNull
    private Long sequencia;
    private String principal;
    @NotNull
    private BigDecimal area;
    @NotNull
    @Valid
    private TipoSegmentoGeomaisDTO tipo;
    @Valid
    private SituacaoSegmentoImobGeomaisDTO situacao;
    @Valid
    private List<BoletimGeomaisDTO> caracteristicas = new ArrayList();

    public static Builder builder() {
        return new Builder();
    }

    public static CadastroImobiliarioSegmentoGeomaisDTO from(CadastroImobiliarioSegmento entity) {
        return CadastroImobiliarioSegmentoGeomaisDTO.builder().id(entity.getId()).sequencia(entity.getSequencia()).principal(entity.getPrincipal().booleanValue()).area(entity.getAreaConstruida()).tipo(TipoSegmentoGeomaisDTO.from((TipoSegmento)entity.getTipoSegmento())).situacao((SituacaoSegmentoImobGeomaisDTO)Optional.ofNullable(entity).map(CadastroImobiliarioSegmento::getSituacaoSegmento).map(SituacaoSegmentoImobGeomaisDTO::from).orElse(null)).build();
    }

    public CadastroImobiliarioSegmento toEntity(Long cadastroGeral, TipoSegmento tipoSegmento, SituacaoSegmentoImob situacaoSegmentoImob) {
        CadastroImobiliarioSegmento entity = new CadastroImobiliarioSegmento();
        entity.setId(this.getId());
        entity.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        entity.setCadastroGeral(cadastroGeral);
        entity.setSequencia(this.getSequencia());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setAreaConstruida(this.getArea());
        entity.setTipoSegmento(tipoSegmento);
        entity.setIdTipoSegmento(tipoSegmento.getId());
        entity.setSituacaoSegmento(situacaoSegmentoImob);
        return entity;
    }

    public CadastroImobiliarioSegmento toEntity(Long cadastroGeral, TipoSegmento tipoSegmento) {
        CadastroImobiliarioSegmento entity = new CadastroImobiliarioSegmento();
        entity.setId(this.getId());
        entity.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        entity.setCadastroGeral(cadastroGeral);
        entity.setSequencia(this.getSequencia());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setAreaConstruida(this.getArea());
        entity.setTipoSegmento(tipoSegmento);
        entity.setIdTipoSegmento(tipoSegmento.getId());
        return entity;
    }

    @Generated
    public CadastroImobiliarioSegmentoGeomaisDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public TipoSegmentoGeomaisDTO getTipo() {
        return this.tipo;
    }

    @Generated
    public SituacaoSegmentoImobGeomaisDTO getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<BoletimGeomaisDTO> getCaracteristicas() {
        return this.caracteristicas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setTipo(TipoSegmentoGeomaisDTO tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(SituacaoSegmentoImobGeomaisDTO situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCaracteristicas(List<BoletimGeomaisDTO> caracteristicas) {
        this.caracteristicas = caracteristicas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioSegmentoGeomaisDTO)) {
            return false;
        }
        CadastroImobiliarioSegmentoGeomaisDTO other = (CadastroImobiliarioSegmentoGeomaisDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        BigDecimal this$area = this.getArea();
        BigDecimal other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)this$area).equals(other$area)) {
            return false;
        }
        TipoSegmentoGeomaisDTO this$tipo = this.getTipo();
        TipoSegmentoGeomaisDTO other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        SituacaoSegmentoImobGeomaisDTO this$situacao = this.getSituacao();
        SituacaoSegmentoImobGeomaisDTO other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        List this$caracteristicas = this.getCaracteristicas();
        List other$caracteristicas = other.getCaracteristicas();
        return !(this$caracteristicas == null ? other$caracteristicas != null : !((Object)this$caracteristicas).equals(other$caracteristicas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioSegmentoGeomaisDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        BigDecimal $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
        TipoSegmentoGeomaisDTO $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        SituacaoSegmentoImobGeomaisDTO $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        List $caracteristicas = this.getCaracteristicas();
        result = result * 59 + ($caracteristicas == null ? 43 : ((Object)$caracteristicas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioSegmentoGeomaisDTO(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", principal=" + this.getPrincipal() + ", area=" + this.getArea() + ", tipo=" + this.getTipo() + ", situacao=" + this.getSituacao() + ", caracteristicas=" + this.getCaracteristicas() + ")";
    }
}

