/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class FiltroArrecadacaoPorLoteDTO {
    @NotNull
    private LocalDate dataMovimento;
    private ContaBancaria contaBancaria;
    private Long exercicio;
    private Long lote;
    private Convenio convenio;

    public String buildFiltro() {
        StringBuilder filtro = new StringBuilder();
        if (Objects.nonNull(this.contaBancaria)) {
            filtro.append(String.format(" and contabancaria.id = %d", this.contaBancaria.getId()));
        }
        if (Objects.nonNull(this.convenio)) {
            filtro.append(String.format(" and convenio.id = %d", this.convenio.getId()));
        }
        if (Objects.nonNull(this.exercicio)) {
            filtro.append(String.format(" and lote.exercicio = %d", this.exercicio));
        }
        if (Objects.nonNull(this.lote)) {
            filtro.append(String.format(" and lote.lote = %d", this.lote));
        }
        return filtro.toString();
    }

    @Generated
    public FiltroArrecadacaoPorLoteDTO() {
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroArrecadacaoPorLoteDTO)) {
            return false;
        }
        FiltroArrecadacaoPorLoteDTO other = (FiltroArrecadacaoPorLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        ContaBancaria this$contaBancaria = this.getContaBancaria();
        ContaBancaria other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Convenio this$convenio = this.getConvenio();
        Convenio other$convenio = other.getConvenio();
        return !(this$convenio == null ? other$convenio != null : !this$convenio.equals(other$convenio));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroArrecadacaoPorLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        ContaBancaria $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Convenio $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : $convenio.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroArrecadacaoPorLoteDTO(dataMovimento=" + this.getDataMovimento() + ", contaBancaria=" + this.getContaBancaria() + ", exercicio=" + this.getExercicio() + ", lote=" + this.getLote() + ", convenio=" + this.getConvenio() + ")";
    }
}

