/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bradesco;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Agencia;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoCarteira;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoBoletoBradescoDTO {
    private static final Long VALOR = 1L;
    private static final Long PORCENTAGEM = 2L;
    private static final String TIPO_ACESSO_FIXO_BOLETO_REGISTRADO = "2";
    private static final String CLUB_BANCO_FIXO_BOLETO_REGISTRADO = "2269651";
    private static final String TIPO_CONTRATO_FIXO_BOLETO_REGISTRADO = "48";
    @JsonProperty(value="nuCPFCNPJ")
    private String cpfCnpjRaiz = "0";
    private String filialCPFCNPJ = "0";
    @JsonProperty(value="ctrlCPFCNPJ")
    private String controleCpfCnpj = "0";
    @JsonProperty(value="cdTipoAcesso")
    private String tipoAcesso = "2";
    private String clubBanco = "2269651";
    @JsonProperty(value="cdTipoContrato")
    private String tipoContrato = "48";
    @JsonProperty(value="nuSequenciaContrato")
    private String sequenciaContrato = "0";
    private String idProduto = "0";
    @JsonProperty(value="nuNegociacao")
    private String negociacao = "0";
    @JsonProperty(value="cdBanco")
    private String banco = String.valueOf(Banco.CODIGO_BRADESCO);
    @JsonProperty(value="eNuSequenciaContrato")
    private String eSequenciaContrato = "0";
    @JsonProperty(value="tpRegistro")
    private String registro = "1";
    @JsonProperty(value="cdProduto")
    private String produto = "0";
    @JsonProperty(value="nuTitulo")
    private String titulo = "0";
    @JsonProperty(value="nuCliente")
    private String numeroCliente = "";
    private String dtEmissaoTitulo = "";
    private String dtVencimentoTitulo = "";
    @JsonProperty(value="tpVencimento")
    private String vencimento = "0";
    @JsonProperty(value="vlNominalTitulo")
    private String valorNominalTitulo = "0";
    @JsonProperty(value="cdEspecieTitulo")
    private String especieTitulo = "0";
    @JsonProperty(value="tpProtestoAutomaticoNegativacao")
    private String protestoAutomaticoNegativacao = "0";
    private String prazoProtestoAutomaticoNegativacao = "0";
    private String controleParticipante = "";
    @JsonProperty(value="cdPagamentoParcial")
    private String pagamentoParcial = "";
    private String qtdePagamentoParcial = "0";
    @JsonProperty(value="vlJuros")
    private String juros = "0";
    private String qtdeDiasJuros = "0";
    private String percentualJuros = "0";
    @JsonProperty(value="vlMulta")
    private String multa = "0";
    private String qtdeDiasMulta = "0";
    private String percentualMulta = "0";
    @JsonProperty(value="vlDesconto1")
    private String valorDesconto1 = "0";
    private String dataLimiteDesconto1 = "";
    private String percentualDesconto1 = "0";
    @JsonProperty(value="vlDesconto2")
    private String valorDesconto2 = "0";
    private String dataLimiteDesconto2 = "";
    private String percentualDesconto2 = "0";
    @JsonProperty(value="vlDesconto3")
    private String valorDesconto3 = "0";
    private String dataLimiteDesconto3 = "";
    private String percentualDesconto3 = "0";
    private String prazoBonificacao = "0";
    private String percentualBonificacao = "0";
    @JsonProperty(value="vlBonificacao")
    private String valorBonificacao = "0";
    private String dtLimiteBonificacao = "";
    @JsonProperty(value="vlAbatimento")
    private String valorAbatimento = "0";
    @JsonProperty(value="vlIOF")
    private String valorIOF = "0";
    private String nomePagador = "";
    private String logradouroPagador = "";
    @JsonProperty(value="nuLogradouroPagador")
    private String numeroLogradouroPagador = "";
    private String complementoLogradouroPagador = "";
    private String cepPagador = "0";
    private String complementoCepPagador = "0";
    private String bairroPagador = "";
    private String municipioPagador = "";
    private String ufPagador = "";
    @JsonProperty(value="cdIndCpfcnpjPagador")
    private String indicadorCpfCnpjPagador = "0";
    @JsonProperty(value="nuCpfcnpjPagador")
    private String cpfcnpjPagador = "0";
    @JsonProperty(value="endEletronicoPagador")
    private String enderecoEletronicoPagador = "";
    private String nomeSacadorAvalista = "";
    private String logradouroSacadorAvalista = "";
    @JsonProperty(value="nuLogradouroSacadorAvalista")
    private String numeroLogradouroSacadorAvalista = "0";
    private String complementoLogradouroSacadorAvalista = "";
    private String cepSacadorAvalista = "0";
    private String complementoCepSacadorAvalista = "0";
    private String bairroSacadorAvalista = "";
    private String municipioSacadorAvalista = "";
    private String ufSacadorAvalista = "";
    @JsonProperty(value="cdIndCpfcnpjSacadorAvalista")
    private String indicadorCpfCnpjAvalista = "0";
    @JsonProperty(value="nuCpfcnpjSacadorAvalista")
    private String cpfcnpjSacadorAvalista = "0";
    @JsonProperty(value="endEletronicoSacadorAvalista")
    private String enderecoEletronicoSacadorAvalista = "";

    public static EmissaoBoletoBradescoDTO from(Bloqueto boleto, ParametroCNAB240 parametroCNAB240Bradesco, Entidade entidade) {
        DecimalFormat percentualFormatter = new DecimalFormat();
        percentualFormatter.setDecimalSeparatorAlwaysShown(false);
        percentualFormatter.setMinimumIntegerDigits(3);
        percentualFormatter.setMinimumFractionDigits(5);
        DecimalFormat valueFormatter = new DecimalFormat("#00000000000000.00");
        valueFormatter.getDecimalFormatSymbols().setDecimalSeparator(',');
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa enderecoPessoa = pessoa.getEnderecoPrincipal();
        EmissaoBoletoBradescoDTO dto = new EmissaoBoletoBradescoDTO();
        dto.setCpfCnpjRaiz(StringUtils.substring((String)entidade.getCnpj(), (int)0, (int)8));
        dto.setFilialCPFCNPJ("0001");
        dto.setControleCpfCnpj(entidade.getCnpj().substring(entidade.getCnpj().length() - 2));
        dto.setNegociacao(EmissaoBoletoBradescoDTO.getCodigoNegociacao((Convenio)convenio));
        if (Objects.nonNull(boleto)) {
            dto.setTitulo(Optional.of(boleto.getNossoNumero()).filter(nossoNumero -> nossoNumero.length() >= 11).map(nossoNumero -> nossoNumero.substring(0, 11)).orElse("0"));
            dto.setNumeroCliente(boleto.getCadastroGeral().getCadastroGeral().toString());
            dto.setDtEmissaoTitulo(boleto.getDataEmissao().format(dateFormatter));
            dto.setDtVencimentoTitulo(boleto.getDataVencimento().format(dateFormatter));
            dto.setValorNominalTitulo(valueFormatter.format(boleto.getValorPrincipal().add(boleto.getValorJuros()).add(boleto.getValorMulta()).add(boleto.getValorCorrecao())).replace(",", ""));
            dto.setQtdeDiasJuros(boleto.getValorJuros().compareTo(BigDecimal.ZERO) > 0 ? "1" : "0");
            dto.setQtdeDiasMulta(boleto.getValorMulta().compareTo(BigDecimal.ZERO) > 0 ? "1" : "0");
            BigDecimal valorDescontoBoleto = boleto.getValorDesconto();
            if (Objects.nonNull(valorDescontoBoleto) && valorDescontoBoleto.compareTo(BigDecimal.ZERO) > 0) {
                dto.setValorDesconto1(valueFormatter.format(valorDescontoBoleto).replace(",", ""));
                Optional.ofNullable(boleto.getDataLimitePagamento()).ifPresent(dataLimite -> dto.setDataLimiteDesconto1(dataLimite.format(dateFormatter)));
            }
            dto.setNomePagador(pessoa.getNome());
            dto.setLogradouroPagador(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse(""));
            dto.setNumeroLogradouroPagador(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getNumero).orElse("0"));
            Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCep).map(String::valueOf).ifPresent(cep -> {
                dto.setCepPagador(cep.substring(0, 5));
                dto.setComplementoCepPagador(cep.substring(5));
            });
            dto.setBairroPagador(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getBairro).map(Bairro::getDescricao).orElse(""));
            dto.setMunicipioPagador(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(""));
            dto.setUfPagador(Optional.ofNullable(enderecoPessoa).map(EnderecoPessoa::getUnidadeFederacao).map(UnidadeFederacao::getUnidadeFederacao).orElse(""));
            dto.setIndicadorCpfCnpjPagador(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? "1" : "2");
            dto.setCpfcnpjPagador(pessoa.getCnpjCpfSemMascara());
        }
        if (Objects.nonNull(parametroCNAB240Bradesco)) {
            dto.setIdProduto("0" + Optional.ofNullable(parametroCNAB240Bradesco.getCodigoCarteira()).map(CNAB240CodigoCarteira::getCodigo).map(String::valueOf).orElse("0"));
            dto.setEspecieTitulo("0" + Optional.ofNullable(parametroCNAB240Bradesco.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getEspecieTitulo).map(String::valueOf).orElse("0"));
            if (boleto.getValorJuros().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal valorJuros = Optional.ofNullable(parametroCNAB240Bradesco.getValorJurosDiaTaxa()).orElse(BigDecimal.ZERO);
                dto.setPercentualJuros(valorJuros.compareTo(BigDecimal.ZERO) > 0 ? percentualFormatter.format(valorJuros).replace(",", "") : BigDecimal.ZERO.toString());
            }
            dto.setJuros(BigDecimal.ZERO.toString());
            if (boleto.getValorMulta().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal valorMulta = Optional.ofNullable(parametroCNAB240Bradesco.getValorPercentualMulta()).orElse(BigDecimal.ZERO);
                dto.setPercentualMulta(valorMulta.compareTo(BigDecimal.ZERO) > 0 ? percentualFormatter.format(valorMulta).replace(",", "") : BigDecimal.ZERO.toString());
            }
            dto.setMulta(BigDecimal.ZERO.toString());
        }
        return dto;
    }

    private static String getCodigoNegociacao(Convenio convenio) {
        String agenciaNegociacaoNumeros = Optional.ofNullable(convenio.getContaBancaria().getAgencia()).map(Agencia::getAgencia).map(agencia -> StringUtils.left((String)agencia.replaceAll("[^\\d]", ""), (int)4)).orElseThrow(() -> new EloValidationException("Ag\u00eancia n\u00e3o encontrada"));
        String contaBancariaNegocioacaoNumeros = Optional.ofNullable(convenio.getContaBancaria().getConta()).map(conta -> StringUtils.leftPad((String)conta.replaceAll("[^\\d]", ""), (int)7, (String)"0")).orElseThrow(() -> new EloValidationException("Conta banc\u00e1ria n\u00e3o encontrada"));
        return (agenciaNegociacaoNumeros + "0000000" + contaBancariaNegocioacaoNumeros).trim();
    }

    @Generated
    public EmissaoBoletoBradescoDTO() {
    }

    @Generated
    public String getCpfCnpjRaiz() {
        return this.cpfCnpjRaiz;
    }

    @Generated
    public String getFilialCPFCNPJ() {
        return this.filialCPFCNPJ;
    }

    @Generated
    public String getControleCpfCnpj() {
        return this.controleCpfCnpj;
    }

    @Generated
    public String getTipoAcesso() {
        return this.tipoAcesso;
    }

    @Generated
    public String getClubBanco() {
        return this.clubBanco;
    }

    @Generated
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public String getSequenciaContrato() {
        return this.sequenciaContrato;
    }

    @Generated
    public String getIdProduto() {
        return this.idProduto;
    }

    @Generated
    public String getNegociacao() {
        return this.negociacao;
    }

    @Generated
    public String getBanco() {
        return this.banco;
    }

    @Generated
    public String getESequenciaContrato() {
        return this.eSequenciaContrato;
    }

    @Generated
    public String getRegistro() {
        return this.registro;
    }

    @Generated
    public String getProduto() {
        return this.produto;
    }

    @Generated
    public String getTitulo() {
        return this.titulo;
    }

    @Generated
    public String getNumeroCliente() {
        return this.numeroCliente;
    }

    @Generated
    public String getDtEmissaoTitulo() {
        return this.dtEmissaoTitulo;
    }

    @Generated
    public String getDtVencimentoTitulo() {
        return this.dtVencimentoTitulo;
    }

    @Generated
    public String getVencimento() {
        return this.vencimento;
    }

    @Generated
    public String getValorNominalTitulo() {
        return this.valorNominalTitulo;
    }

    @Generated
    public String getEspecieTitulo() {
        return this.especieTitulo;
    }

    @Generated
    public String getProtestoAutomaticoNegativacao() {
        return this.protestoAutomaticoNegativacao;
    }

    @Generated
    public String getPrazoProtestoAutomaticoNegativacao() {
        return this.prazoProtestoAutomaticoNegativacao;
    }

    @Generated
    public String getControleParticipante() {
        return this.controleParticipante;
    }

    @Generated
    public String getPagamentoParcial() {
        return this.pagamentoParcial;
    }

    @Generated
    public String getQtdePagamentoParcial() {
        return this.qtdePagamentoParcial;
    }

    @Generated
    public String getJuros() {
        return this.juros;
    }

    @Generated
    public String getQtdeDiasJuros() {
        return this.qtdeDiasJuros;
    }

    @Generated
    public String getPercentualJuros() {
        return this.percentualJuros;
    }

    @Generated
    public String getMulta() {
        return this.multa;
    }

    @Generated
    public String getQtdeDiasMulta() {
        return this.qtdeDiasMulta;
    }

    @Generated
    public String getPercentualMulta() {
        return this.percentualMulta;
    }

    @Generated
    public String getValorDesconto1() {
        return this.valorDesconto1;
    }

    @Generated
    public String getDataLimiteDesconto1() {
        return this.dataLimiteDesconto1;
    }

    @Generated
    public String getPercentualDesconto1() {
        return this.percentualDesconto1;
    }

    @Generated
    public String getValorDesconto2() {
        return this.valorDesconto2;
    }

    @Generated
    public String getDataLimiteDesconto2() {
        return this.dataLimiteDesconto2;
    }

    @Generated
    public String getPercentualDesconto2() {
        return this.percentualDesconto2;
    }

    @Generated
    public String getValorDesconto3() {
        return this.valorDesconto3;
    }

    @Generated
    public String getDataLimiteDesconto3() {
        return this.dataLimiteDesconto3;
    }

    @Generated
    public String getPercentualDesconto3() {
        return this.percentualDesconto3;
    }

    @Generated
    public String getPrazoBonificacao() {
        return this.prazoBonificacao;
    }

    @Generated
    public String getPercentualBonificacao() {
        return this.percentualBonificacao;
    }

    @Generated
    public String getValorBonificacao() {
        return this.valorBonificacao;
    }

    @Generated
    public String getDtLimiteBonificacao() {
        return this.dtLimiteBonificacao;
    }

    @Generated
    public String getValorAbatimento() {
        return this.valorAbatimento;
    }

    @Generated
    public String getValorIOF() {
        return this.valorIOF;
    }

    @Generated
    public String getNomePagador() {
        return this.nomePagador;
    }

    @Generated
    public String getLogradouroPagador() {
        return this.logradouroPagador;
    }

    @Generated
    public String getNumeroLogradouroPagador() {
        return this.numeroLogradouroPagador;
    }

    @Generated
    public String getComplementoLogradouroPagador() {
        return this.complementoLogradouroPagador;
    }

    @Generated
    public String getCepPagador() {
        return this.cepPagador;
    }

    @Generated
    public String getComplementoCepPagador() {
        return this.complementoCepPagador;
    }

    @Generated
    public String getBairroPagador() {
        return this.bairroPagador;
    }

    @Generated
    public String getMunicipioPagador() {
        return this.municipioPagador;
    }

    @Generated
    public String getUfPagador() {
        return this.ufPagador;
    }

    @Generated
    public String getIndicadorCpfCnpjPagador() {
        return this.indicadorCpfCnpjPagador;
    }

    @Generated
    public String getCpfcnpjPagador() {
        return this.cpfcnpjPagador;
    }

    @Generated
    public String getEnderecoEletronicoPagador() {
        return this.enderecoEletronicoPagador;
    }

    @Generated
    public String getNomeSacadorAvalista() {
        return this.nomeSacadorAvalista;
    }

    @Generated
    public String getLogradouroSacadorAvalista() {
        return this.logradouroSacadorAvalista;
    }

    @Generated
    public String getNumeroLogradouroSacadorAvalista() {
        return this.numeroLogradouroSacadorAvalista;
    }

    @Generated
    public String getComplementoLogradouroSacadorAvalista() {
        return this.complementoLogradouroSacadorAvalista;
    }

    @Generated
    public String getCepSacadorAvalista() {
        return this.cepSacadorAvalista;
    }

    @Generated
    public String getComplementoCepSacadorAvalista() {
        return this.complementoCepSacadorAvalista;
    }

    @Generated
    public String getBairroSacadorAvalista() {
        return this.bairroSacadorAvalista;
    }

    @Generated
    public String getMunicipioSacadorAvalista() {
        return this.municipioSacadorAvalista;
    }

    @Generated
    public String getUfSacadorAvalista() {
        return this.ufSacadorAvalista;
    }

    @Generated
    public String getIndicadorCpfCnpjAvalista() {
        return this.indicadorCpfCnpjAvalista;
    }

    @Generated
    public String getCpfcnpjSacadorAvalista() {
        return this.cpfcnpjSacadorAvalista;
    }

    @Generated
    public String getEnderecoEletronicoSacadorAvalista() {
        return this.enderecoEletronicoSacadorAvalista;
    }

    @Generated
    public void setCpfCnpjRaiz(String cpfCnpjRaiz) {
        this.cpfCnpjRaiz = cpfCnpjRaiz;
    }

    @Generated
    public void setFilialCPFCNPJ(String filialCPFCNPJ) {
        this.filialCPFCNPJ = filialCPFCNPJ;
    }

    @Generated
    public void setControleCpfCnpj(String controleCpfCnpj) {
        this.controleCpfCnpj = controleCpfCnpj;
    }

    @Generated
    public void setTipoAcesso(String tipoAcesso) {
        this.tipoAcesso = tipoAcesso;
    }

    @Generated
    public void setClubBanco(String clubBanco) {
        this.clubBanco = clubBanco;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setSequenciaContrato(String sequenciaContrato) {
        this.sequenciaContrato = sequenciaContrato;
    }

    @Generated
    public void setIdProduto(String idProduto) {
        this.idProduto = idProduto;
    }

    @Generated
    public void setNegociacao(String negociacao) {
        this.negociacao = negociacao;
    }

    @Generated
    public void setBanco(String banco) {
        this.banco = banco;
    }

    @Generated
    public void setESequenciaContrato(String eSequenciaContrato) {
        this.eSequenciaContrato = eSequenciaContrato;
    }

    @Generated
    public void setRegistro(String registro) {
        this.registro = registro;
    }

    @Generated
    public void setProduto(String produto) {
        this.produto = produto;
    }

    @Generated
    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    @Generated
    public void setNumeroCliente(String numeroCliente) {
        this.numeroCliente = numeroCliente;
    }

    @Generated
    public void setDtEmissaoTitulo(String dtEmissaoTitulo) {
        this.dtEmissaoTitulo = dtEmissaoTitulo;
    }

    @Generated
    public void setDtVencimentoTitulo(String dtVencimentoTitulo) {
        this.dtVencimentoTitulo = dtVencimentoTitulo;
    }

    @Generated
    public void setVencimento(String vencimento) {
        this.vencimento = vencimento;
    }

    @Generated
    public void setValorNominalTitulo(String valorNominalTitulo) {
        this.valorNominalTitulo = valorNominalTitulo;
    }

    @Generated
    public void setEspecieTitulo(String especieTitulo) {
        this.especieTitulo = especieTitulo;
    }

    @Generated
    public void setProtestoAutomaticoNegativacao(String protestoAutomaticoNegativacao) {
        this.protestoAutomaticoNegativacao = protestoAutomaticoNegativacao;
    }

    @Generated
    public void setPrazoProtestoAutomaticoNegativacao(String prazoProtestoAutomaticoNegativacao) {
        this.prazoProtestoAutomaticoNegativacao = prazoProtestoAutomaticoNegativacao;
    }

    @Generated
    public void setControleParticipante(String controleParticipante) {
        this.controleParticipante = controleParticipante;
    }

    @Generated
    public void setPagamentoParcial(String pagamentoParcial) {
        this.pagamentoParcial = pagamentoParcial;
    }

    @Generated
    public void setQtdePagamentoParcial(String qtdePagamentoParcial) {
        this.qtdePagamentoParcial = qtdePagamentoParcial;
    }

    @Generated
    public void setJuros(String juros) {
        this.juros = juros;
    }

    @Generated
    public void setQtdeDiasJuros(String qtdeDiasJuros) {
        this.qtdeDiasJuros = qtdeDiasJuros;
    }

    @Generated
    public void setPercentualJuros(String percentualJuros) {
        this.percentualJuros = percentualJuros;
    }

    @Generated
    public void setMulta(String multa) {
        this.multa = multa;
    }

    @Generated
    public void setQtdeDiasMulta(String qtdeDiasMulta) {
        this.qtdeDiasMulta = qtdeDiasMulta;
    }

    @Generated
    public void setPercentualMulta(String percentualMulta) {
        this.percentualMulta = percentualMulta;
    }

    @Generated
    public void setValorDesconto1(String valorDesconto1) {
        this.valorDesconto1 = valorDesconto1;
    }

    @Generated
    public void setDataLimiteDesconto1(String dataLimiteDesconto1) {
        this.dataLimiteDesconto1 = dataLimiteDesconto1;
    }

    @Generated
    public void setPercentualDesconto1(String percentualDesconto1) {
        this.percentualDesconto1 = percentualDesconto1;
    }

    @Generated
    public void setValorDesconto2(String valorDesconto2) {
        this.valorDesconto2 = valorDesconto2;
    }

    @Generated
    public void setDataLimiteDesconto2(String dataLimiteDesconto2) {
        this.dataLimiteDesconto2 = dataLimiteDesconto2;
    }

    @Generated
    public void setPercentualDesconto2(String percentualDesconto2) {
        this.percentualDesconto2 = percentualDesconto2;
    }

    @Generated
    public void setValorDesconto3(String valorDesconto3) {
        this.valorDesconto3 = valorDesconto3;
    }

    @Generated
    public void setDataLimiteDesconto3(String dataLimiteDesconto3) {
        this.dataLimiteDesconto3 = dataLimiteDesconto3;
    }

    @Generated
    public void setPercentualDesconto3(String percentualDesconto3) {
        this.percentualDesconto3 = percentualDesconto3;
    }

    @Generated
    public void setPrazoBonificacao(String prazoBonificacao) {
        this.prazoBonificacao = prazoBonificacao;
    }

    @Generated
    public void setPercentualBonificacao(String percentualBonificacao) {
        this.percentualBonificacao = percentualBonificacao;
    }

    @Generated
    public void setValorBonificacao(String valorBonificacao) {
        this.valorBonificacao = valorBonificacao;
    }

    @Generated
    public void setDtLimiteBonificacao(String dtLimiteBonificacao) {
        this.dtLimiteBonificacao = dtLimiteBonificacao;
    }

    @Generated
    public void setValorAbatimento(String valorAbatimento) {
        this.valorAbatimento = valorAbatimento;
    }

    @Generated
    public void setValorIOF(String valorIOF) {
        this.valorIOF = valorIOF;
    }

    @Generated
    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
    }

    @Generated
    public void setLogradouroPagador(String logradouroPagador) {
        this.logradouroPagador = logradouroPagador;
    }

    @Generated
    public void setNumeroLogradouroPagador(String numeroLogradouroPagador) {
        this.numeroLogradouroPagador = numeroLogradouroPagador;
    }

    @Generated
    public void setComplementoLogradouroPagador(String complementoLogradouroPagador) {
        this.complementoLogradouroPagador = complementoLogradouroPagador;
    }

    @Generated
    public void setCepPagador(String cepPagador) {
        this.cepPagador = cepPagador;
    }

    @Generated
    public void setComplementoCepPagador(String complementoCepPagador) {
        this.complementoCepPagador = complementoCepPagador;
    }

    @Generated
    public void setBairroPagador(String bairroPagador) {
        this.bairroPagador = bairroPagador;
    }

    @Generated
    public void setMunicipioPagador(String municipioPagador) {
        this.municipioPagador = municipioPagador;
    }

    @Generated
    public void setUfPagador(String ufPagador) {
        this.ufPagador = ufPagador;
    }

    @Generated
    public void setIndicadorCpfCnpjPagador(String indicadorCpfCnpjPagador) {
        this.indicadorCpfCnpjPagador = indicadorCpfCnpjPagador;
    }

    @Generated
    public void setCpfcnpjPagador(String cpfcnpjPagador) {
        this.cpfcnpjPagador = cpfcnpjPagador;
    }

    @Generated
    public void setEnderecoEletronicoPagador(String enderecoEletronicoPagador) {
        this.enderecoEletronicoPagador = enderecoEletronicoPagador;
    }

    @Generated
    public void setNomeSacadorAvalista(String nomeSacadorAvalista) {
        this.nomeSacadorAvalista = nomeSacadorAvalista;
    }

    @Generated
    public void setLogradouroSacadorAvalista(String logradouroSacadorAvalista) {
        this.logradouroSacadorAvalista = logradouroSacadorAvalista;
    }

    @Generated
    public void setNumeroLogradouroSacadorAvalista(String numeroLogradouroSacadorAvalista) {
        this.numeroLogradouroSacadorAvalista = numeroLogradouroSacadorAvalista;
    }

    @Generated
    public void setComplementoLogradouroSacadorAvalista(String complementoLogradouroSacadorAvalista) {
        this.complementoLogradouroSacadorAvalista = complementoLogradouroSacadorAvalista;
    }

    @Generated
    public void setCepSacadorAvalista(String cepSacadorAvalista) {
        this.cepSacadorAvalista = cepSacadorAvalista;
    }

    @Generated
    public void setComplementoCepSacadorAvalista(String complementoCepSacadorAvalista) {
        this.complementoCepSacadorAvalista = complementoCepSacadorAvalista;
    }

    @Generated
    public void setBairroSacadorAvalista(String bairroSacadorAvalista) {
        this.bairroSacadorAvalista = bairroSacadorAvalista;
    }

    @Generated
    public void setMunicipioSacadorAvalista(String municipioSacadorAvalista) {
        this.municipioSacadorAvalista = municipioSacadorAvalista;
    }

    @Generated
    public void setUfSacadorAvalista(String ufSacadorAvalista) {
        this.ufSacadorAvalista = ufSacadorAvalista;
    }

    @Generated
    public void setIndicadorCpfCnpjAvalista(String indicadorCpfCnpjAvalista) {
        this.indicadorCpfCnpjAvalista = indicadorCpfCnpjAvalista;
    }

    @Generated
    public void setCpfcnpjSacadorAvalista(String cpfcnpjSacadorAvalista) {
        this.cpfcnpjSacadorAvalista = cpfcnpjSacadorAvalista;
    }

    @Generated
    public void setEnderecoEletronicoSacadorAvalista(String enderecoEletronicoSacadorAvalista) {
        this.enderecoEletronicoSacadorAvalista = enderecoEletronicoSacadorAvalista;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoBradescoDTO)) {
            return false;
        }
        EmissaoBoletoBradescoDTO other = (EmissaoBoletoBradescoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cpfCnpjRaiz = this.getCpfCnpjRaiz();
        String other$cpfCnpjRaiz = other.getCpfCnpjRaiz();
        if (this$cpfCnpjRaiz == null ? other$cpfCnpjRaiz != null : !this$cpfCnpjRaiz.equals(other$cpfCnpjRaiz)) {
            return false;
        }
        String this$filialCPFCNPJ = this.getFilialCPFCNPJ();
        String other$filialCPFCNPJ = other.getFilialCPFCNPJ();
        if (this$filialCPFCNPJ == null ? other$filialCPFCNPJ != null : !this$filialCPFCNPJ.equals(other$filialCPFCNPJ)) {
            return false;
        }
        String this$controleCpfCnpj = this.getControleCpfCnpj();
        String other$controleCpfCnpj = other.getControleCpfCnpj();
        if (this$controleCpfCnpj == null ? other$controleCpfCnpj != null : !this$controleCpfCnpj.equals(other$controleCpfCnpj)) {
            return false;
        }
        String this$tipoAcesso = this.getTipoAcesso();
        String other$tipoAcesso = other.getTipoAcesso();
        if (this$tipoAcesso == null ? other$tipoAcesso != null : !this$tipoAcesso.equals(other$tipoAcesso)) {
            return false;
        }
        String this$clubBanco = this.getClubBanco();
        String other$clubBanco = other.getClubBanco();
        if (this$clubBanco == null ? other$clubBanco != null : !this$clubBanco.equals(other$clubBanco)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        String this$sequenciaContrato = this.getSequenciaContrato();
        String other$sequenciaContrato = other.getSequenciaContrato();
        if (this$sequenciaContrato == null ? other$sequenciaContrato != null : !this$sequenciaContrato.equals(other$sequenciaContrato)) {
            return false;
        }
        String this$idProduto = this.getIdProduto();
        String other$idProduto = other.getIdProduto();
        if (this$idProduto == null ? other$idProduto != null : !this$idProduto.equals(other$idProduto)) {
            return false;
        }
        String this$negociacao = this.getNegociacao();
        String other$negociacao = other.getNegociacao();
        if (this$negociacao == null ? other$negociacao != null : !this$negociacao.equals(other$negociacao)) {
            return false;
        }
        String this$banco = this.getBanco();
        String other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !this$banco.equals(other$banco)) {
            return false;
        }
        String this$eSequenciaContrato = this.getESequenciaContrato();
        String other$eSequenciaContrato = other.getESequenciaContrato();
        if (this$eSequenciaContrato == null ? other$eSequenciaContrato != null : !this$eSequenciaContrato.equals(other$eSequenciaContrato)) {
            return false;
        }
        String this$registro = this.getRegistro();
        String other$registro = other.getRegistro();
        if (this$registro == null ? other$registro != null : !this$registro.equals(other$registro)) {
            return false;
        }
        String this$produto = this.getProduto();
        String other$produto = other.getProduto();
        if (this$produto == null ? other$produto != null : !this$produto.equals(other$produto)) {
            return false;
        }
        String this$titulo = this.getTitulo();
        String other$titulo = other.getTitulo();
        if (this$titulo == null ? other$titulo != null : !this$titulo.equals(other$titulo)) {
            return false;
        }
        String this$numeroCliente = this.getNumeroCliente();
        String other$numeroCliente = other.getNumeroCliente();
        if (this$numeroCliente == null ? other$numeroCliente != null : !this$numeroCliente.equals(other$numeroCliente)) {
            return false;
        }
        String this$dtEmissaoTitulo = this.getDtEmissaoTitulo();
        String other$dtEmissaoTitulo = other.getDtEmissaoTitulo();
        if (this$dtEmissaoTitulo == null ? other$dtEmissaoTitulo != null : !this$dtEmissaoTitulo.equals(other$dtEmissaoTitulo)) {
            return false;
        }
        String this$dtVencimentoTitulo = this.getDtVencimentoTitulo();
        String other$dtVencimentoTitulo = other.getDtVencimentoTitulo();
        if (this$dtVencimentoTitulo == null ? other$dtVencimentoTitulo != null : !this$dtVencimentoTitulo.equals(other$dtVencimentoTitulo)) {
            return false;
        }
        String this$vencimento = this.getVencimento();
        String other$vencimento = other.getVencimento();
        if (this$vencimento == null ? other$vencimento != null : !this$vencimento.equals(other$vencimento)) {
            return false;
        }
        String this$valorNominalTitulo = this.getValorNominalTitulo();
        String other$valorNominalTitulo = other.getValorNominalTitulo();
        if (this$valorNominalTitulo == null ? other$valorNominalTitulo != null : !this$valorNominalTitulo.equals(other$valorNominalTitulo)) {
            return false;
        }
        String this$especieTitulo = this.getEspecieTitulo();
        String other$especieTitulo = other.getEspecieTitulo();
        if (this$especieTitulo == null ? other$especieTitulo != null : !this$especieTitulo.equals(other$especieTitulo)) {
            return false;
        }
        String this$protestoAutomaticoNegativacao = this.getProtestoAutomaticoNegativacao();
        String other$protestoAutomaticoNegativacao = other.getProtestoAutomaticoNegativacao();
        if (this$protestoAutomaticoNegativacao == null ? other$protestoAutomaticoNegativacao != null : !this$protestoAutomaticoNegativacao.equals(other$protestoAutomaticoNegativacao)) {
            return false;
        }
        String this$prazoProtestoAutomaticoNegativacao = this.getPrazoProtestoAutomaticoNegativacao();
        String other$prazoProtestoAutomaticoNegativacao = other.getPrazoProtestoAutomaticoNegativacao();
        if (this$prazoProtestoAutomaticoNegativacao == null ? other$prazoProtestoAutomaticoNegativacao != null : !this$prazoProtestoAutomaticoNegativacao.equals(other$prazoProtestoAutomaticoNegativacao)) {
            return false;
        }
        String this$controleParticipante = this.getControleParticipante();
        String other$controleParticipante = other.getControleParticipante();
        if (this$controleParticipante == null ? other$controleParticipante != null : !this$controleParticipante.equals(other$controleParticipante)) {
            return false;
        }
        String this$pagamentoParcial = this.getPagamentoParcial();
        String other$pagamentoParcial = other.getPagamentoParcial();
        if (this$pagamentoParcial == null ? other$pagamentoParcial != null : !this$pagamentoParcial.equals(other$pagamentoParcial)) {
            return false;
        }
        String this$qtdePagamentoParcial = this.getQtdePagamentoParcial();
        String other$qtdePagamentoParcial = other.getQtdePagamentoParcial();
        if (this$qtdePagamentoParcial == null ? other$qtdePagamentoParcial != null : !this$qtdePagamentoParcial.equals(other$qtdePagamentoParcial)) {
            return false;
        }
        String this$juros = this.getJuros();
        String other$juros = other.getJuros();
        if (this$juros == null ? other$juros != null : !this$juros.equals(other$juros)) {
            return false;
        }
        String this$qtdeDiasJuros = this.getQtdeDiasJuros();
        String other$qtdeDiasJuros = other.getQtdeDiasJuros();
        if (this$qtdeDiasJuros == null ? other$qtdeDiasJuros != null : !this$qtdeDiasJuros.equals(other$qtdeDiasJuros)) {
            return false;
        }
        String this$percentualJuros = this.getPercentualJuros();
        String other$percentualJuros = other.getPercentualJuros();
        if (this$percentualJuros == null ? other$percentualJuros != null : !this$percentualJuros.equals(other$percentualJuros)) {
            return false;
        }
        String this$multa = this.getMulta();
        String other$multa = other.getMulta();
        if (this$multa == null ? other$multa != null : !this$multa.equals(other$multa)) {
            return false;
        }
        String this$qtdeDiasMulta = this.getQtdeDiasMulta();
        String other$qtdeDiasMulta = other.getQtdeDiasMulta();
        if (this$qtdeDiasMulta == null ? other$qtdeDiasMulta != null : !this$qtdeDiasMulta.equals(other$qtdeDiasMulta)) {
            return false;
        }
        String this$percentualMulta = this.getPercentualMulta();
        String other$percentualMulta = other.getPercentualMulta();
        if (this$percentualMulta == null ? other$percentualMulta != null : !this$percentualMulta.equals(other$percentualMulta)) {
            return false;
        }
        String this$valorDesconto1 = this.getValorDesconto1();
        String other$valorDesconto1 = other.getValorDesconto1();
        if (this$valorDesconto1 == null ? other$valorDesconto1 != null : !this$valorDesconto1.equals(other$valorDesconto1)) {
            return false;
        }
        String this$dataLimiteDesconto1 = this.getDataLimiteDesconto1();
        String other$dataLimiteDesconto1 = other.getDataLimiteDesconto1();
        if (this$dataLimiteDesconto1 == null ? other$dataLimiteDesconto1 != null : !this$dataLimiteDesconto1.equals(other$dataLimiteDesconto1)) {
            return false;
        }
        String this$percentualDesconto1 = this.getPercentualDesconto1();
        String other$percentualDesconto1 = other.getPercentualDesconto1();
        if (this$percentualDesconto1 == null ? other$percentualDesconto1 != null : !this$percentualDesconto1.equals(other$percentualDesconto1)) {
            return false;
        }
        String this$valorDesconto2 = this.getValorDesconto2();
        String other$valorDesconto2 = other.getValorDesconto2();
        if (this$valorDesconto2 == null ? other$valorDesconto2 != null : !this$valorDesconto2.equals(other$valorDesconto2)) {
            return false;
        }
        String this$dataLimiteDesconto2 = this.getDataLimiteDesconto2();
        String other$dataLimiteDesconto2 = other.getDataLimiteDesconto2();
        if (this$dataLimiteDesconto2 == null ? other$dataLimiteDesconto2 != null : !this$dataLimiteDesconto2.equals(other$dataLimiteDesconto2)) {
            return false;
        }
        String this$percentualDesconto2 = this.getPercentualDesconto2();
        String other$percentualDesconto2 = other.getPercentualDesconto2();
        if (this$percentualDesconto2 == null ? other$percentualDesconto2 != null : !this$percentualDesconto2.equals(other$percentualDesconto2)) {
            return false;
        }
        String this$valorDesconto3 = this.getValorDesconto3();
        String other$valorDesconto3 = other.getValorDesconto3();
        if (this$valorDesconto3 == null ? other$valorDesconto3 != null : !this$valorDesconto3.equals(other$valorDesconto3)) {
            return false;
        }
        String this$dataLimiteDesconto3 = this.getDataLimiteDesconto3();
        String other$dataLimiteDesconto3 = other.getDataLimiteDesconto3();
        if (this$dataLimiteDesconto3 == null ? other$dataLimiteDesconto3 != null : !this$dataLimiteDesconto3.equals(other$dataLimiteDesconto3)) {
            return false;
        }
        String this$percentualDesconto3 = this.getPercentualDesconto3();
        String other$percentualDesconto3 = other.getPercentualDesconto3();
        if (this$percentualDesconto3 == null ? other$percentualDesconto3 != null : !this$percentualDesconto3.equals(other$percentualDesconto3)) {
            return false;
        }
        String this$prazoBonificacao = this.getPrazoBonificacao();
        String other$prazoBonificacao = other.getPrazoBonificacao();
        if (this$prazoBonificacao == null ? other$prazoBonificacao != null : !this$prazoBonificacao.equals(other$prazoBonificacao)) {
            return false;
        }
        String this$percentualBonificacao = this.getPercentualBonificacao();
        String other$percentualBonificacao = other.getPercentualBonificacao();
        if (this$percentualBonificacao == null ? other$percentualBonificacao != null : !this$percentualBonificacao.equals(other$percentualBonificacao)) {
            return false;
        }
        String this$valorBonificacao = this.getValorBonificacao();
        String other$valorBonificacao = other.getValorBonificacao();
        if (this$valorBonificacao == null ? other$valorBonificacao != null : !this$valorBonificacao.equals(other$valorBonificacao)) {
            return false;
        }
        String this$dtLimiteBonificacao = this.getDtLimiteBonificacao();
        String other$dtLimiteBonificacao = other.getDtLimiteBonificacao();
        if (this$dtLimiteBonificacao == null ? other$dtLimiteBonificacao != null : !this$dtLimiteBonificacao.equals(other$dtLimiteBonificacao)) {
            return false;
        }
        String this$valorAbatimento = this.getValorAbatimento();
        String other$valorAbatimento = other.getValorAbatimento();
        if (this$valorAbatimento == null ? other$valorAbatimento != null : !this$valorAbatimento.equals(other$valorAbatimento)) {
            return false;
        }
        String this$valorIOF = this.getValorIOF();
        String other$valorIOF = other.getValorIOF();
        if (this$valorIOF == null ? other$valorIOF != null : !this$valorIOF.equals(other$valorIOF)) {
            return false;
        }
        String this$nomePagador = this.getNomePagador();
        String other$nomePagador = other.getNomePagador();
        if (this$nomePagador == null ? other$nomePagador != null : !this$nomePagador.equals(other$nomePagador)) {
            return false;
        }
        String this$logradouroPagador = this.getLogradouroPagador();
        String other$logradouroPagador = other.getLogradouroPagador();
        if (this$logradouroPagador == null ? other$logradouroPagador != null : !this$logradouroPagador.equals(other$logradouroPagador)) {
            return false;
        }
        String this$numeroLogradouroPagador = this.getNumeroLogradouroPagador();
        String other$numeroLogradouroPagador = other.getNumeroLogradouroPagador();
        if (this$numeroLogradouroPagador == null ? other$numeroLogradouroPagador != null : !this$numeroLogradouroPagador.equals(other$numeroLogradouroPagador)) {
            return false;
        }
        String this$complementoLogradouroPagador = this.getComplementoLogradouroPagador();
        String other$complementoLogradouroPagador = other.getComplementoLogradouroPagador();
        if (this$complementoLogradouroPagador == null ? other$complementoLogradouroPagador != null : !this$complementoLogradouroPagador.equals(other$complementoLogradouroPagador)) {
            return false;
        }
        String this$cepPagador = this.getCepPagador();
        String other$cepPagador = other.getCepPagador();
        if (this$cepPagador == null ? other$cepPagador != null : !this$cepPagador.equals(other$cepPagador)) {
            return false;
        }
        String this$complementoCepPagador = this.getComplementoCepPagador();
        String other$complementoCepPagador = other.getComplementoCepPagador();
        if (this$complementoCepPagador == null ? other$complementoCepPagador != null : !this$complementoCepPagador.equals(other$complementoCepPagador)) {
            return false;
        }
        String this$bairroPagador = this.getBairroPagador();
        String other$bairroPagador = other.getBairroPagador();
        if (this$bairroPagador == null ? other$bairroPagador != null : !this$bairroPagador.equals(other$bairroPagador)) {
            return false;
        }
        String this$municipioPagador = this.getMunicipioPagador();
        String other$municipioPagador = other.getMunicipioPagador();
        if (this$municipioPagador == null ? other$municipioPagador != null : !this$municipioPagador.equals(other$municipioPagador)) {
            return false;
        }
        String this$ufPagador = this.getUfPagador();
        String other$ufPagador = other.getUfPagador();
        if (this$ufPagador == null ? other$ufPagador != null : !this$ufPagador.equals(other$ufPagador)) {
            return false;
        }
        String this$indicadorCpfCnpjPagador = this.getIndicadorCpfCnpjPagador();
        String other$indicadorCpfCnpjPagador = other.getIndicadorCpfCnpjPagador();
        if (this$indicadorCpfCnpjPagador == null ? other$indicadorCpfCnpjPagador != null : !this$indicadorCpfCnpjPagador.equals(other$indicadorCpfCnpjPagador)) {
            return false;
        }
        String this$cpfcnpjPagador = this.getCpfcnpjPagador();
        String other$cpfcnpjPagador = other.getCpfcnpjPagador();
        if (this$cpfcnpjPagador == null ? other$cpfcnpjPagador != null : !this$cpfcnpjPagador.equals(other$cpfcnpjPagador)) {
            return false;
        }
        String this$enderecoEletronicoPagador = this.getEnderecoEletronicoPagador();
        String other$enderecoEletronicoPagador = other.getEnderecoEletronicoPagador();
        if (this$enderecoEletronicoPagador == null ? other$enderecoEletronicoPagador != null : !this$enderecoEletronicoPagador.equals(other$enderecoEletronicoPagador)) {
            return false;
        }
        String this$nomeSacadorAvalista = this.getNomeSacadorAvalista();
        String other$nomeSacadorAvalista = other.getNomeSacadorAvalista();
        if (this$nomeSacadorAvalista == null ? other$nomeSacadorAvalista != null : !this$nomeSacadorAvalista.equals(other$nomeSacadorAvalista)) {
            return false;
        }
        String this$logradouroSacadorAvalista = this.getLogradouroSacadorAvalista();
        String other$logradouroSacadorAvalista = other.getLogradouroSacadorAvalista();
        if (this$logradouroSacadorAvalista == null ? other$logradouroSacadorAvalista != null : !this$logradouroSacadorAvalista.equals(other$logradouroSacadorAvalista)) {
            return false;
        }
        String this$numeroLogradouroSacadorAvalista = this.getNumeroLogradouroSacadorAvalista();
        String other$numeroLogradouroSacadorAvalista = other.getNumeroLogradouroSacadorAvalista();
        if (this$numeroLogradouroSacadorAvalista == null ? other$numeroLogradouroSacadorAvalista != null : !this$numeroLogradouroSacadorAvalista.equals(other$numeroLogradouroSacadorAvalista)) {
            return false;
        }
        String this$complementoLogradouroSacadorAvalista = this.getComplementoLogradouroSacadorAvalista();
        String other$complementoLogradouroSacadorAvalista = other.getComplementoLogradouroSacadorAvalista();
        if (this$complementoLogradouroSacadorAvalista == null ? other$complementoLogradouroSacadorAvalista != null : !this$complementoLogradouroSacadorAvalista.equals(other$complementoLogradouroSacadorAvalista)) {
            return false;
        }
        String this$cepSacadorAvalista = this.getCepSacadorAvalista();
        String other$cepSacadorAvalista = other.getCepSacadorAvalista();
        if (this$cepSacadorAvalista == null ? other$cepSacadorAvalista != null : !this$cepSacadorAvalista.equals(other$cepSacadorAvalista)) {
            return false;
        }
        String this$complementoCepSacadorAvalista = this.getComplementoCepSacadorAvalista();
        String other$complementoCepSacadorAvalista = other.getComplementoCepSacadorAvalista();
        if (this$complementoCepSacadorAvalista == null ? other$complementoCepSacadorAvalista != null : !this$complementoCepSacadorAvalista.equals(other$complementoCepSacadorAvalista)) {
            return false;
        }
        String this$bairroSacadorAvalista = this.getBairroSacadorAvalista();
        String other$bairroSacadorAvalista = other.getBairroSacadorAvalista();
        if (this$bairroSacadorAvalista == null ? other$bairroSacadorAvalista != null : !this$bairroSacadorAvalista.equals(other$bairroSacadorAvalista)) {
            return false;
        }
        String this$municipioSacadorAvalista = this.getMunicipioSacadorAvalista();
        String other$municipioSacadorAvalista = other.getMunicipioSacadorAvalista();
        if (this$municipioSacadorAvalista == null ? other$municipioSacadorAvalista != null : !this$municipioSacadorAvalista.equals(other$municipioSacadorAvalista)) {
            return false;
        }
        String this$ufSacadorAvalista = this.getUfSacadorAvalista();
        String other$ufSacadorAvalista = other.getUfSacadorAvalista();
        if (this$ufSacadorAvalista == null ? other$ufSacadorAvalista != null : !this$ufSacadorAvalista.equals(other$ufSacadorAvalista)) {
            return false;
        }
        String this$indicadorCpfCnpjAvalista = this.getIndicadorCpfCnpjAvalista();
        String other$indicadorCpfCnpjAvalista = other.getIndicadorCpfCnpjAvalista();
        if (this$indicadorCpfCnpjAvalista == null ? other$indicadorCpfCnpjAvalista != null : !this$indicadorCpfCnpjAvalista.equals(other$indicadorCpfCnpjAvalista)) {
            return false;
        }
        String this$cpfcnpjSacadorAvalista = this.getCpfcnpjSacadorAvalista();
        String other$cpfcnpjSacadorAvalista = other.getCpfcnpjSacadorAvalista();
        if (this$cpfcnpjSacadorAvalista == null ? other$cpfcnpjSacadorAvalista != null : !this$cpfcnpjSacadorAvalista.equals(other$cpfcnpjSacadorAvalista)) {
            return false;
        }
        String this$enderecoEletronicoSacadorAvalista = this.getEnderecoEletronicoSacadorAvalista();
        String other$enderecoEletronicoSacadorAvalista = other.getEnderecoEletronicoSacadorAvalista();
        return !(this$enderecoEletronicoSacadorAvalista == null ? other$enderecoEletronicoSacadorAvalista != null : !this$enderecoEletronicoSacadorAvalista.equals(other$enderecoEletronicoSacadorAvalista));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoBradescoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cpfCnpjRaiz = this.getCpfCnpjRaiz();
        result = result * 59 + ($cpfCnpjRaiz == null ? 43 : $cpfCnpjRaiz.hashCode());
        String $filialCPFCNPJ = this.getFilialCPFCNPJ();
        result = result * 59 + ($filialCPFCNPJ == null ? 43 : $filialCPFCNPJ.hashCode());
        String $controleCpfCnpj = this.getControleCpfCnpj();
        result = result * 59 + ($controleCpfCnpj == null ? 43 : $controleCpfCnpj.hashCode());
        String $tipoAcesso = this.getTipoAcesso();
        result = result * 59 + ($tipoAcesso == null ? 43 : $tipoAcesso.hashCode());
        String $clubBanco = this.getClubBanco();
        result = result * 59 + ($clubBanco == null ? 43 : $clubBanco.hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        String $sequenciaContrato = this.getSequenciaContrato();
        result = result * 59 + ($sequenciaContrato == null ? 43 : $sequenciaContrato.hashCode());
        String $idProduto = this.getIdProduto();
        result = result * 59 + ($idProduto == null ? 43 : $idProduto.hashCode());
        String $negociacao = this.getNegociacao();
        result = result * 59 + ($negociacao == null ? 43 : $negociacao.hashCode());
        String $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : $banco.hashCode());
        String $eSequenciaContrato = this.getESequenciaContrato();
        result = result * 59 + ($eSequenciaContrato == null ? 43 : $eSequenciaContrato.hashCode());
        String $registro = this.getRegistro();
        result = result * 59 + ($registro == null ? 43 : $registro.hashCode());
        String $produto = this.getProduto();
        result = result * 59 + ($produto == null ? 43 : $produto.hashCode());
        String $titulo = this.getTitulo();
        result = result * 59 + ($titulo == null ? 43 : $titulo.hashCode());
        String $numeroCliente = this.getNumeroCliente();
        result = result * 59 + ($numeroCliente == null ? 43 : $numeroCliente.hashCode());
        String $dtEmissaoTitulo = this.getDtEmissaoTitulo();
        result = result * 59 + ($dtEmissaoTitulo == null ? 43 : $dtEmissaoTitulo.hashCode());
        String $dtVencimentoTitulo = this.getDtVencimentoTitulo();
        result = result * 59 + ($dtVencimentoTitulo == null ? 43 : $dtVencimentoTitulo.hashCode());
        String $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : $vencimento.hashCode());
        String $valorNominalTitulo = this.getValorNominalTitulo();
        result = result * 59 + ($valorNominalTitulo == null ? 43 : $valorNominalTitulo.hashCode());
        String $especieTitulo = this.getEspecieTitulo();
        result = result * 59 + ($especieTitulo == null ? 43 : $especieTitulo.hashCode());
        String $protestoAutomaticoNegativacao = this.getProtestoAutomaticoNegativacao();
        result = result * 59 + ($protestoAutomaticoNegativacao == null ? 43 : $protestoAutomaticoNegativacao.hashCode());
        String $prazoProtestoAutomaticoNegativacao = this.getPrazoProtestoAutomaticoNegativacao();
        result = result * 59 + ($prazoProtestoAutomaticoNegativacao == null ? 43 : $prazoProtestoAutomaticoNegativacao.hashCode());
        String $controleParticipante = this.getControleParticipante();
        result = result * 59 + ($controleParticipante == null ? 43 : $controleParticipante.hashCode());
        String $pagamentoParcial = this.getPagamentoParcial();
        result = result * 59 + ($pagamentoParcial == null ? 43 : $pagamentoParcial.hashCode());
        String $qtdePagamentoParcial = this.getQtdePagamentoParcial();
        result = result * 59 + ($qtdePagamentoParcial == null ? 43 : $qtdePagamentoParcial.hashCode());
        String $juros = this.getJuros();
        result = result * 59 + ($juros == null ? 43 : $juros.hashCode());
        String $qtdeDiasJuros = this.getQtdeDiasJuros();
        result = result * 59 + ($qtdeDiasJuros == null ? 43 : $qtdeDiasJuros.hashCode());
        String $percentualJuros = this.getPercentualJuros();
        result = result * 59 + ($percentualJuros == null ? 43 : $percentualJuros.hashCode());
        String $multa = this.getMulta();
        result = result * 59 + ($multa == null ? 43 : $multa.hashCode());
        String $qtdeDiasMulta = this.getQtdeDiasMulta();
        result = result * 59 + ($qtdeDiasMulta == null ? 43 : $qtdeDiasMulta.hashCode());
        String $percentualMulta = this.getPercentualMulta();
        result = result * 59 + ($percentualMulta == null ? 43 : $percentualMulta.hashCode());
        String $valorDesconto1 = this.getValorDesconto1();
        result = result * 59 + ($valorDesconto1 == null ? 43 : $valorDesconto1.hashCode());
        String $dataLimiteDesconto1 = this.getDataLimiteDesconto1();
        result = result * 59 + ($dataLimiteDesconto1 == null ? 43 : $dataLimiteDesconto1.hashCode());
        String $percentualDesconto1 = this.getPercentualDesconto1();
        result = result * 59 + ($percentualDesconto1 == null ? 43 : $percentualDesconto1.hashCode());
        String $valorDesconto2 = this.getValorDesconto2();
        result = result * 59 + ($valorDesconto2 == null ? 43 : $valorDesconto2.hashCode());
        String $dataLimiteDesconto2 = this.getDataLimiteDesconto2();
        result = result * 59 + ($dataLimiteDesconto2 == null ? 43 : $dataLimiteDesconto2.hashCode());
        String $percentualDesconto2 = this.getPercentualDesconto2();
        result = result * 59 + ($percentualDesconto2 == null ? 43 : $percentualDesconto2.hashCode());
        String $valorDesconto3 = this.getValorDesconto3();
        result = result * 59 + ($valorDesconto3 == null ? 43 : $valorDesconto3.hashCode());
        String $dataLimiteDesconto3 = this.getDataLimiteDesconto3();
        result = result * 59 + ($dataLimiteDesconto3 == null ? 43 : $dataLimiteDesconto3.hashCode());
        String $percentualDesconto3 = this.getPercentualDesconto3();
        result = result * 59 + ($percentualDesconto3 == null ? 43 : $percentualDesconto3.hashCode());
        String $prazoBonificacao = this.getPrazoBonificacao();
        result = result * 59 + ($prazoBonificacao == null ? 43 : $prazoBonificacao.hashCode());
        String $percentualBonificacao = this.getPercentualBonificacao();
        result = result * 59 + ($percentualBonificacao == null ? 43 : $percentualBonificacao.hashCode());
        String $valorBonificacao = this.getValorBonificacao();
        result = result * 59 + ($valorBonificacao == null ? 43 : $valorBonificacao.hashCode());
        String $dtLimiteBonificacao = this.getDtLimiteBonificacao();
        result = result * 59 + ($dtLimiteBonificacao == null ? 43 : $dtLimiteBonificacao.hashCode());
        String $valorAbatimento = this.getValorAbatimento();
        result = result * 59 + ($valorAbatimento == null ? 43 : $valorAbatimento.hashCode());
        String $valorIOF = this.getValorIOF();
        result = result * 59 + ($valorIOF == null ? 43 : $valorIOF.hashCode());
        String $nomePagador = this.getNomePagador();
        result = result * 59 + ($nomePagador == null ? 43 : $nomePagador.hashCode());
        String $logradouroPagador = this.getLogradouroPagador();
        result = result * 59 + ($logradouroPagador == null ? 43 : $logradouroPagador.hashCode());
        String $numeroLogradouroPagador = this.getNumeroLogradouroPagador();
        result = result * 59 + ($numeroLogradouroPagador == null ? 43 : $numeroLogradouroPagador.hashCode());
        String $complementoLogradouroPagador = this.getComplementoLogradouroPagador();
        result = result * 59 + ($complementoLogradouroPagador == null ? 43 : $complementoLogradouroPagador.hashCode());
        String $cepPagador = this.getCepPagador();
        result = result * 59 + ($cepPagador == null ? 43 : $cepPagador.hashCode());
        String $complementoCepPagador = this.getComplementoCepPagador();
        result = result * 59 + ($complementoCepPagador == null ? 43 : $complementoCepPagador.hashCode());
        String $bairroPagador = this.getBairroPagador();
        result = result * 59 + ($bairroPagador == null ? 43 : $bairroPagador.hashCode());
        String $municipioPagador = this.getMunicipioPagador();
        result = result * 59 + ($municipioPagador == null ? 43 : $municipioPagador.hashCode());
        String $ufPagador = this.getUfPagador();
        result = result * 59 + ($ufPagador == null ? 43 : $ufPagador.hashCode());
        String $indicadorCpfCnpjPagador = this.getIndicadorCpfCnpjPagador();
        result = result * 59 + ($indicadorCpfCnpjPagador == null ? 43 : $indicadorCpfCnpjPagador.hashCode());
        String $cpfcnpjPagador = this.getCpfcnpjPagador();
        result = result * 59 + ($cpfcnpjPagador == null ? 43 : $cpfcnpjPagador.hashCode());
        String $enderecoEletronicoPagador = this.getEnderecoEletronicoPagador();
        result = result * 59 + ($enderecoEletronicoPagador == null ? 43 : $enderecoEletronicoPagador.hashCode());
        String $nomeSacadorAvalista = this.getNomeSacadorAvalista();
        result = result * 59 + ($nomeSacadorAvalista == null ? 43 : $nomeSacadorAvalista.hashCode());
        String $logradouroSacadorAvalista = this.getLogradouroSacadorAvalista();
        result = result * 59 + ($logradouroSacadorAvalista == null ? 43 : $logradouroSacadorAvalista.hashCode());
        String $numeroLogradouroSacadorAvalista = this.getNumeroLogradouroSacadorAvalista();
        result = result * 59 + ($numeroLogradouroSacadorAvalista == null ? 43 : $numeroLogradouroSacadorAvalista.hashCode());
        String $complementoLogradouroSacadorAvalista = this.getComplementoLogradouroSacadorAvalista();
        result = result * 59 + ($complementoLogradouroSacadorAvalista == null ? 43 : $complementoLogradouroSacadorAvalista.hashCode());
        String $cepSacadorAvalista = this.getCepSacadorAvalista();
        result = result * 59 + ($cepSacadorAvalista == null ? 43 : $cepSacadorAvalista.hashCode());
        String $complementoCepSacadorAvalista = this.getComplementoCepSacadorAvalista();
        result = result * 59 + ($complementoCepSacadorAvalista == null ? 43 : $complementoCepSacadorAvalista.hashCode());
        String $bairroSacadorAvalista = this.getBairroSacadorAvalista();
        result = result * 59 + ($bairroSacadorAvalista == null ? 43 : $bairroSacadorAvalista.hashCode());
        String $municipioSacadorAvalista = this.getMunicipioSacadorAvalista();
        result = result * 59 + ($municipioSacadorAvalista == null ? 43 : $municipioSacadorAvalista.hashCode());
        String $ufSacadorAvalista = this.getUfSacadorAvalista();
        result = result * 59 + ($ufSacadorAvalista == null ? 43 : $ufSacadorAvalista.hashCode());
        String $indicadorCpfCnpjAvalista = this.getIndicadorCpfCnpjAvalista();
        result = result * 59 + ($indicadorCpfCnpjAvalista == null ? 43 : $indicadorCpfCnpjAvalista.hashCode());
        String $cpfcnpjSacadorAvalista = this.getCpfcnpjSacadorAvalista();
        result = result * 59 + ($cpfcnpjSacadorAvalista == null ? 43 : $cpfcnpjSacadorAvalista.hashCode());
        String $enderecoEletronicoSacadorAvalista = this.getEnderecoEletronicoSacadorAvalista();
        result = result * 59 + ($enderecoEletronicoSacadorAvalista == null ? 43 : $enderecoEletronicoSacadorAvalista.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoBradescoDTO(cpfCnpjRaiz=" + this.getCpfCnpjRaiz() + ", filialCPFCNPJ=" + this.getFilialCPFCNPJ() + ", controleCpfCnpj=" + this.getControleCpfCnpj() + ", tipoAcesso=" + this.getTipoAcesso() + ", clubBanco=" + this.getClubBanco() + ", tipoContrato=" + this.getTipoContrato() + ", sequenciaContrato=" + this.getSequenciaContrato() + ", idProduto=" + this.getIdProduto() + ", negociacao=" + this.getNegociacao() + ", banco=" + this.getBanco() + ", eSequenciaContrato=" + this.getESequenciaContrato() + ", registro=" + this.getRegistro() + ", produto=" + this.getProduto() + ", titulo=" + this.getTitulo() + ", numeroCliente=" + this.getNumeroCliente() + ", dtEmissaoTitulo=" + this.getDtEmissaoTitulo() + ", dtVencimentoTitulo=" + this.getDtVencimentoTitulo() + ", vencimento=" + this.getVencimento() + ", valorNominalTitulo=" + this.getValorNominalTitulo() + ", especieTitulo=" + this.getEspecieTitulo() + ", protestoAutomaticoNegativacao=" + this.getProtestoAutomaticoNegativacao() + ", prazoProtestoAutomaticoNegativacao=" + this.getPrazoProtestoAutomaticoNegativacao() + ", controleParticipante=" + this.getControleParticipante() + ", pagamentoParcial=" + this.getPagamentoParcial() + ", qtdePagamentoParcial=" + this.getQtdePagamentoParcial() + ", juros=" + this.getJuros() + ", qtdeDiasJuros=" + this.getQtdeDiasJuros() + ", percentualJuros=" + this.getPercentualJuros() + ", multa=" + this.getMulta() + ", qtdeDiasMulta=" + this.getQtdeDiasMulta() + ", percentualMulta=" + this.getPercentualMulta() + ", valorDesconto1=" + this.getValorDesconto1() + ", dataLimiteDesconto1=" + this.getDataLimiteDesconto1() + ", percentualDesconto1=" + this.getPercentualDesconto1() + ", valorDesconto2=" + this.getValorDesconto2() + ", dataLimiteDesconto2=" + this.getDataLimiteDesconto2() + ", percentualDesconto2=" + this.getPercentualDesconto2() + ", valorDesconto3=" + this.getValorDesconto3() + ", dataLimiteDesconto3=" + this.getDataLimiteDesconto3() + ", percentualDesconto3=" + this.getPercentualDesconto3() + ", prazoBonificacao=" + this.getPrazoBonificacao() + ", percentualBonificacao=" + this.getPercentualBonificacao() + ", valorBonificacao=" + this.getValorBonificacao() + ", dtLimiteBonificacao=" + this.getDtLimiteBonificacao() + ", valorAbatimento=" + this.getValorAbatimento() + ", valorIOF=" + this.getValorIOF() + ", nomePagador=" + this.getNomePagador() + ", logradouroPagador=" + this.getLogradouroPagador() + ", numeroLogradouroPagador=" + this.getNumeroLogradouroPagador() + ", complementoLogradouroPagador=" + this.getComplementoLogradouroPagador() + ", cepPagador=" + this.getCepPagador() + ", complementoCepPagador=" + this.getComplementoCepPagador() + ", bairroPagador=" + this.getBairroPagador() + ", municipioPagador=" + this.getMunicipioPagador() + ", ufPagador=" + this.getUfPagador() + ", indicadorCpfCnpjPagador=" + this.getIndicadorCpfCnpjPagador() + ", cpfcnpjPagador=" + this.getCpfcnpjPagador() + ", enderecoEletronicoPagador=" + this.getEnderecoEletronicoPagador() + ", nomeSacadorAvalista=" + this.getNomeSacadorAvalista() + ", logradouroSacadorAvalista=" + this.getLogradouroSacadorAvalista() + ", numeroLogradouroSacadorAvalista=" + this.getNumeroLogradouroSacadorAvalista() + ", complementoLogradouroSacadorAvalista=" + this.getComplementoLogradouroSacadorAvalista() + ", cepSacadorAvalista=" + this.getCepSacadorAvalista() + ", complementoCepSacadorAvalista=" + this.getComplementoCepSacadorAvalista() + ", bairroSacadorAvalista=" + this.getBairroSacadorAvalista() + ", municipioSacadorAvalista=" + this.getMunicipioSacadorAvalista() + ", ufSacadorAvalista=" + this.getUfSacadorAvalista() + ", indicadorCpfCnpjAvalista=" + this.getIndicadorCpfCnpjAvalista() + ", cpfcnpjSacadorAvalista=" + this.getCpfcnpjSacadorAvalista() + ", enderecoEletronicoSacadorAvalista=" + this.getEnderecoEletronicoSacadorAvalista() + ")";
    }
}

