/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.documento.cda;

import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.dto.enums.TipoFiltroBoolean;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class GeracaoLoteCdaDTO {
    private static final String START_AND_FILTER = " and (";
    @NotNull
    private TipoCadastro tipoCadastro;
    @NotNull
    private String cadastroGeral;
    private String divida;
    private String anoDivida;
    private String subDivida;
    private LivroDTO livro;
    private Pessoa pessoa;
    private Boolean incluiTodosProprietarios = Boolean.FALSE;
    private BigDecimal valorMinimoCertidao = BigDecimal.ZERO;
    private LocalDate vencimentoInicial;
    private LocalDate vencimentoFinal;
    private TipoFiltroBoolean parcelado = TipoFiltroBoolean.TODOS;
    private TipoFiltroBoolean reparcelado = TipoFiltroBoolean.TODOS;
    private Boolean protestado = Boolean.FALSE;
    private Boolean juizo = Boolean.FALSE;
    private Boolean contestado = Boolean.FALSE;
    private LocalDate vencimentoBaseInicial;
    private LocalDate vencimentoBaseFinal;
    private String anoBase;
    private Boolean protestadoBase = Boolean.FALSE;
    private Boolean juizoBase = Boolean.FALSE;
    private Boolean parceladoBase = Boolean.FALSE;
    private Boolean reparceladoBase = Boolean.FALSE;

    public String filtro() {
        StringBuilder filtros = new StringBuilder();
        filtros.append(this.buildFiltroDebitoCdaIdentificacao());
        return filtros.toString();
    }

    public String filterWithValues() {
        return this.buildFiltroDebitoCdaIdentificacao().replace(":tipoCadastro", Objects.nonNull(this.getTipoCadastro()) ? this.getTipoCadastro().getValue().toString() : "").replace(":livro", Objects.nonNull(this.getLivro()) ? this.getLivro().getLivro().toString() : "").replace(":exercicioLivro", Objects.nonNull(this.getLivro()) ? this.getLivro().getExercicio().toString() : "").replace(":pessoa", Objects.nonNull(this.getPessoa()) ? this.getPessoa().getId().toString() : "").replace(":dataVencimentoInicial", Objects.nonNull(this.getVencimentoInicial()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getVencimentoInicial().toString(), (String)"'") : "").replace(":dataVencimentoFinal", Objects.nonNull(this.getVencimentoFinal()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getVencimentoFinal().toString(), (String)"'") : "").replace(":parcelado", Objects.nonNull(this.getParcelado()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getParcelado().getValue(), (String)"'") : "").replace(":reparcelado", Objects.nonNull(this.getReparcelado()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getReparcelado().getValue(), (String)"'") : "").replace(":dataVencimentoBaseInicial", Objects.nonNull(this.getVencimentoBaseInicial()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getVencimentoBaseInicial().toString(), (String)"'") : "").replace(":dataVencimentoBaseFinal", Objects.nonNull(this.getVencimentoBaseFinal()) ? org.apache.commons.lang3.StringUtils.wrap((String)this.getVencimentoBaseFinal().toString(), (String)"'") : "");
    }

    private String buildFiltroDebitoCdaIdentificacao() {
        StringBuilder dtoParams = new StringBuilder();
        dtoParams.append(" and (td.tipocadastro = :tipoCadastro) ");
        dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getCadastroGeral(), (String)"td.cadastrogeral")).append(")");
        if (StringUtils.isNotBlank((String)this.getDivida())) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getDivida(), (String)"td.guiarecolhimento")).append(")");
        }
        if (StringUtils.isNotBlank((String)this.getAnoDivida())) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getAnoDivida(), (String)"td.exercicio")).append(")");
        }
        if (StringUtils.isNotBlank((String)this.getSubDivida())) {
            dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getSubDivida(), (String)"td.subdivida")).append(")");
        }
        if (Objects.nonNull(this.getLivro())) {
            dtoParams.append(" and (tdp.livro = :livro and tdp.exerciciolivro = :exercicioLivro)");
        }
        if (Objects.nonNull(this.getPessoa())) {
            dtoParams.append(" and (cg.pessoa = :pessoa)");
        }
        if (Objects.nonNull(this.getVencimentoInicial())) {
            dtoParams.append(" and (tdp.datavencimento >= :dataVencimentoInicial)");
        }
        if (Objects.nonNull(this.getVencimentoFinal())) {
            dtoParams.append(" and (tdp.datavencimento <= :dataVencimentoFinal)");
        }
        if (!TipoFiltroBoolean.TODOS.equals((Object)this.getParcelado())) {
            dtoParams.append(" and (td.parcelado = :parcelado)");
        }
        if (!TipoFiltroBoolean.TODOS.equals((Object)this.getReparcelado())) {
            dtoParams.append(" and (td.reparcelado = :reparcelado)");
        }
        if (!this.getProtestado().booleanValue()) {
            dtoParams.append(" and (tdp.idprotesto is null or tdp.idprotesto = 0)");
        }
        if (this.getJuizo().booleanValue()) {
            dtoParams.append(" and (tdp.situacaolegal in (1, 2))");
        } else {
            dtoParams.append(" and (tdp.situacaolegal = 1)");
        }
        if (!this.getContestado().booleanValue()) {
            dtoParams.append(" and not exists ( select 1                    from tribcontenciosodebito  tcd                   where tcd.situacao = 'A'                     and tcd.entidade = tdp.entidade                     and tcd.exercicio = tdp.exercicio                     and tcd.tipocadastro = tdp.tipocadastro                     and tcd.cadastrogeral = tdp.cadastrogeral                     and tcd.guiarecolhimento = tdp.guiarecolhimento                     and tcd.subdivida = tdp.subdivida ) ");
        }
        if (this.hasFilterBase()) {
            dtoParams.append("and (exists ( select 1                from tribdebitoparcela dpex                left outer join tribdebito tdex on dpex.entidade                 = tdex.entidade                                               and dpex.exercicio                = tdex.exercicio                                               and dpex.tipocadastro             = tdex.tipocadastro                                               and dpex.cadastrogeral            = tdex.cadastrogeral                                               and dpex.guiarecolhimento         = tdex.guiarecolhimento                                               and dpex.subdivida                = tdex.subdivida                left outer join tribsituacaoparcela tspp on tspp.situacaoparcela           = dpex.situacaodebito                left outer join tribtiposituacaoparcela ttspp on ttspp.tiposituacaoparcela = tspp.tiposituacaoparcela               where dpex.entidade = tdp.entidade                 and dpex.tipocadastro = tdp.tipocadastro                 and dpex.cadastrogeral = tdp.cadastrogeral                 and ttspp.tipo = 'A'");
            if (Objects.nonNull(this.getVencimentoBaseInicial())) {
                dtoParams.append(" and (dpex.datavencimento >= :dataVencimentoBaseInicial) ");
            }
            if (Objects.nonNull(this.getVencimentoBaseFinal())) {
                dtoParams.append(" and (dpex.datavencimento <= :dataVencimentoBaseFinal)");
            }
            if (StringUtils.isNotBlank((String)this.getAnoBase())) {
                dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getAnoBase(), (String)"dpex.exercicio")).append(")");
            }
            if (!this.getProtestadoBase().booleanValue()) {
                dtoParams.append(" and (dpex.idprotesto is null or dpex.idprotesto = 0)");
            }
            if (this.getJuizoBase().booleanValue()) {
                dtoParams.append(" and (dpex.situacaolegal in (1,2))");
            } else {
                dtoParams.append(" and (dpex.situacaolegal = 1)");
            }
            if (!this.getParceladoBase().booleanValue()) {
                dtoParams.append(" and (tdex.parcelado = 'N')");
            }
            if (!this.getReparceladoBase().booleanValue()) {
                dtoParams.append(" and (tdex.reparcelado = 'N')");
            }
            if (StringUtils.isNotBlank((String)this.getDivida())) {
                dtoParams.append(START_AND_FILTER).append(MultiValueFilter.generateFilters((String)this.getDivida(), (String)"dpex.guiarecolhimento")).append(")");
            }
            dtoParams.append("))");
        }
        return dtoParams.toString();
    }

    private boolean hasFilterBase() {
        return Objects.nonNull(this.getVencimentoBaseInicial()) || Objects.nonNull(this.getVencimentoBaseFinal()) || StringUtils.isNotBlank((String)this.getAnoBase()) || this.getProtestadoBase() != false || this.getJuizoBase() != false || this.getParceladoBase() != false || this.getReparceladoBase() != false;
    }

    @Generated
    public GeracaoLoteCdaDTO() {
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getAnoDivida() {
        return this.anoDivida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LivroDTO getLivro() {
        return this.livro;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getIncluiTodosProprietarios() {
        return this.incluiTodosProprietarios;
    }

    @Generated
    public BigDecimal getValorMinimoCertidao() {
        return this.valorMinimoCertidao;
    }

    @Generated
    public LocalDate getVencimentoInicial() {
        return this.vencimentoInicial;
    }

    @Generated
    public LocalDate getVencimentoFinal() {
        return this.vencimentoFinal;
    }

    @Generated
    public TipoFiltroBoolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public TipoFiltroBoolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Boolean getProtestado() {
        return this.protestado;
    }

    @Generated
    public Boolean getJuizo() {
        return this.juizo;
    }

    @Generated
    public Boolean getContestado() {
        return this.contestado;
    }

    @Generated
    public LocalDate getVencimentoBaseInicial() {
        return this.vencimentoBaseInicial;
    }

    @Generated
    public LocalDate getVencimentoBaseFinal() {
        return this.vencimentoBaseFinal;
    }

    @Generated
    public String getAnoBase() {
        return this.anoBase;
    }

    @Generated
    public Boolean getProtestadoBase() {
        return this.protestadoBase;
    }

    @Generated
    public Boolean getJuizoBase() {
        return this.juizoBase;
    }

    @Generated
    public Boolean getParceladoBase() {
        return this.parceladoBase;
    }

    @Generated
    public Boolean getReparceladoBase() {
        return this.reparceladoBase;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setAnoDivida(String anoDivida) {
        this.anoDivida = anoDivida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setLivro(LivroDTO livro) {
        this.livro = livro;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setIncluiTodosProprietarios(Boolean incluiTodosProprietarios) {
        this.incluiTodosProprietarios = incluiTodosProprietarios;
    }

    @Generated
    public void setValorMinimoCertidao(BigDecimal valorMinimoCertidao) {
        this.valorMinimoCertidao = valorMinimoCertidao;
    }

    @Generated
    public void setVencimentoInicial(LocalDate vencimentoInicial) {
        this.vencimentoInicial = vencimentoInicial;
    }

    @Generated
    public void setVencimentoFinal(LocalDate vencimentoFinal) {
        this.vencimentoFinal = vencimentoFinal;
    }

    @Generated
    public void setParcelado(TipoFiltroBoolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(TipoFiltroBoolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setProtestado(Boolean protestado) {
        this.protestado = protestado;
    }

    @Generated
    public void setJuizo(Boolean juizo) {
        this.juizo = juizo;
    }

    @Generated
    public void setContestado(Boolean contestado) {
        this.contestado = contestado;
    }

    @Generated
    public void setVencimentoBaseInicial(LocalDate vencimentoBaseInicial) {
        this.vencimentoBaseInicial = vencimentoBaseInicial;
    }

    @Generated
    public void setVencimentoBaseFinal(LocalDate vencimentoBaseFinal) {
        this.vencimentoBaseFinal = vencimentoBaseFinal;
    }

    @Generated
    public void setAnoBase(String anoBase) {
        this.anoBase = anoBase;
    }

    @Generated
    public void setProtestadoBase(Boolean protestadoBase) {
        this.protestadoBase = protestadoBase;
    }

    @Generated
    public void setJuizoBase(Boolean juizoBase) {
        this.juizoBase = juizoBase;
    }

    @Generated
    public void setParceladoBase(Boolean parceladoBase) {
        this.parceladoBase = parceladoBase;
    }

    @Generated
    public void setReparceladoBase(Boolean reparceladoBase) {
        this.reparceladoBase = reparceladoBase;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeracaoLoteCdaDTO)) {
            return false;
        }
        GeracaoLoteCdaDTO other = (GeracaoLoteCdaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$anoDivida = this.getAnoDivida();
        String other$anoDivida = other.getAnoDivida();
        if (this$anoDivida == null ? other$anoDivida != null : !this$anoDivida.equals(other$anoDivida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LivroDTO this$livro = this.getLivro();
        LivroDTO other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !this$livro.equals(other$livro)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        Boolean this$incluiTodosProprietarios = this.getIncluiTodosProprietarios();
        Boolean other$incluiTodosProprietarios = other.getIncluiTodosProprietarios();
        if (this$incluiTodosProprietarios == null ? other$incluiTodosProprietarios != null : !((Object)this$incluiTodosProprietarios).equals(other$incluiTodosProprietarios)) {
            return false;
        }
        BigDecimal this$valorMinimoCertidao = this.getValorMinimoCertidao();
        BigDecimal other$valorMinimoCertidao = other.getValorMinimoCertidao();
        if (this$valorMinimoCertidao == null ? other$valorMinimoCertidao != null : !((Object)this$valorMinimoCertidao).equals(other$valorMinimoCertidao)) {
            return false;
        }
        LocalDate this$vencimentoInicial = this.getVencimentoInicial();
        LocalDate other$vencimentoInicial = other.getVencimentoInicial();
        if (this$vencimentoInicial == null ? other$vencimentoInicial != null : !((Object)this$vencimentoInicial).equals(other$vencimentoInicial)) {
            return false;
        }
        LocalDate this$vencimentoFinal = this.getVencimentoFinal();
        LocalDate other$vencimentoFinal = other.getVencimentoFinal();
        if (this$vencimentoFinal == null ? other$vencimentoFinal != null : !((Object)this$vencimentoFinal).equals(other$vencimentoFinal)) {
            return false;
        }
        TipoFiltroBoolean this$parcelado = this.getParcelado();
        TipoFiltroBoolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !this$parcelado.equals(other$parcelado)) {
            return false;
        }
        TipoFiltroBoolean this$reparcelado = this.getReparcelado();
        TipoFiltroBoolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !this$reparcelado.equals(other$reparcelado)) {
            return false;
        }
        Boolean this$protestado = this.getProtestado();
        Boolean other$protestado = other.getProtestado();
        if (this$protestado == null ? other$protestado != null : !((Object)this$protestado).equals(other$protestado)) {
            return false;
        }
        Boolean this$juizo = this.getJuizo();
        Boolean other$juizo = other.getJuizo();
        if (this$juizo == null ? other$juizo != null : !((Object)this$juizo).equals(other$juizo)) {
            return false;
        }
        Boolean this$contestado = this.getContestado();
        Boolean other$contestado = other.getContestado();
        if (this$contestado == null ? other$contestado != null : !((Object)this$contestado).equals(other$contestado)) {
            return false;
        }
        LocalDate this$vencimentoBaseInicial = this.getVencimentoBaseInicial();
        LocalDate other$vencimentoBaseInicial = other.getVencimentoBaseInicial();
        if (this$vencimentoBaseInicial == null ? other$vencimentoBaseInicial != null : !((Object)this$vencimentoBaseInicial).equals(other$vencimentoBaseInicial)) {
            return false;
        }
        LocalDate this$vencimentoBaseFinal = this.getVencimentoBaseFinal();
        LocalDate other$vencimentoBaseFinal = other.getVencimentoBaseFinal();
        if (this$vencimentoBaseFinal == null ? other$vencimentoBaseFinal != null : !((Object)this$vencimentoBaseFinal).equals(other$vencimentoBaseFinal)) {
            return false;
        }
        String this$anoBase = this.getAnoBase();
        String other$anoBase = other.getAnoBase();
        if (this$anoBase == null ? other$anoBase != null : !this$anoBase.equals(other$anoBase)) {
            return false;
        }
        Boolean this$protestadoBase = this.getProtestadoBase();
        Boolean other$protestadoBase = other.getProtestadoBase();
        if (this$protestadoBase == null ? other$protestadoBase != null : !((Object)this$protestadoBase).equals(other$protestadoBase)) {
            return false;
        }
        Boolean this$juizoBase = this.getJuizoBase();
        Boolean other$juizoBase = other.getJuizoBase();
        if (this$juizoBase == null ? other$juizoBase != null : !((Object)this$juizoBase).equals(other$juizoBase)) {
            return false;
        }
        Boolean this$parceladoBase = this.getParceladoBase();
        Boolean other$parceladoBase = other.getParceladoBase();
        if (this$parceladoBase == null ? other$parceladoBase != null : !((Object)this$parceladoBase).equals(other$parceladoBase)) {
            return false;
        }
        Boolean this$reparceladoBase = this.getReparceladoBase();
        Boolean other$reparceladoBase = other.getReparceladoBase();
        return !(this$reparceladoBase == null ? other$reparceladoBase != null : !((Object)this$reparceladoBase).equals(other$reparceladoBase));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeracaoLoteCdaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $anoDivida = this.getAnoDivida();
        result = result * 59 + ($anoDivida == null ? 43 : $anoDivida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LivroDTO $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : $livro.hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        Boolean $incluiTodosProprietarios = this.getIncluiTodosProprietarios();
        result = result * 59 + ($incluiTodosProprietarios == null ? 43 : ((Object)$incluiTodosProprietarios).hashCode());
        BigDecimal $valorMinimoCertidao = this.getValorMinimoCertidao();
        result = result * 59 + ($valorMinimoCertidao == null ? 43 : ((Object)$valorMinimoCertidao).hashCode());
        LocalDate $vencimentoInicial = this.getVencimentoInicial();
        result = result * 59 + ($vencimentoInicial == null ? 43 : ((Object)$vencimentoInicial).hashCode());
        LocalDate $vencimentoFinal = this.getVencimentoFinal();
        result = result * 59 + ($vencimentoFinal == null ? 43 : ((Object)$vencimentoFinal).hashCode());
        TipoFiltroBoolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : $parcelado.hashCode());
        TipoFiltroBoolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : $reparcelado.hashCode());
        Boolean $protestado = this.getProtestado();
        result = result * 59 + ($protestado == null ? 43 : ((Object)$protestado).hashCode());
        Boolean $juizo = this.getJuizo();
        result = result * 59 + ($juizo == null ? 43 : ((Object)$juizo).hashCode());
        Boolean $contestado = this.getContestado();
        result = result * 59 + ($contestado == null ? 43 : ((Object)$contestado).hashCode());
        LocalDate $vencimentoBaseInicial = this.getVencimentoBaseInicial();
        result = result * 59 + ($vencimentoBaseInicial == null ? 43 : ((Object)$vencimentoBaseInicial).hashCode());
        LocalDate $vencimentoBaseFinal = this.getVencimentoBaseFinal();
        result = result * 59 + ($vencimentoBaseFinal == null ? 43 : ((Object)$vencimentoBaseFinal).hashCode());
        String $anoBase = this.getAnoBase();
        result = result * 59 + ($anoBase == null ? 43 : $anoBase.hashCode());
        Boolean $protestadoBase = this.getProtestadoBase();
        result = result * 59 + ($protestadoBase == null ? 43 : ((Object)$protestadoBase).hashCode());
        Boolean $juizoBase = this.getJuizoBase();
        result = result * 59 + ($juizoBase == null ? 43 : ((Object)$juizoBase).hashCode());
        Boolean $parceladoBase = this.getParceladoBase();
        result = result * 59 + ($parceladoBase == null ? 43 : ((Object)$parceladoBase).hashCode());
        Boolean $reparceladoBase = this.getReparceladoBase();
        result = result * 59 + ($reparceladoBase == null ? 43 : ((Object)$reparceladoBase).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeracaoLoteCdaDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", anoDivida=" + this.getAnoDivida() + ", subDivida=" + this.getSubDivida() + ", livro=" + this.getLivro() + ", pessoa=" + this.getPessoa() + ", incluiTodosProprietarios=" + this.getIncluiTodosProprietarios() + ", valorMinimoCertidao=" + this.getValorMinimoCertidao() + ", vencimentoInicial=" + this.getVencimentoInicial() + ", vencimentoFinal=" + this.getVencimentoFinal() + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ", protestado=" + this.getProtestado() + ", juizo=" + this.getJuizo() + ", contestado=" + this.getContestado() + ", vencimentoBaseInicial=" + this.getVencimentoBaseInicial() + ", vencimentoBaseFinal=" + this.getVencimentoBaseFinal() + ", anoBase=" + this.getAnoBase() + ", protestadoBase=" + this.getProtestadoBase() + ", juizoBase=" + this.getJuizoBase() + ", parceladoBase=" + this.getParceladoBase() + ", reparceladoBase=" + this.getReparceladoBase() + ")";
    }
}

