/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.DebitoParcelaObservacaoId;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DebitoManualParcelaDTO {
    @NotNull(message="Informe o n\u00famero da parcela")
    private @NotNull(message="Informe o n\u00famero da parcela") Long parcela;
    @NotNull(message="Informe a situa\u00e7\u00e3o da parcela")
    private @NotNull(message="Informe a situa\u00e7\u00e3o da parcela") Long situacao;
    private Long situacaoLegal;
    @NotNull(message="Informe a data de vencimento da parcela")
    private @NotNull(message="Informe a data de vencimento da parcela") LocalDate dataVencimento;
    @NotNull(message="Informe o valor da parcela")
    private @NotNull(message="Informe o valor da parcela") BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    private LocalDate dataSituacao;
    private String observacao;
    private Long mesReferencia;
    private Long anoReferencia;
    private Long livro;
    private Long exercicioLivro;
    private Long numeroInscricao;
    private Long numeroFolha;
    private LocalDate dataDividaAtiva;

    public DebitoParcela toEntity(String usuario, LocalDate dataLancamento) {
        DebitoParcela debitoParcela = new DebitoParcela();
        DebitoParcelaId debitoParcelaId = new DebitoParcelaId();
        debitoParcelaId.setParcela(this.getParcela());
        SituacaoParcela situacaoParcela = new SituacaoParcela();
        situacaoParcela.setId(this.getSituacao());
        debitoParcela.setDataVencimento(this.getDataVencimento());
        debitoParcela.setId(debitoParcelaId);
        debitoParcela.setDataLancamento(dataLancamento);
        debitoParcela.setSituacaoDebito(situacaoParcela);
        Optional.ofNullable(this.getSituacaoLegal()).ifPresent(situacaoLegalPresent -> debitoParcela.setSituacaoLegal(SituacaoLegal.fromValue((Integer)situacaoLegalPresent.intValue())));
        debitoParcela.setLivro(this.getLivro());
        debitoParcela.setExercicioLivro(this.getExercicioLivro());
        debitoParcela.setNumeroInscricao(this.getNumeroInscricao());
        debitoParcela.setNumeroFolha(this.getNumeroFolha());
        debitoParcela.setDataDividaAtiva(this.getDataDividaAtiva());
        debitoParcela.setDataSituacao(dataLancamento);
        if (Objects.nonNull(this.mesReferencia)) {
            debitoParcela.setMesReferencia(this.mesReferencia);
        }
        if (Objects.nonNull(this.anoReferencia)) {
            debitoParcela.setAnoReferencia(this.anoReferencia);
        }
        if (!Objects.isNull(this.getObservacao()) && !this.getObservacao().isEmpty()) {
            DebitoParcelaObservacao parcelaObservacao = new DebitoParcelaObservacao();
            DebitoParcelaObservacaoId debitoParcelaObservacaoId = new DebitoParcelaObservacaoId();
            debitoParcelaObservacaoId.setSequencia(Long.valueOf(1L));
            debitoParcelaObservacaoId.setParcela(debitoParcela.getId().getParcela());
            parcelaObservacao.setId(debitoParcelaObservacaoId);
            parcelaObservacao.setDataInclusao(LocalDate.now());
            parcelaObservacao.setUsuario(usuario);
            parcelaObservacao.setObservacao(this.getObservacao());
            debitoParcela.getObservacoes().add(parcelaObservacao);
        }
        return debitoParcela;
    }

    public DebitoTributo toDebitoTributo(DividaTributo tributo) {
        DebitoTributo debitoTributo = new DebitoTributo();
        DebitoTributoId id = new DebitoTributoId();
        id.setTributo(tributo.getId().getTributo());
        debitoTributo.setId(id);
        debitoTributo.setOrdem(tributo.getOrdem());
        debitoTributo.setValorBaseCalculo(this.getValorBaseCalculo());
        debitoTributo.setValorTributo(this.getValor());
        return debitoTributo;
    }

    public DebitoParcela toDebitoParcelaISS(String usuario, LocalDate dataLancamento, Long exercicio) {
        DebitoParcela debitoParcela = new DebitoParcela();
        DebitoParcelaId debitoParcelaId = new DebitoParcelaId();
        debitoParcelaId.setParcela(Long.valueOf(1L));
        debitoParcela.setId(debitoParcelaId);
        debitoParcela.setDataVencimento(this.getDataVencimento());
        debitoParcela.setDataLancamento(dataLancamento);
        debitoParcela.setDataSituacao(dataLancamento);
        debitoParcela.setMesReferencia(this.getParcela());
        Optional.ofNullable(this.mesReferencia).ifPresent(arg_0 -> ((DebitoParcela)debitoParcela).setMesReferencia(arg_0));
        debitoParcela.setAnoReferencia(exercicio);
        if (StringUtils.isNotBlank((CharSequence)this.observacao)) {
            DebitoParcelaObservacaoId debitoParcelaObservacaoId = new DebitoParcelaObservacaoId();
            debitoParcelaObservacaoId.setSequencia(Long.valueOf(1L));
            debitoParcelaObservacaoId.setParcela(debitoParcela.getId().getParcela());
            DebitoParcelaObservacao debitoParcelaObservacao = new DebitoParcelaObservacao();
            debitoParcelaObservacao.setId(debitoParcelaObservacaoId);
            debitoParcelaObservacao.setObservacao(this.observacao);
            debitoParcelaObservacao.setDataInclusao(LocalDate.now());
            debitoParcelaObservacao.setUsuario(usuario);
            debitoParcela.getObservacoes().add(debitoParcelaObservacao);
        }
        return debitoParcela;
    }

    public static DebitoManualParcelaDTO fromGerarDebitoRequestDTO(GerarDebitoRequestDTO debito) {
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(Long.valueOf(1L));
        debitoManualParcelaDTO.setSituacao(Long.valueOf(SituacaoLegal.NO_EXERCICIO.getCodigo().longValue()));
        debitoManualParcelaDTO.setDataVencimento(debito.getDataVencimento());
        debitoManualParcelaDTO.setValor(debito.getValorPrincipal());
        return debitoManualParcelaDTO;
    }

    @Generated
    public DebitoManualParcelaDTO() {
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getMesReferencia() {
        return this.mesReferencia;
    }

    @Generated
    public Long getAnoReferencia() {
        return this.anoReferencia;
    }

    @Generated
    public Long getLivro() {
        return this.livro;
    }

    @Generated
    public Long getExercicioLivro() {
        return this.exercicioLivro;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public LocalDate getDataDividaAtiva() {
        return this.dataDividaAtiva;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setSituacao(Long situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMesReferencia(Long mesReferencia) {
        this.mesReferencia = mesReferencia;
    }

    @Generated
    public void setAnoReferencia(Long anoReferencia) {
        this.anoReferencia = anoReferencia;
    }

    @Generated
    public void setLivro(Long livro) {
        this.livro = livro;
    }

    @Generated
    public void setExercicioLivro(Long exercicioLivro) {
        this.exercicioLivro = exercicioLivro;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public void setDataDividaAtiva(LocalDate dataDividaAtiva) {
        this.dataDividaAtiva = dataDividaAtiva;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoManualParcelaDTO)) {
            return false;
        }
        DebitoManualParcelaDTO other = (DebitoManualParcelaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$situacao = this.getSituacao();
        Long other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorBaseCalculo = this.getValorBaseCalculo();
        BigDecimal other$valorBaseCalculo = other.getValorBaseCalculo();
        if (this$valorBaseCalculo == null ? other$valorBaseCalculo != null : !((Object)this$valorBaseCalculo).equals(other$valorBaseCalculo)) {
            return false;
        }
        LocalDate this$dataSituacao = this.getDataSituacao();
        LocalDate other$dataSituacao = other.getDataSituacao();
        if (this$dataSituacao == null ? other$dataSituacao != null : !((Object)this$dataSituacao).equals(other$dataSituacao)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        Long this$mesReferencia = this.getMesReferencia();
        Long other$mesReferencia = other.getMesReferencia();
        if (this$mesReferencia == null ? other$mesReferencia != null : !((Object)this$mesReferencia).equals(other$mesReferencia)) {
            return false;
        }
        Long this$anoReferencia = this.getAnoReferencia();
        Long other$anoReferencia = other.getAnoReferencia();
        if (this$anoReferencia == null ? other$anoReferencia != null : !((Object)this$anoReferencia).equals(other$anoReferencia)) {
            return false;
        }
        Long this$livro = this.getLivro();
        Long other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !((Object)this$livro).equals(other$livro)) {
            return false;
        }
        Long this$exercicioLivro = this.getExercicioLivro();
        Long other$exercicioLivro = other.getExercicioLivro();
        if (this$exercicioLivro == null ? other$exercicioLivro != null : !((Object)this$exercicioLivro).equals(other$exercicioLivro)) {
            return false;
        }
        Long this$numeroInscricao = this.getNumeroInscricao();
        Long other$numeroInscricao = other.getNumeroInscricao();
        if (this$numeroInscricao == null ? other$numeroInscricao != null : !((Object)this$numeroInscricao).equals(other$numeroInscricao)) {
            return false;
        }
        Long this$numeroFolha = this.getNumeroFolha();
        Long other$numeroFolha = other.getNumeroFolha();
        if (this$numeroFolha == null ? other$numeroFolha != null : !((Object)this$numeroFolha).equals(other$numeroFolha)) {
            return false;
        }
        LocalDate this$dataDividaAtiva = this.getDataDividaAtiva();
        LocalDate other$dataDividaAtiva = other.getDataDividaAtiva();
        return !(this$dataDividaAtiva == null ? other$dataDividaAtiva != null : !((Object)this$dataDividaAtiva).equals(other$dataDividaAtiva));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoManualParcelaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorBaseCalculo = this.getValorBaseCalculo();
        result = result * 59 + ($valorBaseCalculo == null ? 43 : ((Object)$valorBaseCalculo).hashCode());
        LocalDate $dataSituacao = this.getDataSituacao();
        result = result * 59 + ($dataSituacao == null ? 43 : ((Object)$dataSituacao).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        Long $mesReferencia = this.getMesReferencia();
        result = result * 59 + ($mesReferencia == null ? 43 : ((Object)$mesReferencia).hashCode());
        Long $anoReferencia = this.getAnoReferencia();
        result = result * 59 + ($anoReferencia == null ? 43 : ((Object)$anoReferencia).hashCode());
        Long $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : ((Object)$livro).hashCode());
        Long $exercicioLivro = this.getExercicioLivro();
        result = result * 59 + ($exercicioLivro == null ? 43 : ((Object)$exercicioLivro).hashCode());
        Long $numeroInscricao = this.getNumeroInscricao();
        result = result * 59 + ($numeroInscricao == null ? 43 : ((Object)$numeroInscricao).hashCode());
        Long $numeroFolha = this.getNumeroFolha();
        result = result * 59 + ($numeroFolha == null ? 43 : ((Object)$numeroFolha).hashCode());
        LocalDate $dataDividaAtiva = this.getDataDividaAtiva();
        result = result * 59 + ($dataDividaAtiva == null ? 43 : ((Object)$dataDividaAtiva).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoManualParcelaDTO(parcela=" + this.getParcela() + ", situacao=" + this.getSituacao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", valorBaseCalculo=" + this.getValorBaseCalculo() + ", dataSituacao=" + this.getDataSituacao() + ", observacao=" + this.getObservacao() + ", mesReferencia=" + this.getMesReferencia() + ", anoReferencia=" + this.getAnoReferencia() + ", livro=" + this.getLivro() + ", exercicioLivro=" + this.getExercicioLivro() + ", numeroInscricao=" + this.getNumeroInscricao() + ", numeroFolha=" + this.getNumeroFolha() + ", dataDividaAtiva=" + this.getDataDividaAtiva() + ")";
    }
}

