/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.protesto;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.protesto.ProtestoItem;
import br.com.elotech.tributos.domain.protesto.ProtestoMotivoCancelamento;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Entity
@Table(name="TRIBPROTESTO")
public class Protesto
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_protesto")
    @Column(name="idprotesto")
    private Long id;
    @Column(nullable=false, precision=10)
    private Long entidade;
    @Column(nullable=false, precision=10)
    private Long exercicio;
    @Column(nullable=false, precision=10)
    private Long protesto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exerciciodocumento", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="tipodocumento", referencedColumnName="tipodocumento")), @JoinColumnOrFormula(column=@JoinColumn(name="documento", referencedColumnName="documento"))})
    private Documento documento;
    @Column
    private LocalDate dataEmissao;
    @Column(precision=10)
    private Long exercicioProcesso;
    @Column(precision=10)
    private Long idProcesso;
    @Column(length=250)
    private String usuario;
    @Column(length=2)
    @Enumerated(value=EnumType.STRING)
    private SituacaoProtesto situacao;
    @Column
    private LocalDate dataCancelamento;
    @Column(length=250)
    private String usuarioCancelamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="anu_exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="anu_tipo", referencedColumnName="tipodocumento")), @JoinColumnOrFormula(column=@JoinColumn(name="anu_documento", referencedColumnName="documento"))})
    private Documento anuDocumento;
    @Column(length=400)
    private String observacaoCancelamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idprotestomotivocancelamento")
    private ProtestoMotivoCancelamento idProtestomotivoCancelamento;
    @JsonIgnore
    @OneToMany(mappedBy="id.protesto", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProtestoItem> protestoItems = new ArrayList();
    @ManyToOne
    @JoinColumn(name="idjobgeracao", referencedColumnName="job_execution_id")
    private BatchJobExecution batchJobExecutionSimulacao;

    public static Protesto from(Documento documento, Long exercicio, Long entidade, String usuario) {
        Protesto protesto = new Protesto();
        protesto.setDocumento(documento);
        protesto.setExercicio(exercicio);
        protesto.setEntidade(entidade);
        protesto.setDataEmissao(LocalDate.now());
        protesto.setUsuario(usuario);
        return protesto;
    }

    @Generated
    public Protesto() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getProtesto() {
        return this.protesto;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public SituacaoProtesto getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public Documento getAnuDocumento() {
        return this.anuDocumento;
    }

    @Generated
    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    @Generated
    public ProtestoMotivoCancelamento getIdProtestomotivoCancelamento() {
        return this.idProtestomotivoCancelamento;
    }

    @Generated
    public List<ProtestoItem> getProtestoItems() {
        return this.protestoItems;
    }

    @Generated
    public BatchJobExecution getBatchJobExecutionSimulacao() {
        return this.batchJobExecutionSimulacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setProtesto(Long protesto) {
        this.protesto = protesto;
    }

    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setSituacao(SituacaoProtesto situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setAnuDocumento(Documento anuDocumento) {
        this.anuDocumento = anuDocumento;
    }

    @Generated
    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    @Generated
    public void setIdProtestomotivoCancelamento(ProtestoMotivoCancelamento idProtestomotivoCancelamento) {
        this.idProtestomotivoCancelamento = idProtestomotivoCancelamento;
    }

    @Generated
    public void setProtestoItems(List<ProtestoItem> protestoItems) {
        this.protestoItems = protestoItems;
    }

    @Generated
    public void setBatchJobExecutionSimulacao(BatchJobExecution batchJobExecutionSimulacao) {
        this.batchJobExecutionSimulacao = batchJobExecutionSimulacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Protesto)) {
            return false;
        }
        Protesto other = (Protesto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Protesto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Protesto(id=" + this.getId() + ")";
    }
}

